/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Relationship;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.impl.AbstractApp;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ls
extends GraphDatabaseApp {
    public Ls() {
        this.addValueType("d", new AbstractApp.OptionContext(OptionValueType.MUST, "Direction filter for relationships: " + this.directionAlternatives()));
        this.addValueType("v", new AbstractApp.OptionContext(OptionValueType.NONE, "Verbose mode"));
        this.addValueType("q", new AbstractApp.OptionContext(OptionValueType.NONE, "Quiet mode"));
        this.addValueType("p", new AbstractApp.OptionContext(OptionValueType.NONE, "Lists properties"));
        this.addValueType("r", new AbstractApp.OptionContext(OptionValueType.NONE, "Lists relationships"));
        this.addValueType("f", new AbstractApp.OptionContext(OptionValueType.MUST, "Filters node property keys/values. Supplied either as a single value\nor as a JSON string where both keys and values can contain regex.\nStarting/ending {} brackets are optional. Examples:\n\"username\"\n   property/relationship 'username' gets listed\n\".*name: ma.*, age: ''\"\n   properties with keys matching '.*name' and values matching 'ma.*'\n   gets listed, as well as the 'age' property. Also relationships\n   matching '.*name' or 'age' gets listed"));
        this.addValueType("i", new AbstractApp.OptionContext(OptionValueType.NONE, "Filters are case-insensitive (case-sensitive by default)"));
        this.addValueType("l", new AbstractApp.OptionContext(OptionValueType.NONE, "Filters matches more loosely, i.e. it's considered a match if just\na part of a value matches the pattern, not necessarily the whole value"));
    }

    @Override
    public String getDescription() {
        return "Lists the contents of the current node or relationship. Optionally supply\nnode id for listing a certain node using \"ls <node-id>\"";
    }

    @Override
    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        boolean verbose = parser.options().containsKey("v");
        boolean displayValues = verbose || !parser.options().containsKey("q");
        boolean displayProperties = parser.options().containsKey("p");
        boolean displayRelationships = parser.options().containsKey("r");
        boolean caseInsensitiveFilters = parser.options().containsKey("i");
        boolean looseFilters = parser.options().containsKey("l");
        String filterString = parser.options().get("f");
        Map<String, Object> filterMap = Ls.parseFilter(filterString, out);
        if (!displayProperties && !displayRelationships) {
            displayProperties = true;
            displayRelationships = true;
        }
        NodeOrRelationship thing = null;
        thing = parser.arguments().isEmpty() ? this.getCurrent(session) : NodeOrRelationship.wrap(this.getNodeById(Long.parseLong(parser.arguments().get(0))));
        if (displayProperties) {
            this.displayProperties(thing, out, displayValues, verbose, filterMap, caseInsensitiveFilters, looseFilters);
        }
        if (displayRelationships) {
            this.displayRelationships(parser, thing, session, out, verbose, filterMap, caseInsensitiveFilters, looseFilters);
        }
        return null;
    }

    private Iterable<String> sortKeys(Iterable<String> source) {
        ArrayList<String> list = new ArrayList<String>();
        for (String item : source) {
            list.add(item);
        }
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String item1, String item2) {
                return item1.toLowerCase().compareTo(item2.toLowerCase());
            }
        });
        return list;
    }

    private Iterable<Relationship> sortRelationships(Iterable<Relationship> source) {
        TreeMap<String, ArrayList<Relationship>> map = new TreeMap<String, ArrayList<Relationship>>();
        for (Relationship rel : source) {
            String type = rel.getType().name().toLowerCase();
            ArrayList<Relationship> rels = (ArrayList<Relationship>)map.get(type);
            if (rels == null) {
                rels = new ArrayList<Relationship>();
                map.put(type, rels);
            }
            rels.add(rel);
        }
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        for (Collection rels : map.values()) {
            result.addAll(rels);
        }
        return result;
    }

    private void displayProperties(NodeOrRelationship thing, Output out, boolean displayValues, boolean verbose, Map<String, Object> filterMap, boolean caseInsensitiveFilters, boolean looseFilters) throws RemoteException {
        int longestKey = Ls.findLongestKey(thing);
        for (String key : this.sortKeys(thing.getPropertyKeys())) {
            boolean matches = filterMap.isEmpty();
            Object value = thing.getProperty(key);
            for (Map.Entry<String, Object> filter : filterMap.entrySet()) {
                String filterValue;
                if (!Ls.matches(Ls.newPattern(filter.getKey(), caseInsensitiveFilters), key, caseInsensitiveFilters, looseFilters) || !Ls.matches(Ls.newPattern(filterValue = filter.getValue() != null ? filter.getValue().toString() : null, caseInsensitiveFilters), value.toString(), caseInsensitiveFilters, looseFilters)) continue;
                matches = true;
                break;
            }
            if (!matches) continue;
            out.print((Serializable)((Object)("*" + key)));
            if (displayValues) {
                this.printMany(out, " ", longestKey - key.length() + 1);
                out.print((Serializable)((Object)("=" + Ls.format(value, true))));
                if (verbose) {
                    out.print((Serializable)((Object)(" (" + Ls.getNiceType(value) + ")")));
                }
            }
            out.println((Serializable)((Object)""));
        }
    }

    private void displayRelationships(AppCommandParser parser, NodeOrRelationship thing, Session session, Output out, boolean verbose, Map<String, Object> filterMap, boolean caseInsensitiveFilters, boolean looseFilters) throws ShellException, RemoteException {
        boolean displayIncoming;
        String directionFilter = parser.options().get("d");
        Direction direction = this.getDirection(directionFilter);
        boolean displayOutgoing = directionFilter == null || direction == Direction.OUTGOING;
        boolean bl = displayIncoming = directionFilter == null || direction == Direction.INCOMING;
        if (displayOutgoing) {
            this.displayRelationships(thing, session, out, verbose, Direction.OUTGOING, "--", "-->", filterMap, caseInsensitiveFilters, looseFilters);
        }
        if (displayIncoming) {
            this.displayRelationships(thing, session, out, verbose, Direction.INCOMING, "<--", "--", filterMap, caseInsensitiveFilters, looseFilters);
        }
    }

    private void displayRelationships(NodeOrRelationship thing, Session session, Output out, boolean verbose, Direction direction, String prefixString, String postfixString, Map<String, Object> filterMap, boolean caseInsensitiveFilters, boolean looseFilters) throws ShellException, RemoteException {
        for (Relationship rel : this.sortRelationships(thing.getRelationships(direction))) {
            String type = rel.getType().name();
            boolean matches = filterMap.isEmpty();
            for (String filter : filterMap.keySet()) {
                if (!Ls.matches(Ls.newPattern(filter, caseInsensitiveFilters), type, caseInsensitiveFilters, looseFilters)) continue;
                matches = true;
                break;
            }
            if (!matches) continue;
            StringBuffer buf = new StringBuffer(Ls.getDisplayName(this.getServer(), session, thing, true));
            buf.append(" " + prefixString).append(Ls.getDisplayName(this.getServer(), session, rel, verbose, true));
            buf.append(postfixString + " ");
            buf.append(Ls.getDisplayName(this.getServer(), session, direction == Direction.OUTGOING ? rel.getEndNode() : rel.getStartNode(), true));
            out.println(buf);
        }
    }

    private static String getNiceType(Object value) {
        return Set.getValueTypeName(value.getClass());
    }

    private static int findLongestKey(NodeOrRelationship thing) {
        int length = 0;
        for (String key : thing.getPropertyKeys()) {
            if (key.length() <= length) continue;
            length = key.length();
        }
        return length;
    }
}

