/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.impl.AbstractApp;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;

public class Mkrel
extends GraphDatabaseApp {
    public Mkrel() {
        this.addValueType("t", new AbstractApp.OptionContext(OptionValueType.MUST, "The relationship type"));
        this.addValueType("n", new AbstractApp.OptionContext(OptionValueType.MUST, "The node id to connect to"));
        this.addValueType("d", new AbstractApp.OptionContext(OptionValueType.MUST, "The direction: " + this.directionAlternatives() + "."));
        this.addValueType("c", new AbstractApp.OptionContext(OptionValueType.NONE, "Supplied if there should be created a new node"));
        this.addValueType("v", new AbstractApp.OptionContext(OptionValueType.NONE, "Verbose mode: display created nodes/relationships"));
    }

    public String getDescription() {
        return "Creates a relationship to a node";
    }

    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        this.assertCurrentIsNode(session);
        boolean createNode = parser.options().containsKey("c");
        boolean suppliedNode = parser.options().containsKey("n");
        Node node = null;
        if (createNode) {
            node = this.getServer().getDb().createNode();
        } else if (suppliedNode) {
            node = this.getNodeById(Long.parseLong(parser.options().get("n")));
        } else {
            throw new ShellException("Must either create node (-c) or supply node id (-n <id>)");
        }
        if (parser.options().get("t") == null) {
            throw new ShellException("Must supply relationship type (-t <relationship-type-name>)");
        }
        RelationshipType type = this.getRelationshipType(parser.options().get("t"));
        Direction direction = this.getDirection(parser.options().get("d"));
        Node currentNode = this.getCurrent(session).asNode();
        Node startNode = direction == Direction.OUTGOING ? currentNode : node;
        Node endNode = direction == Direction.OUTGOING ? node : currentNode;
        Relationship relationship = startNode.createRelationshipTo(endNode, type);
        boolean verbose = parser.options().containsKey("v");
        if (createNode && verbose) {
            out.println((Serializable)((Object)("Node " + Mkrel.getDisplayName(this.getServer(), session, node, false) + " created")));
        }
        if (verbose) {
            out.println((Serializable)((Object)("Relationship " + Mkrel.getDisplayName(this.getServer(), session, relationship, true, false) + " created")));
        }
        return null;
    }
}

