/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.Cd;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TypedId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pwd
extends GraphDatabaseApp {
    @Override
    public String getDescription() {
        return "Prints path to current node or relatioship";
    }

    @Override
    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        NodeOrRelationship current = this.getCurrent(session);
        out.println((Serializable)((Object)("Current is " + Pwd.getDisplayName(this.getServer(), session, current, false))));
        String path = this.stringifyPath(Cd.readPaths(session), session);
        if (path.length() > 0) {
            out.println((Serializable)((Object)path));
        }
        return null;
    }

    private String stringifyPath(List<TypedId> pathIds, Session session) throws ShellException {
        if (pathIds.isEmpty()) {
            return "";
        }
        StringBuilder path = new StringBuilder();
        for (TypedId id : pathIds) {
            path.append(Pwd.getDisplayName(this.getServer(), session, id, false)).append("-->");
        }
        return path.append(Pwd.getDisplayName(this.getServer(), session, this.getCurrent(session), true)).toString();
    }
}

