/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core;

import fr.unistra.ibmc.paradise.core.AbstractDocumentable;
import fr.unistra.ibmc.paradise.core.ArchitectureException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.Protein;
import fr.unistra.ibmc.paradise.core.Source;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMolecule
extends AbstractDocumentable
implements Molecule {
    private transient List<Molecule.Annotation> annotations;
    private List<Molecule.Annotation> backupAnnotations;
    protected List<ParadiseFeature> selectedFeatures;
    protected String name = "?";
    protected StringBuffer sequence;
    protected ParadiseID paradiseID;
    protected transient ParadiseWorkingSession workingSession;
    protected Source source;
    protected File associatedFile;

    protected AbstractMolecule(ParadiseID paradiseID, ParadiseWorkingSession workingSession, String name, Source source) {
        this.workingSession = workingSession;
        this.paradiseID = paradiseID;
        this.setName(name);
        this.source = source;
        this.annotations = new ArrayList<Molecule.Annotation>();
        this.backupAnnotations = new ArrayList<Molecule.Annotation>();
        this.selectedFeatures = new ArrayList<ParadiseFeature>();
        this.sequence = new StringBuffer();
        this.comments = new ArrayList();
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public void setSource(Source source) {
        this.source = source;
    }

    @Override
    public void setAssociatedFile(File file) {
        this.associatedFile = file;
    }

    @Override
    public File getAssociatedFile() {
        return this.associatedFile;
    }

    @Override
    public Molecule searchCopy(List<Molecule> molecules) {
        for (Molecule _m : molecules) {
            if (!this.getParadiseID().equals(_m.getParadiseID())) continue;
            return _m;
        }
        for (Molecule _m : molecules) {
            if (!this.printSequence().equals(_m.printSequence())) continue;
            return _m;
        }
        return null;
    }

    @Override
    public void makeAllAnnotationsPersistent() {
        this.backupAnnotations.addAll(this.annotations);
    }

    @Override
    public void makeAllAnnotationsNotPersistent() {
        this.backupAnnotations.clear();
    }

    @Override
    public void recoverBackupAnnotations() {
        this.annotations = new ArrayList<Molecule.Annotation>();
        this.annotations.addAll(this.backupAnnotations);
    }

    @Override
    public void addFeature(ParadiseFeature feature, Location l) throws ArchitectureException {
        if (l.getEnd() > this.getLength()) {
            throw new ArchitectureException("Location to add to a feature outside of a molecule boundaries " + l.getEnd() + " > " + this.getLength(), this, l, feature);
        }
        if (this.getAnnotation(feature) != null) {
            this.getAnnotation(feature).addToLocation(l);
            return;
        }
        AnnotationImpl a = new AnnotationImpl(feature, l);
        a.molecule = this;
        if (this.annotations == null) {
            this.annotations = new ArrayList<Molecule.Annotation>();
        }
        this.annotations.add(a);
        try {
            feature.addAnnotation(a);
        }
        catch (ArchitectureException e) {
            a.molecule = null;
            this.annotations.remove(a);
            throw e;
        }
    }

    @Override
    public void moveFeature(ParadiseFeature feature, Location l) throws ArchitectureException {
        if (l.getEnd() > this.getLength()) {
            throw new ArchitectureException("Location to add to a feature outside of a molecule boundaries " + l.getEnd() + " > " + this.getLength(), this, l, feature);
        }
        Location previousLocation = feature.getFullLocation(this);
        if (previousLocation != null) {
            feature.addToLocation(l, this);
            feature.removeFromLocation(previousLocation.differenceOf(l), this);
        }
    }

    @Override
    public void removeFeature(ParadiseFeature feature) {
        if (this.annotations == null) {
            return;
        }
        AnnotationImpl hit = null;
        for (Molecule.Annotation a : this.annotations) {
            if (!a.getFeature().equals(feature)) continue;
            hit = (AnnotationImpl)a;
            break;
        }
        if (hit != null) {
            this.annotations.remove(hit);
            feature.removeAnnotation(hit);
            hit.molecule = null;
        }
    }

    @Override
    public boolean isSelected(ParadiseFeature feature) {
        return this.selectedFeatures.contains(feature);
    }

    @Override
    public void addSelectedFeature(ParadiseFeature feature) {
        this.selectedFeatures.add(feature);
    }

    @Override
    public void removeSelectedFeature(ParadiseFeature feature) {
        this.selectedFeatures.remove(feature);
    }

    @Override
    public void removeAllSelectedFeatures() {
        this.selectedFeatures.clear();
    }

    @Override
    public List<ParadiseFeature> getSelectedFeatures() {
        return new ArrayList<ParadiseFeature>(this.selectedFeatures);
    }

    @Override
    public <T extends ParadiseFeature> List<T> getSelectedFeatures(Class<T> c) {
        ArrayList<ParadiseFeature> features = new ArrayList<ParadiseFeature>();
        for (ParadiseFeature f : this.selectedFeatures) {
            if (!c.isInstance(f)) continue;
            features.add(f);
        }
        return features;
    }

    @Override
    public List<Molecule.Annotation> getAnnotations() {
        if (this.annotations == null) {
            return new ArrayList<Molecule.Annotation>();
        }
        return new ArrayList<Molecule.Annotation>(this.annotations);
    }

    @Override
    public List<Molecule.Annotation> getAnnotations(Class c, Location l) {
        ArrayList<Molecule.Annotation> hits = new ArrayList<Molecule.Annotation>();
        for (Molecule.Annotation a : this.getAnnotations(c)) {
            if (!a.getLocation().isIncludedIn(l)) continue;
            hits.add(a);
        }
        return hits;
    }

    @Override
    public List<Molecule.Annotation> getAnnotations(Location l) {
        ArrayList<Molecule.Annotation> hits = new ArrayList<Molecule.Annotation>();
        if (this.annotations == null) {
            return hits;
        }
        for (Molecule.Annotation a : this.annotations) {
            if (!a.getLocation().isIncludedIn(l)) continue;
            hits.add(a);
        }
        return hits;
    }

    @Override
    public Molecule.Annotation getAnnotation(ParadiseFeature feature) {
        if (this.annotations == null) {
            return null;
        }
        for (Molecule.Annotation a : this.annotations) {
            if (!a.getFeature().equals(feature)) continue;
            return a;
        }
        return null;
    }

    @Override
    public List<Molecule.Annotation> getAnnotations(Class c) {
        ArrayList<Molecule.Annotation> hits = new ArrayList<Molecule.Annotation>();
        for (Molecule.Annotation a : this.getAnnotations()) {
            if (!c.isInstance(a.getFeature())) continue;
            hits.add(a);
        }
        return hits;
    }

    @Override
    public void setName(String name) {
        this.name = name.replace("/", "_").replace("\\", "_");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getLength() {
        return this.sequence.length();
    }

    @Override
    public String printSequence(Location l) {
        return this.sequence.substring(l.getStart() - 1, l.getEnd());
    }

    @Override
    public String getResidueAt(int position) throws ArchitectureException {
        if (position <= 0 || position > this.getLength()) {
            throw new ArchitectureException("The position asked for is outside the molecule's boundaries", this, new Location(position));
        }
        return Character.toString(this.sequence.charAt(position - 1));
    }

    @Override
    public String printSequence() {
        return this.sequence.toString();
    }

    @Override
    public ParadiseID getParadiseID() {
        return this.paradiseID;
    }

    @Override
    public boolean equals(Object o) {
        if (!Molecule.class.isInstance(o)) {
            return false;
        }
        return this.getParadiseID().equals(((Molecule)o).getParadiseID());
    }

    public String toString() {
        return (Protein.class.isInstance(this) ? "Protein " : "RNA ") + this.getName() + " (" + this.getLength() + (Protein.class.isInstance(this) ? "aas" : "nts") + ") from " + this.getSource().getId();
    }

    public class AnnotationImpl
    extends AbstractDocumentable
    implements Molecule.Annotation {
        protected Location location;
        protected ParadiseFeature feature;
        protected Molecule molecule;

        private AnnotationImpl(ParadiseFeature feature, Location location) {
            this.feature = feature;
            this.location = new Location(location);
        }

        public Molecule getMolecule() {
            return this.molecule;
        }

        public ParadiseFeature getFeature() {
            return this.feature;
        }

        public Location getLocation() {
            return this.location;
        }

        public void addToLocation(Location l) throws ArchitectureException {
            this.feature.addToLocation(l, this.molecule);
        }

        public void removeFromLocation(Location l) {
            this.feature.removeFromLocation(l, this.molecule);
        }
    }
}

