/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core;

import fr.unistra.ibmc.paradise.core.AbstractMolecule;
import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.Source;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenomicDNA
extends AbstractMolecule {
    GenomicDNA(ParadiseID paradiseID, ParadiseWorkingSession workingSession, String name, Source source, String sequence) throws BiologicalSymbolException {
        super(paradiseID, workingSession, name, source);
        sequence = sequence.trim().toUpperCase();
        int step = 1;
        for (int i = 0; i < sequence.length(); i += step) {
            this.addResidue(sequence.substring(i, i + step));
        }
    }

    @Override
    public void addResidue(String residue) throws BiologicalSymbolException {
        residue = "A".equals(residue) || "ADE".equals(residue) ? "A" : ("G".equals(residue) || "GUA".equals(residue) ? "G" : ("C".equals(residue) || "CYT".equals(residue) ? "C" : ("T".equals(residue) || "THY".equals(residue) ? "T" : "?")));
        this.sequence.append(residue);
    }

    public abstract List<Location> getIntergenicRegions();
}

