/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core;

import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.CircularGenomicDNA;
import fr.unistra.ibmc.paradise.core.LinearGenomicDNA;
import fr.unistra.ibmc.paradise.core.MainParadiseFeature;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Protein;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.SequenceFeatureFactory;
import fr.unistra.ibmc.paradise.tools.ConnectionException;
import fr.unistra.ibmc.paradise.tools.IncompatibilityException;
import fr.unistra.ibmc.paradise.tools.Paradise;
import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.wrapper.AgentContainer;
import jade.wrapper.ControllerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParadiseWorkingSession {
    protected List<Molecule> molecules;
    protected AgentContainer container;
    protected static String clientAddress;
    protected static String platformAddress;
    protected File currentParadiseProject;
    protected String description = "ParadiseWorkingSession[at]" + InetAddress.getLocalHost().getHostAddress();
    protected SequenceFeatureFactory sequenceFeatureFactory;

    public ParadiseWorkingSession() throws ControllerException, UnknownHostException, ConnectionException, IncompatibilityException {
        this.molecules = new ArrayList<Molecule>();
        this.sequenceFeatureFactory = new SequenceFeatureFactory(this, "workingsession");
        clientAddress = InetAddress.getLocalHost().getHostAddress();
    }

    public void connectToPlatform(String platformAddress) throws UnknownHostException, ControllerException, ConnectionException, IncompatibilityException {
        if (platformAddress == null) {
            return;
        }
        ParadiseWorkingSession.platformAddress = platformAddress;
        Runtime r = Runtime.instance();
        ProfileImpl profile = new ProfileImpl();
        if (platformAddress.equals("localhost")) {
            profile.setParameter("host", clientAddress);
        } else {
            profile.setParameter("host", platformAddress);
            String publicIP = null;
            publicIP = clientAddress;
            profile.setParameter("local-host", publicIP);
        }
        profile.setParameter("container-name", clientAddress);
        this.container = r.createAgentContainer((Profile)profile);
        if (this.container == null) {
            throw new ConnectionException();
        }
        this.container.start();
        if (!"PARADISE 1.0".equals(this.container.getPlatformName())) {
            throw new IncompatibilityException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restorePreviousWorkingSession() {
        File backup = new File(new File(Paradise.getInstallPath()), "paradise.backup");
        if (backup.exists()) {
            this.molecules.clear();
            ObjectInputStream stream = null;
            try {
                stream = new ObjectInputStream(new FileInputStream(backup));
                this.currentParadiseProject = (File)stream.readObject();
                for (Molecule m : (List)stream.readObject()) {
                    this.molecules.add(m);
                    m.recoverBackupAnnotations();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public File getCurrentParadiseProject() {
        return this.currentParadiseProject;
    }

    public void setCurrentParadiseProject(File paradiseProject) {
        this.currentParadiseProject = paradiseProject;
    }

    public RNA createRNA(ParadiseID paradiseID, String name, Source source, String sequence) throws BiologicalSymbolException {
        RNA rna = new RNA(paradiseID, this, name, source, sequence);
        this.molecules.add(rna);
        return rna;
    }

    public Protein createProtein(ParadiseID paradiseID, String name, Source source, String sequence) throws BiologicalSymbolException {
        Protein protein = new Protein(paradiseID, this, name, source, sequence);
        this.molecules.add(protein);
        return protein;
    }

    public LinearGenomicDNA createLinearGenomicDNA(ParadiseID paradiseID, String name, Source source, String sequence) throws BiologicalSymbolException {
        LinearGenomicDNA dna = new LinearGenomicDNA(paradiseID, this, name, source, sequence);
        this.molecules.add(dna);
        return dna;
    }

    public CircularGenomicDNA createCircularGenomicDNA(ParadiseID paradiseID, String name, Source source, String sequence) throws BiologicalSymbolException {
        CircularGenomicDNA dna = new CircularGenomicDNA(paradiseID, this, name, source, sequence);
        this.molecules.add(dna);
        return dna;
    }

    public void removeMolecule(Molecule molecule) {
        this.molecules.remove(molecule);
    }

    public void removeAllMolecules() {
        for (Molecule m : this.getMolecules()) {
            this.removeMolecule(m);
        }
    }

    public void addAllMolecules(Collection<Molecule> molecules) {
        this.molecules.addAll(molecules);
    }

    public List<Molecule> getMolecules() {
        return new ArrayList<Molecule>(this.molecules);
    }

    public List<RNA> getRNAs() {
        ArrayList<RNA> rnas = new ArrayList<RNA>();
        for (Molecule m : this.getMolecules()) {
            if (!RNA.class.isInstance(m)) continue;
            rnas.add((RNA)m);
        }
        return rnas;
    }

    public List<Protein> getProteins() {
        ArrayList<Protein> proteins = new ArrayList<Protein>();
        for (Molecule m : this.getMolecules()) {
            if (!Protein.class.isInstance(m)) continue;
            proteins.add((Protein)m);
        }
        return proteins;
    }

    public <T extends MainParadiseFeature> List<T> getMainParadiseFeatures(Class<T> c) {
        HashSet<MainParadiseFeature> features = new HashSet<MainParadiseFeature>();
        for (Molecule m : this.getMolecules()) {
            for (Molecule.Annotation a : m.getAnnotations(c)) {
                features.add((MainParadiseFeature)((Object)a.getFeature()));
            }
        }
        return new ArrayList(features);
    }

    public Molecule getMolecule(ParadiseID paradiseID) {
        for (Molecule m : this.molecules) {
            if (!m.getParadiseID().equals(paradiseID)) continue;
            return m;
        }
        return null;
    }

    public Molecule getMolecule(String source) {
        for (Molecule m : this.molecules) {
            if (!m.getSource().equals(source)) continue;
            return m;
        }
        return null;
    }

    public AgentContainer getAgentContainer() {
        return this.container;
    }

    public String getAddress() {
        return clientAddress;
    }

    public String getPlatformAddress() {
        return platformAddress;
    }

    public SequenceFeatureFactory getSequenceFeatureFactory() {
        return this.sequenceFeatureFactory;
    }
}

