/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.analysis;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.analysis.Analysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.analysis.PreRequisite;
import fr.unistra.ibmc.paradise.core.features.AbstractParadiseFeatureFactoryFactory;
import fr.unistra.ibmc.paradise.core.features.ParadiseFeatureFactory;
import fr.unistra.ibmc.paradise.core.utils.ParadiseConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnalysis
extends AbstractParadiseFeatureFactoryFactory
implements Analysis {
    protected Parameters parameters = new Parameters();
    protected List<PreRequisite> prerequisites = new ArrayList<PreRequisite>();
    protected List<String> categories;
    private List<ParadiseFeatureFactory> featureFactories = new ArrayList<ParadiseFeatureFactory>();
    protected List<Molecule> newMolecules = new ArrayList<Molecule>();
    protected String status = "Start of analysis";
    private boolean isCancelled;

    protected AbstractAnalysis(String description, ParadiseWorkingSession workingSession) {
        super(workingSession, description);
        this.categories = new ArrayList<String>();
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public List<Molecule> getNewMolecules() {
        return new ArrayList<Molecule>(this.newMolecules);
    }

    @Override
    public ParadiseWorkingSession getParadiseWorkingSession() {
        return this.workingSession;
    }

    @Override
    public void addParadiseFeatureFactory(ParadiseFeatureFactory factory) {
        if (this.getParadiseFeatureFactory(factory.getClass()) == null) {
            this.featureFactories.add(factory);
        }
    }

    @Override
    public <T> T getParadiseFeatureFactory(Class<T> factoryType) {
        for (ParadiseFeatureFactory f : this.featureFactories) {
            if (!factoryType.isInstance(f)) continue;
            return factoryType.cast(f);
        }
        return null;
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    @Override
    public String[] getCategories() {
        return this.categories.toArray(new String[0]);
    }

    public String toString() {
        return this.description;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public ArrayList<PreRequisite> getPreRequisites() {
        return new ArrayList<PreRequisite>(this.prerequisites);
    }

    @Override
    public Parameters getParameters(String name) {
        return this.parameters.getParameters(name);
    }

    protected Parameter addParameter(String name, String[] choices, String defaultValue) {
        Parameter p = new Parameter(name, choices, defaultValue);
        this.parameters.addParameter(p);
        return p;
    }

    protected Parameter addParameter(String name, String[] choices) {
        Parameter p = new Parameter(name, choices);
        this.parameters.addParameter(p);
        return p;
    }

    protected Parameter addParameter(String name, String defaultValue) {
        Parameter p = new Parameter(name, defaultValue);
        this.parameters.addParameter(p);
        return p;
    }

    protected Parameter addParameter(String name) {
        Parameter p = new Parameter(name);
        this.parameters.addParameter(p);
        return p;
    }

    protected String postData(String urlAddress, Map<String, String> data) throws AnalysisException {
        try {
            String line;
            StringBuffer allData = new StringBuffer();
            for (String key : data.keySet()) {
                if (allData.length() != 0) {
                    allData.append("&");
                }
                allData.append(URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(data.get(key), "UTF-8"));
            }
            URL url = new URL(ParadiseConfig.getCurrentWebServicesAddress() + urlAddress);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(allData.toString());
            wr.flush();
            StringBuffer result = new StringBuffer();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result.append(line + "\n");
            }
            wr.close();
            rd.close();
            return result.toString();
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

