/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.features;

import fr.unistra.ibmc.paradise.core.ArchitectureException;
import fr.unistra.ibmc.paradise.core.MainParadiseFeature;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.AbstractParadiseFeature;
import fr.unistra.ibmc.paradise.core.features.ParadiseFeatureFactory;

public abstract class AbstractMainParadiseFeature
extends AbstractParadiseFeature
implements MainParadiseFeature {
    protected String name;

    protected AbstractMainParadiseFeature(ParadiseFeatureFactory factory, String name, Source source) {
        super(factory);
        this.name = name;
        this.source = source;
    }

    public ParadiseID getParadiseID() {
        return this.paradiseID;
    }

    public void setParadiseID(ParadiseID paradiseID) {
        this.paradiseID = paradiseID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void addSubFeature(int index, ParadiseFeature feature) throws ArchitectureException {
        if (feature.getAnnotations().size() == 0) {
            throw new ArchitectureException("A feature has to annotate at least one Molecule before to be added as a subfeature", this, feature);
        }
        if (!this.subfeatures.contains(feature)) {
            this.subfeatures.add(index, feature);
            ((AbstractParadiseFeature)feature).parentfeatures.add(this);
            if (!MainParadiseFeature.class.isInstance(feature)) {
                for (Molecule.Annotation a : feature.getAnnotations()) {
                    a.getMolecule().addFeature(this, a.getLocation());
                }
            }
        }
    }

    public String toString() {
        return this.getName() + " from " + this.getSource().getId();
    }
}

