/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.features;

import fr.unistra.ibmc.paradise.core.ArchitectureException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helix
extends StructuralDomain {
    protected Helix(StructuralFeatureFactory factory, String name) {
        super(factory, name);
    }

    public boolean isPseudoKnot() {
        SecondaryStructure ss = this.getParentFeatures(SecondaryStructure.class).get(0);
        if (this.isInterMolecular()) {
            return false;
        }
        Molecule m = this.getMolecules().iterator().next();
        Location l = this.getFullLocation(m);
        for (Helix _h : ss.getHelices()) {
            if (_h == this || !_h.annotates(m)) continue;
            Location _l = _h.getFullLocation(m);
            int s1 = l.getStart();
            int e1 = l.getEnd();
            int s2 = _l.getStart();
            int e2 = _l.getEnd();
            if (s1 >= s2 || e1 >= e2 || s2 >= e1) continue;
            if (_l.getLength() > l.getLength()) {
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean isInterMolecular() {
        return this.getMolecules().size() == 2;
    }

    public void removeBaseBaseInteraction(BaseBaseInteraction interaction) {
        interaction.removeAtomAtomInteractions();
        for (Molecule m : interaction.getMolecules()) {
            m.removeFeature(interaction);
        }
        this.removeSubFeature(interaction);
    }

    public List<BaseBaseInteraction> getBaseBaseInteractions() throws ArchitectureException {
        return this.getSubFeatures(BaseBaseInteraction.class);
    }

    public Residue get5PrimeEnd(Residue _3primeEnd) {
        Residue[] _5PrimeEnds = this.get5PrimeEnds();
        if (_5PrimeEnds[0].getMoleculeId().equals(_3primeEnd.getMoleculeId()) && _5PrimeEnds[0].getAbsolutePosition() + this.getLength() - 1 == _3primeEnd.getAbsolutePosition()) {
            return _5PrimeEnds[0];
        }
        if (_5PrimeEnds[1].getMoleculeId().equals(_3primeEnd.getMoleculeId()) && _5PrimeEnds[1].getAbsolutePosition() + this.getLength() - 1 == _3primeEnd.getAbsolutePosition()) {
            return _5PrimeEnds[1];
        }
        return null;
    }

    public Residue get3PrimeEnd(Residue _5primeEnd) {
        Residue[] _3PrimeEnds = this.get3PrimeEnds();
        if (_3PrimeEnds[0].getMoleculeId().equals(_5primeEnd.getMoleculeId()) && _3PrimeEnds[0].getAbsolutePosition() == _5primeEnd.getAbsolutePosition() + this.getLength() - 1) {
            return _3PrimeEnds[0];
        }
        if (_3PrimeEnds[1].getMoleculeId().equals(_5primeEnd.getMoleculeId()) && _3PrimeEnds[1].getAbsolutePosition() == _5primeEnd.getAbsolutePosition() + this.getLength() - 1) {
            return _3PrimeEnds[1];
        }
        return null;
    }

    public Residue getPairedResidue(Residue r) {
        for (BaseBaseInteraction interaction : this.getBaseBaseInteractions()) {
            if (interaction.getResidue().equals(r)) {
                return interaction.getPartnerResidue();
            }
            if (!interaction.getPartnerResidue().equals(r)) continue;
            return interaction.getResidue();
        }
        return null;
    }

    public Residue[] get5PrimeEnds() {
        Residue[] residues = new Residue[2];
        if (this.getMolecules().size() == 1) {
            Molecule m = this.getMolecules().iterator().next();
            Location l = this.getFullLocation(m);
            if (l.getBoundaries().length != 4) {
                residues[0] = new Residue(l.getStart(), m);
                residues[1] = new Residue(l.getEnd() - l.getLength() / 2 + 1, m);
            } else {
                residues[0] = new Residue(l.getBoundaries()[0], m);
                residues[1] = new Residue(l.getBoundaries()[2], m);
            }
        } else if (this.getMolecules().size() == 2) {
            Iterator<Molecule> it = this.getMolecules().iterator();
            Molecule m1 = it.next();
            Molecule m2 = it.next();
            Location l1 = this.getFullLocation(m1);
            Location l2 = this.getFullLocation(m2);
            residues[0] = new Residue(l1.getStart(), m1);
            residues[1] = new Residue(l2.getStart(), m2);
        }
        return residues;
    }

    public Residue[] get3PrimeEnds() {
        Residue[] residues = new Residue[2];
        if (this.getMolecules().size() == 1) {
            Molecule m = this.getMolecules().iterator().next();
            Location l = this.getFullLocation(m);
            if (l.getBoundaries().length != 4) {
                residues[0] = new Residue(l.getStart() + l.getLength() / 2 - 1, m);
                residues[1] = new Residue(l.getEnd(), m);
            } else {
                residues[0] = new Residue(l.getBoundaries()[1], m);
                residues[1] = new Residue(l.getBoundaries()[3], m);
            }
        } else if (this.getMolecules().size() == 2) {
            Iterator<Molecule> it = this.getMolecules().iterator();
            Molecule m1 = it.next();
            Molecule m2 = it.next();
            Location l1 = this.getFullLocation(m1);
            Location l2 = this.getFullLocation(m2);
            residues[0] = new Residue(l1.getEnd(), m1);
            residues[1] = new Residue(l2.getEnd(), m2);
        }
        return residues;
    }

    @Override
    public int getLength() {
        Iterator<Molecule> it = this.getMolecules().iterator();
        int length = this.getFullLocation(it.next()).getLength();
        if (it.hasNext()) {
            length += this.getFullLocation(it.next()).getLength();
        }
        return length / 2;
    }

    public Helix[] getDirectlyLinkedHelicesAt5PrimeEnds() {
        Helix[] helices = new Helix[2];
        SecondaryStructure ss = this.getParentFeatures(SecondaryStructure.class).get(0);
        for (Residue r : this.get5PrimeEnds()) {
            StructuralDomain sd = ss.getEnclosingStructuralDomain(new Residue(r.getAbsolutePosition() - 1, r.getMolecule()));
            if (!Helix.class.isInstance(sd)) continue;
            if (helices[0] == null) {
                helices[0] = (Helix)sd;
                continue;
            }
            helices[1] = (Helix)sd;
        }
        return helices;
    }

    public Helix[] getDirectlyLinkedHelicesAt3PrimeEnds() {
        Helix[] helices = new Helix[2];
        SecondaryStructure ss = this.getParentFeatures(SecondaryStructure.class).get(0);
        for (Residue r : this.get3PrimeEnds()) {
            StructuralDomain sd = ss.getEnclosingStructuralDomain(new Residue(r.getAbsolutePosition() + 1, r.getMolecule()));
            if (!Helix.class.isInstance(sd)) continue;
            if (helices[0] == null) {
                helices[0] = (Helix)sd;
                continue;
            }
            helices[1] = (Helix)sd;
        }
        return helices;
    }
}

