/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.features;

import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.AbstractParadiseFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.ResidueIdentity;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.StructuralIdentity;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityFeatureFactory
extends AbstractParadiseFeatureFactory {
    public IdentityFeatureFactory(ParadiseWorkingSession workingSession, String description) {
        super(workingSession, "Identity", description);
    }

    public StructuralAlignment createStructuralAligment(String name, Source source) {
        StructuralAlignment sa = new StructuralAlignment(this, name, source);
        return sa;
    }

    public StructuralAlignment createStructuralAligment(String name, Source source, Molecule m, Location l) {
        StructuralAlignment sa = new StructuralAlignment(this, name, source);
        m.addFeature(sa, l);
        return sa;
    }

    public StructuralAlignment copyStructuralAlignment(List<Molecule> targetMolecules, StructuralAlignment referenceAlignment) {
        StructuralAlignment copyAlignment = this.createStructuralAligment(referenceAlignment.getName(), referenceAlignment.getSource());
        copyAlignment.setParadiseID(referenceAlignment.getParadiseID());
        for (StructuralIdentity ri : copyAlignment.getStructuralIdentities(false)) {
            this.copyStructuralIdentity(targetMolecules, ri, copyAlignment);
        }
        return copyAlignment;
    }

    public ResidueIdentity createResidueIdentity(StructuralAlignment sa, Molecule m, Location l) {
        ResidueIdentity ri = new ResidueIdentity(this);
        m.addFeature(ri, l);
        sa.addSubFeature(ri);
        return ri;
    }

    public StructuralIdentity createStructuralIdentity(StructuralAlignment sa, String name, Molecule m, Location l) {
        StructuralIdentity ri = new StructuralIdentity(this, name);
        m.addFeature(ri, l);
        sa.addSubFeature(ri);
        return ri;
    }

    public ResidueIdentity copyResidueidentity(List<Molecule> targetMolecules, ResidueIdentity referenceIdentity, StructuralAlignment alignment) {
        ResidueIdentity copyIdentity = null;
        for (Molecule _m : referenceIdentity.getMolecules()) {
            if (copyIdentity == null) {
                copyIdentity = this.createResidueIdentity(alignment, _m.searchCopy(targetMolecules), new Location(referenceIdentity.getFullLocation(_m)));
                continue;
            }
            _m.searchCopy(targetMolecules).addFeature(copyIdentity, new Location(referenceIdentity.getFullLocation(_m)));
        }
        return copyIdentity;
    }

    public StructuralIdentity copyStructuralIdentity(List<Molecule> targetMolecules, StructuralIdentity referenceIdentity, StructuralAlignment alignment) {
        StructuralIdentity copyIdentity = null;
        for (Molecule _m : referenceIdentity.getMolecules()) {
            if (copyIdentity == null) {
                copyIdentity = this.createStructuralIdentity(alignment, referenceIdentity.getName(), _m.searchCopy(targetMolecules), new Location(referenceIdentity.getFullLocation(_m)));
                continue;
            }
            _m.searchCopy(targetMolecules).addFeature(copyIdentity, new Location(referenceIdentity.getFullLocation(_m)));
        }
        return copyIdentity;
    }
}

