/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.features;

import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.AbstractMainParadiseFeature;
import fr.unistra.ibmc.paradise.core.features.IdentityFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.ResidueIdentity;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralIdentity;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuralAlignment
extends AbstractMainParadiseFeature {
    private Map<Molecule, Integer> positions = new HashMap<Molecule, Integer>();

    protected StructuralAlignment(IdentityFeatureFactory factory, String name, Source source) {
        super(factory, name, source);
    }

    @Override
    public IdentityFeatureFactory getFactory() {
        return (IdentityFeatureFactory)super.getFactory();
    }

    public int getHomologousPosition(Molecule source, int position, Molecule target) {
        for (StructuralIdentity si : this.getStructuralIdentities(true)) {
            Location sourceLocation = si.getFullLocation(source);
            Location targetLocation = si.getFullLocation(target);
            Location sourceGaps = si.getGapsLocation(source);
            Location targetGaps = si.getGapsLocation(target);
            if (sourceLocation == null || !sourceLocation.hasPosition(position) || targetLocation == null) continue;
            int sourcePos = sourceLocation.getStart() - 1;
            int targetPos = targetLocation.getStart() - 1;
            for (int i = 1; i <= si.getLength(); ++i) {
                if (sourceGaps != null && sourceGaps.hasPosition(i)) continue;
                ++sourcePos;
                if (targetGaps != null && targetGaps.hasPosition(i)) continue;
                ++targetPos;
                if (sourcePos != position) continue;
                return targetPos;
            }
        }
        return -1;
    }

    public List<StructuralIdentity> getStructuralIdentities(boolean ordered) {
        if (ordered) {
            ArrayList<StructuralIdentity> ret = new ArrayList<StructuralIdentity>();
            for (StructuralIdentity identity : this.getSubFeatures(StructuralIdentity.class)) {
                boolean added = false;
                for (StructuralIdentity ri : ret) {
                    if (!identity.isBefore(ri)) continue;
                    ret.add(ret.indexOf(ri), identity);
                    added = true;
                    break;
                }
                if (added) continue;
                ret.add(identity);
            }
            return ret;
        }
        return this.getSubFeatures(StructuralIdentity.class);
    }

    public void removeResidueIdentity(ResidueIdentity ri) {
        for (Molecule m : ri.getMolecules()) {
            m.removeFeature(ri);
        }
        this.removeSubFeature(ri);
    }

    public void removeStructuralIdentity(StructuralIdentity ri) {
        for (Molecule m : ri.getMolecules()) {
            m.removeFeature(ri);
        }
        this.removeSubFeature(ri);
    }

    public void linkSecondaryStructure(SecondaryStructure ss) {
        this.addSubFeature(ss);
    }

    public List<SecondaryStructure> getLinkedSecondaryStructures() {
        return this.getSubFeatures(SecondaryStructure.class);
    }

    public ResidueIdentity getResidueIdentity(Residue residue) {
        for (ResidueIdentity ri : this.getSubFeatures(ResidueIdentity.class)) {
            if (residue.getMolecule().getAnnotation(ri).getLocation().getStart() != residue.getAbsolutePosition()) continue;
            return ri;
        }
        return null;
    }

    public int getLength() {
        int length = 0;
        for (StructuralIdentity si : this.getStructuralIdentities(false)) {
            length += si.getLength();
        }
        return length;
    }

    public void setPositionInAlignment(Molecule m, int position) {
        this.positions.put(m, position);
    }

    public Integer getPositionInAlignment(Molecule m) {
        return this.positions.get(m);
    }

    public List<Molecule> getSortedMolecules() {
        if (this.positions.size() == 0) {
            HashSet<Molecule> molecules = new HashSet<Molecule>();
            for (StructuralIdentity si : this.getSubFeatures(StructuralIdentity.class)) {
                molecules.addAll(si.getMolecules());
            }
            return new ArrayList<Molecule>(molecules);
        }
        ArrayList<Molecule> molecules = new ArrayList<Molecule>(this.positions.size());
        for (int i = 0; i < this.positions.size(); ++i) {
            molecules.add(null);
        }
        for (Map.Entry<Molecule, Integer> e : this.positions.entrySet()) {
            molecules.set(e.getValue(), e.getKey());
        }
        return molecules;
    }
}

