/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.io;

import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.AbstractParadiseFileIO;
import fr.unistra.ibmc.paradise.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.tools.Paradise;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPSeqFileIO
extends AbstractParadiseFileIO {
    public static final String[] suffixes = new String[]{"bpseq"};
    protected List<Molecule> molecules;
    protected List<SecondaryStructure> secondaryStructures;
    protected StructuralFeatureFactory structuralFeatureFactory = this.createStructuralFeatureFactory();

    public BPSeqFileIO(ParadiseWorkingSession ws) {
        super("BPSeq File Parser", ws);
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                for (String suffix : suffixes) {
                    if (!file.getName().endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return "BPSeq files";
            }
        };
    }

    @Override
    public List<SecondaryStructure> getSecondaryStructures() {
        return new ArrayList<SecondaryStructure>(this.secondaryStructures);
    }

    @Override
    public List<StructuralAlignment> getStructuralAlignments() {
        return new ArrayList<StructuralAlignment>();
    }

    @Override
    public List<TertiaryStructure> getTertiaryStructures() {
        return new ArrayList<TertiaryStructure>();
    }

    @Override
    public List<Molecule> getMolecules() {
        return this.molecules;
    }

    @Override
    public void parseFile(File f, ProgressMonitor monitor) throws FileParsingException, InterruptedException {
        try {
            int i;
            BufferedReader in = new BufferedReader(new FileReader(f));
            this.molecules = new ArrayList<Molecule>();
            this.secondaryStructures = new ArrayList<SecondaryStructure>();
            RNA molecule = this.workingSession.createRNA(new ParadiseID(), "RNA", Source.getFileAsSource(f), "");
            this.molecules.add(molecule);
            ArrayList<Location> helices = new ArrayList<Location>();
            ArrayList<Location> tertiaryInteractions = new ArrayList<Location>();
            ArrayList<Location> allpairs = new ArrayList<Location>();
            String line = null;
            while ((line = in.readLine()) != null) {
                String[] tokens;
                block21: {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    tokens = line.split(" ");
                    try {
                        Location l;
                        int base5 = Integer.parseInt(tokens[0]);
                        int base3 = Integer.parseInt(tokens[2]);
                        if (base3 == 0 || allpairs.contains(l = new Location(new Location(base5), new Location(base3)))) break block21;
                        allpairs.add(l);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                if (tokens.length != 3) continue;
                try {
                    molecule.addResidue(tokens[1]);
                }
                catch (BiologicalSymbolException e) {
                    if (!BiologicalSymbolException.UNKNOWN_RESIDUE.equals(e.getMessage())) continue;
                    String choice = null;
                    while (choice == null || choice.length() == 0) {
                        choice = (String)JOptionPane.showInputDialog(null, "Please choose an unmodified residue", "Unknown Residue " + line.substring(17, 21).trim(), 2, null, new String[]{"A", "U", "G", "C"}, "A");
                        Paradise.addModifiedResidue(line.substring(17, 21).trim(), choice);
                    }
                    molecule.addResidue(line.substring(17, 21).trim());
                }
            }
            in.close();
            this.secondaryStructures.add(this.structuralFeatureFactory.createRNASecondaryStructure("Secondary Structure", Source.getFileAsSource(f), molecule, new Location(1, molecule.getLength())));
            Collections.sort(allpairs, new Comparator(){

                public int compare(Object o, Object o1) {
                    return ((Location)o).getStart() - ((Location)o1).getStart();
                }
            });
            Location allSingleStrandsLocation = new Location(1, molecule.getLength());
            Location l = null;
            for (i = 0; i < allpairs.size() - 1; ++i) {
                Location l1 = (Location)allpairs.get(i);
                Location l2 = (Location)allpairs.get(i + 1);
                if (l1.getStart() + 1 == l2.getStart() && l1.getEnd() - 1 == l2.getEnd()) {
                    if (l == null) {
                        l = new Location(l1, l2);
                        continue;
                    }
                    l.add(l1);
                    l.add(l2);
                    continue;
                }
                if (l != null) {
                    if (l.getLength() == 2) {
                        tertiaryInteractions.add(l);
                    } else {
                        helices.add(l);
                        allSingleStrandsLocation.remove(l);
                    }
                }
                l = null;
            }
            if (l != null) {
                if (l.getLength() == 2) {
                    tertiaryInteractions.add(l);
                } else {
                    helices.add(l);
                    allSingleStrandsLocation.remove(l);
                }
            }
            i = 1;
            for (Location _l : helices) {
                this.structuralFeatureFactory.createHelix("H" + i++, this.secondaryStructures.get(this.secondaryStructures.size() - 1), molecule, _l);
            }
            for (Location _l : tertiaryInteractions) {
                this.structuralFeatureFactory.createBaseBaseInteraction('W', 'W', 'C', 1, this.secondaryStructures.get(this.secondaryStructures.size() - 1), (Molecule)molecule, _l);
            }
            int[] boundaries = allSingleStrandsLocation.getBoundaries();
            for (i = 0; i < boundaries.length; i += 2) {
                this.structuralFeatureFactory.createSingleStrand("SS" + (i + 1), this.secondaryStructures.get(this.secondaryStructures.size() - 1), molecule, new Location(boundaries[i], boundaries[i + 1]));
            }
        }
        catch (Exception e) {
            throw new FileParsingException(e);
        }
    }
}

