/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.io;

import fr.unistra.ibmc.paradise.core.ArchitectureException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.AbstractParadiseFileIO;
import fr.unistra.ibmc.paradise.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTFileIO
extends AbstractParadiseFileIO {
    public static final String[] suffixes = new String[]{"ct"};
    protected StructuralFeatureFactory structuralFeatureFactory = this.createStructuralFeatureFactory();
    protected List<Molecule> molecules;
    protected List<SecondaryStructure> secondaryStructures;

    public CTFileIO(ParadiseWorkingSession ws) {
        super("CT File Parser", ws);
    }

    @Override
    public List<SecondaryStructure> getSecondaryStructures() {
        return new ArrayList<SecondaryStructure>(this.secondaryStructures);
    }

    @Override
    public List<StructuralAlignment> getStructuralAlignments() {
        return new ArrayList<StructuralAlignment>();
    }

    @Override
    public List<TertiaryStructure> getTertiaryStructures() {
        return new ArrayList<TertiaryStructure>();
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                for (String suffix : suffixes) {
                    if (!file.getName().endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return "CT files";
            }
        };
    }

    @Override
    public List<Molecule> getMolecules() {
        return this.molecules;
    }

    public static void writeCTFile(File f, String sequence, String bracketNotation) throws FileNotFoundException {
        PrintWriter pw;
        if (sequence.length() == bracketNotation.length()) {
            ArrayList<Location> allpairs = new ArrayList<Location>();
            Location locationInTheMolecule = new Location();
            Location locationInTheAlignedSequence = new Location();
            int moleculePosition = 0;
            block4: for (int i = 0; i < bracketNotation.length(); ++i) {
                ++moleculePosition;
                char c = bracketNotation.charAt(i);
                switch (c) {
                    case '(': {
                        locationInTheMolecule.add(moleculePosition);
                        locationInTheAlignedSequence.add(i);
                        continue block4;
                    }
                    case ')': {
                        allpairs.add(new Location(new Location(locationInTheMolecule.getEnd()), new Location(moleculePosition)));
                        locationInTheMolecule.remove(locationInTheMolecule.getEnd());
                        locationInTheAlignedSequence.remove(locationInTheAlignedSequence.getEnd());
                    }
                }
            }
            Collections.sort(allpairs, new Comparator(){

                public int compare(Object o, Object o1) {
                    return ((Location)o).getStart() - ((Location)o1).getStart();
                }
            });
            Location allSingleStrandsLocation = new Location(1, sequence.length());
            for (int i = 0; i < allpairs.size(); ++i) {
                allSingleStrandsLocation.remove((Location)allpairs.get(i));
            }
            pw = new PrintWriter(f);
            pw.println(sequence.length() + " (generated with PARADISE)");
            block6: for (int i = 0; i < sequence.length(); ++i) {
                if (allSingleStrandsLocation.hasPosition(i + 1)) {
                    pw.println(i + 1 + " " + sequence.charAt(i) + " " + i + " " + (i + 2) + " " + 0 + " " + (i + 1));
                    continue;
                }
                for (Location l : allpairs) {
                    if (l.getStart() == i + 1) {
                        pw.println(l.getStart() + " " + sequence.charAt(l.getStart() - 1) + " " + (l.getStart() - 1) + " " + (l.getStart() + 1) + " " + l.getEnd() + " " + l.getStart());
                        continue block6;
                    }
                    if (l.getEnd() != i + 1) continue;
                    pw.println(l.getEnd() + " " + sequence.charAt(l.getEnd() - 1) + " " + (l.getEnd() - 1) + " " + (l.getEnd() + 1) + " " + l.getStart() + " " + l.getEnd());
                    continue block6;
                }
            }
        } else {
            throw new ArchitectureException("The RNA sequence is of different length than the bracket notation!!");
        }
        pw.close();
    }

    public static void writeCTFile(List<Residue> residues, List<BaseBaseInteraction> interactions, File f) throws FileNotFoundException, InterruptedException {
        PrintWriter pw = new PrintWriter(new FileOutputStream(f));
        pw.println(residues.size() + " (generated with PARADISE)");
        for (int i = 0; i < residues.size(); ++i) {
            Residue r = residues.get(i);
            int partnerPosition = 0;
            for (BaseBaseInteraction bbi : interactions) {
                if (r.equals(bbi.getResidue())) {
                    partnerPosition = residues.indexOf(bbi.getPartnerResidue()) + 1;
                    break;
                }
                if (!r.equals(bbi.getPartnerResidue())) continue;
                partnerPosition = residues.indexOf(bbi.getResidue()) + 1;
                break;
            }
            pw.println(i + 1 + " " + r.getMolecule().getResidueAt(r.getAbsolutePosition()) + " " + i + " " + (i + 2) + " " + partnerPosition + " " + (i + 1));
        }
        pw.close();
    }

    @Override
    public void parseFile(File f, ProgressMonitor monitor) throws FileParsingException, InterruptedException {
        try {
            int i;
            BufferedReader in = new BufferedReader(new FileReader(f));
            this.molecules = new ArrayList<Molecule>();
            this.secondaryStructures = new ArrayList<SecondaryStructure>();
            ArrayList<Location> helices = new ArrayList<Location>();
            ArrayList<Location> tertiaryInteractions = new ArrayList<Location>();
            ArrayList<Location> allpairs = new ArrayList<Location>();
            String line = null;
            int length = 0;
            while ((line = in.readLine()) != null) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                try {
                    StringTokenizer tok = new StringTokenizer(line);
                    length = Integer.parseInt(tok.nextToken());
                    break;
                }
                catch (NumberFormatException e) {
                }
            }
            if (length == 0) {
                throw new FileParsingException("According to the header of your file, no residues are present in your 2D structure");
            }
            char[] chars = new char[length];
            int n = 0;
            while ((line = in.readLine()) != null) {
                Location l;
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                StringTokenizer tok = new StringTokenizer(line);
                if (tok.countTokens() < 5) continue;
                tok.nextToken();
                chars[n] = tok.nextToken().charAt(0);
                tok.nextToken();
                tok.nextToken();
                int partner = Integer.parseInt(tok.nextToken());
                if (partner != 0 && !allpairs.contains(l = new Location(new Location(n + 1), new Location(partner)))) {
                    allpairs.add(l);
                }
                ++n;
            }
            if (n != length) {
                throw new FileParsingException("According to the header of your file, there are " + length + " residues in your 2D structure, but i can only found " + n);
            }
            String sequence = new String(chars);
            RNA molecule = this.workingSession.createRNA(new ParadiseID(), "RNA", Source.getFileAsSource(f), sequence);
            this.molecules.add(molecule);
            this.secondaryStructures.add(this.structuralFeatureFactory.createRNASecondaryStructure("Secondary Structure", Source.getFileAsSource(f), molecule, new Location(1, molecule.getLength())));
            Collections.sort(allpairs, new Comparator(){

                public int compare(Object o, Object o1) {
                    return ((Location)o).getStart() - ((Location)o1).getStart();
                }
            });
            Location allSingleStrandsLocation = new Location(1, molecule.getLength());
            Location l = null;
            for (i = 0; i < allpairs.size() - 1; ++i) {
                Location l1 = (Location)allpairs.get(i);
                Location l2 = (Location)allpairs.get(i + 1);
                if (l1.getStart() + 1 == l2.getStart() && l1.getEnd() - 1 == l2.getEnd()) {
                    if (l == null) {
                        l = new Location(l1, l2);
                        continue;
                    }
                    l.add(l1);
                    l.add(l2);
                    continue;
                }
                if (l != null) {
                    if (l.getLength() == 2) {
                        tertiaryInteractions.add(l);
                    } else {
                        helices.add(l);
                        allSingleStrandsLocation.remove(l);
                    }
                }
                l = null;
            }
            if (l != null) {
                if (l.getLength() == 2) {
                    tertiaryInteractions.add(l);
                } else {
                    helices.add(l);
                    allSingleStrandsLocation.remove(l);
                }
            }
            i = 1;
            for (Location _l : helices) {
                this.structuralFeatureFactory.createHelix("H" + i++, this.secondaryStructures.get(this.secondaryStructures.size() - 1), molecule, _l);
            }
            for (Location _l : tertiaryInteractions) {
                this.structuralFeatureFactory.createBaseBaseInteraction('W', 'W', 'C', 1, this.secondaryStructures.get(this.secondaryStructures.size() - 1), (Molecule)molecule, _l);
            }
            int[] boundaries = allSingleStrandsLocation.getBoundaries();
            for (i = 0; i < boundaries.length; i += 2) {
                this.structuralFeatureFactory.createSingleStrand("SS" + (i + 1), this.secondaryStructures.get(this.secondaryStructures.size() - 1), molecule, new Location(boundaries[i], boundaries[i + 1]));
            }
            in.close();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileParsingException(e);
        }
    }
}

