/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.io;

import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.IdentityFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.StructuralIdentity;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.AbstractParadiseFileIO;
import fr.unistra.ibmc.paradise.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StockholmFileIO
extends AbstractParadiseFileIO {
    public static final String FILE_HEADER = "# STOCKHOLM 1.0";
    public static final String CONSENSUS_STRUCTURE_HEADER = "#=GC SS_cons";
    public static final String[] suffixes = new String[]{"stk", "txt"};
    private List<StructuralAlignment> structuralAlignments;
    private IdentityFeatureFactory identityFeatureFactory;
    protected StructuralFeatureFactory structuralFeatureFactory;
    protected List<Molecule> molecules;
    protected List<SecondaryStructure> secondaryStructures;

    public StockholmFileIO(ParadiseWorkingSession ws) {
        super("Stockholm File parser", ws);
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                for (String suffix : suffixes) {
                    if (!file.getName().endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return "Stockholm files";
            }
        };
    }

    @Override
    public List<SecondaryStructure> getSecondaryStructures() {
        return this.secondaryStructures;
    }

    @Override
    public List<TertiaryStructure> getTertiaryStructures() {
        return new ArrayList<TertiaryStructure>();
    }

    @Override
    public List<Molecule> getMolecules() {
        return this.molecules;
    }

    @Override
    public List<StructuralAlignment> getStructuralAlignments() {
        return this.structuralAlignments;
    }

    @Override
    public void parseFile(File f, ProgressMonitor monitor) throws FileParsingException {
        this.structuralFeatureFactory = this.createStructuralFeatureFactory();
        this.identityFeatureFactory = this.createIdentityFeatureFactory();
        HashMap<String, String> organismNames2organismIDs = new HashMap<String, String>();
        HashMap<String, StringBuffer> organismNames2primarySequences = new HashMap<String, StringBuffer>();
        this.molecules = new ArrayList<Molecule>();
        this.secondaryStructures = new ArrayList<SecondaryStructure>();
        this.structuralAlignments = new ArrayList<StructuralAlignment>();
        StructuralIdentity si = null;
        StringBuffer brackets = new StringBuffer();
        String rfamID = null;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(f));
            while ((line = in.readLine()) != null) {
                String[] tokens = line.split("\\s+");
                if (line.startsWith("#=GF AC")) {
                    rfamID = tokens[2].trim();
                    continue;
                }
                if (tokens[0].equals("#=GF")) continue;
                if (tokens[0].equals("#=GS")) {
                    organismNames2organismIDs.put(tokens[1], tokens[3]);
                    continue;
                }
                if (line.startsWith(CONSENSUS_STRUCTURE_HEADER)) {
                    brackets.append(tokens[2].trim().replace('<', '(').replace('>', ')').replace('.', '-'));
                    continue;
                }
                if (line.startsWith(FILE_HEADER) || line.startsWith("#") || line.startsWith("//") || line.trim().length() == 0) continue;
                StringBuffer buff = (StringBuffer)organismNames2primarySequences.get(tokens[0]);
                if (buff == null) {
                    buff = new StringBuffer();
                    organismNames2primarySequences.put(tokens[0], buff);
                }
                buff.append(tokens[1].trim().replace('.', '-'));
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FileParsingException(e);
        }
        StructuralAlignment structuralAlignment = this.identityFeatureFactory.createStructuralAligment(rfamID, Source.getFileAsSource(f));
        this.structuralAlignments.add(structuralAlignment);
        try {
            for (Map.Entry e : organismNames2primarySequences.entrySet()) {
                Location gapsPositions = new Location();
                String alignedSequence = ((StringBuffer)e.getValue()).toString();
                RNA m = this.workingSession.createRNA(new ParadiseID(), (String)e.getKey() + (organismNames2organismIDs.isEmpty() ? "" : " " + (String)organismNames2organismIDs.get(e.getKey())), Source.getFileAsSource(f), alignedSequence.replaceAll("-", ""));
                this.molecules.add(m);
                char[] characters = alignedSequence.toCharArray();
                for (int i = 0; i < characters.length; ++i) {
                    if (characters[i] != '-') continue;
                    gapsPositions.add(i + 1);
                }
                if (si == null) {
                    si = this.identityFeatureFactory.createStructuralIdentity(structuralAlignment, "si", m, new Location(1, m.getLength()));
                } else {
                    m.addFeature(si, new Location(1, m.getLength()));
                }
                si.addGapsLocation(m, gapsPositions);
                this.generateSecondaryStructure(f, m, alignedSequence, brackets);
                this.secondaryStructures.get(this.secondaryStructures.size() - 1).linkStructuralAlignment(structuralAlignment);
            }
        }
        catch (BiologicalSymbolException e) {
            throw new FileParsingException(e);
        }
    }

    private void generateSecondaryStructure(File f, Molecule m, String alignedSequence, StringBuffer brackets) throws FileParsingException, BiologicalSymbolException {
        ArrayList<Location> helices = new ArrayList<Location>();
        ArrayList<Location> tertiaryInteractions = new ArrayList<Location>();
        ArrayList<Location> allpairs = new ArrayList<Location>();
        if (brackets.length() == alignedSequence.length()) {
            int i;
            Location locationInTheMolecule = new Location();
            Location locationInTheAlignedSequence = new Location();
            this.secondaryStructures.add(this.structuralFeatureFactory.createRNASecondaryStructure("SS " + f.getName(), Source.getFileAsSource(f), m, new Location(1, m.getLength())));
            int moleculePosition = 0;
            block4: for (int i2 = 0; i2 < brackets.length(); ++i2) {
                if (alignedSequence.charAt(i2) != '-') {
                    ++moleculePosition;
                }
                char c = brackets.charAt(i2);
                switch (c) {
                    case '(': {
                        locationInTheMolecule.add(moleculePosition);
                        locationInTheAlignedSequence.add(i2);
                        continue block4;
                    }
                    case ')': {
                        if (alignedSequence.charAt(locationInTheAlignedSequence.getEnd()) != '-' && alignedSequence.charAt(i2) != '-') {
                            allpairs.add(new Location(new Location(locationInTheMolecule.getEnd()), new Location(moleculePosition)));
                        }
                        locationInTheMolecule.remove(locationInTheMolecule.getEnd());
                        locationInTheAlignedSequence.remove(locationInTheAlignedSequence.getEnd());
                    }
                }
            }
            Collections.sort(allpairs, new Comparator(){

                public int compare(Object o, Object o1) {
                    return ((Location)o).getStart() - ((Location)o1).getStart();
                }
            });
            Location allSingleStrandsLocation = new Location(1, m.getLength());
            Location l = null;
            for (i = 0; i < allpairs.size() - 1; ++i) {
                Location l1 = (Location)allpairs.get(i);
                Location l2 = (Location)allpairs.get(i + 1);
                if (l1.getStart() + 1 == l2.getStart() && l1.getEnd() - 1 == l2.getEnd()) {
                    if (l == null) {
                        l = new Location(l1, l2);
                        continue;
                    }
                    l.add(l1);
                    l.add(l2);
                    continue;
                }
                if (l != null) {
                    if (l.getLength() == 2) {
                        tertiaryInteractions.add(l);
                    } else {
                        helices.add(l);
                        allSingleStrandsLocation.remove(l);
                    }
                }
                l = null;
            }
            if (l != null) {
                if (l.getLength() == 2) {
                    tertiaryInteractions.add(l);
                } else {
                    helices.add(l);
                    allSingleStrandsLocation.remove(l);
                }
            }
            i = 1;
            for (Location _l : helices) {
                this.structuralFeatureFactory.createHelix("H" + i++, this.secondaryStructures.get(this.secondaryStructures.size() - 1), m, _l);
            }
            for (Location _l : tertiaryInteractions) {
                this.structuralFeatureFactory.createBaseBaseInteraction('W', 'W', 'C', 1, this.secondaryStructures.get(this.secondaryStructures.size() - 1), m, _l);
            }
            int[] boundaries = allSingleStrandsLocation.getBoundaries();
            for (i = 0; i < boundaries.length; i += 2) {
                this.structuralFeatureFactory.createSingleStrand("SS" + (i + 1), this.secondaryStructures.get(this.secondaryStructures.size() - 1), m, new Location(boundaries[i], boundaries[i + 1]));
            }
        } else {
            throw new FileParsingException("One sequence has not the same size than its brackets");
        }
    }
}

