/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.mypdb;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.core.io.ParadiseProjectIO;
import fr.unistra.ibmc.paradise.tools.Paradise;
import fr.unistra.ibmc.paradise.tools.component.DefaultProgressMonitor;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphmatching.PatternMatch;
import org.neo4j.graphmatching.PatternMatcher;
import org.neo4j.graphmatching.PatternNode;
import org.neo4j.graphmatching.ValueMatcher;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public class MyPDB {
    public static void indexTertiaryStructure(String pdbID, ParadiseWorkingSession pws) {
        File tertiaryStructure = new File(Paradise.getMyPDBDir(), pdbID);
        ParadiseProjectIO parser = new ParadiseProjectIO(pws);
        Hashtable<Long, Long> ids = new Hashtable<Long, Long>();
        File model = new File(tertiaryStructure, "model");
        if (!model.exists()) {
            return;
        }
        try {
            parser.parseFile(model, new DefaultProgressMonitor());
        }
        catch (Exception e) {
            return;
        }
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(Paradise.getMyPDBIndex().getAbsolutePath());
        for (SecondaryStructure secondaryStructure : parser.getSecondaryStructures()) {
            Transaction tx;
            for (Helix h : secondaryStructure.getHelices()) {
                tx = graphDb.beginTx();
                Node helix = graphDb.createNode();
                ids.put(h.getParadiseID().getValue(), helix.getId());
                helix.setProperty("Type", (Object)"Helix");
                helix.setProperty("PDBID", (Object)tertiaryStructure.getName());
                helix.setProperty("Length", (Object)h.getLength());
                StringBuffer location = new StringBuffer();
                for (Molecule m : h.getMolecules()) {
                    location.append(m.getParadiseID().getValue() + "#" + m.getName() + " " + h.getFullLocation(m) + " ");
                }
                helix.setProperty("Location", (Object)location.toString().trim());
                for (Helix _h : h.getDirectlyLinkedHelicesAt5PrimeEnds()) {
                    if (_h == null || !ids.containsKey(_h.getParadiseID().getValue()) || _h == h) continue;
                    graphDb.getNodeById(((Long)ids.get(_h.getParadiseID().getValue())).longValue()).createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND);
                }
                for (Helix _h : h.getDirectlyLinkedHelicesAt3PrimeEnds()) {
                    if (_h == null || !ids.containsKey(_h.getParadiseID().getValue()) || _h == h) continue;
                    helix.createRelationshipTo(graphDb.getNodeById(((Long)ids.get(_h.getParadiseID().getValue())).longValue()), (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND);
                }
                tx.success();
                tx.finish();
            }
            for (SingleStrand ss : secondaryStructure.getSingleStrands()) {
                Node helix;
                tx = graphDb.beginTx();
                Node singlestrand = graphDb.createNode();
                singlestrand.setProperty("Length", (Object)ss.getLength());
                singlestrand.setProperty("PDBID", (Object)tertiaryStructure.getName());
                Molecule m = ss.getMolecules().iterator().next();
                singlestrand.setProperty("Location", (Object)(m.getParadiseID().getValue() + "#" + m.getName() + " " + ss.getFullLocation(m)));
                if (ss.isAtFivePrimeEnd()) {
                    if (!ss.isAtThreePrimeEnd()) {
                        helix = graphDb.getNodeById(((Long)ids.get(ss.getNextHelix().getParadiseID().getValue())).longValue());
                        singlestrand.createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND);
                        singlestrand.setProperty("Type", (Object)"Terminal Loop");
                    }
                } else if (ss.isAtThreePrimeEnd()) {
                    if (!ss.isAtFivePrimeEnd()) {
                        helix = graphDb.getNodeById(((Long)ids.get(ss.getPreviousHelix().getParadiseID().getValue())).longValue());
                        helix.createRelationshipTo(singlestrand, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND);
                        singlestrand.setProperty("Type", (Object)"Terminal Loop");
                    }
                } else if (ss.isApicalLoop()) {
                    helix = graphDb.getNodeById(((Long)ids.get(ss.getPreviousHelix().getParadiseID().getValue())).longValue());
                    helix.createRelationshipTo(singlestrand, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND);
                    singlestrand.createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND);
                    singlestrand.setProperty("Type", (Object)"Apical Loop");
                } else {
                    Node helix1 = graphDb.getNodeById(((Long)ids.get(ss.getPreviousHelix().getParadiseID().getValue())).longValue());
                    Node helix2 = graphDb.getNodeById(((Long)ids.get(ss.getNextHelix().getParadiseID().getValue())).longValue());
                    helix1.createRelationshipTo(singlestrand, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND);
                    singlestrand.createRelationshipTo(helix2, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND);
                    if (ss.isInternalLoop()) {
                        singlestrand.setProperty("Type", (Object)"Internal Loop");
                    } else {
                        singlestrand.setProperty("Type", (Object)"Junction");
                    }
                }
                tx.success();
                tx.finish();
            }
        }
        graphDb.shutdown();
    }

    public static void removeTertiaryStructureFromIndex(final String pdbID) {
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(Paradise.getMyPDBIndex().getAbsolutePath());
        Transaction tx = graphDb.beginTx();
        PatternMatcher matcher = PatternMatcher.getMatcher();
        PatternNode node = new PatternNode();
        node.addPropertyConstraint("PDBID", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return pdbID.equals(value);
                }
                return false;
            }
        });
        for (Node n : graphDb.getAllNodes()) {
            Iterator matches = matcher.match(node, n).iterator();
            while (matches.hasNext()) {
                Node _n = ((PatternMatch)matches.next()).getNodeFor(node);
                Iterator it = _n.getRelationships().iterator();
                while (it.hasNext()) {
                    ((Relationship)it.next()).delete();
                }
                _n.delete();
            }
        }
        tx.success();
        tx.finish();
        graphDb.shutdown();
    }
}

