/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.mypdb;

import fr.unistra.ibmc.paradise.core.Location;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyPDBHit {
    private String pdbID;
    private Map<String, Location> locations;

    public MyPDBHit(String pdbID) {
        this.pdbID = pdbID;
        this.locations = new Hashtable<String, Location>();
    }

    public void addLocation(String moleculeID, Location l) {
        if (this.locations.containsKey(moleculeID)) {
            this.locations.put(moleculeID, this.locations.get(moleculeID).unionOf(l));
        } else {
            this.locations.put(moleculeID, l);
        }
    }

    public Map<String, Location> getLocations() {
        return this.locations;
    }

    public String getPdbID() {
        return this.pdbID;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (Map.Entry<String, Location> l : this.locations.entrySet()) {
            buff.append(l.getKey().split("#")[1] + '#' + l.getValue() + " ");
        }
        return buff.toString().trim();
    }

    public boolean equals(Object o) {
        if (!MyPDBHit.class.isInstance(o)) {
            return false;
        }
        return this.pdbID.equals(((MyPDBHit)o).pdbID) && this.toString().equals(o.toString());
    }
}

