/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.mypdb;

import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.mypdb.MyPDBHit;
import fr.unistra.ibmc.paradise.tools.Paradise;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.commons.iterator.FilteringIterable;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphmatching.PatternMatch;
import org.neo4j.graphmatching.PatternMatcher;
import org.neo4j.graphmatching.PatternNode;
import org.neo4j.graphmatching.ValueMatcher;
import org.neo4j.kernel.EmbeddedGraphDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyPDBQuery {
    public static String lastApicalLoopsQuery = "length";
    public static String lastInternalLoopsQuery = "length1 length2";
    public static String lastThreeWayJunctionsQuery = "length1 length2 length3";
    public static String lastFourWayJunctionsQuery = "length1 length2 length3 length4";

    public static final Set<MyPDBHit> searchPseudoKnots() throws BiologicalSymbolException {
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(Paradise.getMyPDBIndex().getAbsolutePath());
        HashSet<MyPDBHit> hits = new HashSet<MyPDBHit>();
        Transaction tx = graphDb.beginTx();
        PatternMatcher matcher = PatternMatcher.getMatcher();
        tx.success();
        tx.finish();
        graphDb.shutdown();
        return hits;
    }

    public static Set<MyPDBHit> searchInternalLoops(final String length1, final String length2) throws BiologicalSymbolException {
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(Paradise.getMyPDBIndex().getAbsolutePath());
        HashSet<MyPDBHit> hits = new HashSet<MyPDBHit>();
        Transaction tx = graphDb.beginTx();
        PatternMatcher matcher = PatternMatcher.getMatcher();
        final PatternNode loop1 = new PatternNode();
        final PatternNode loop2 = new PatternNode();
        PatternNode helix1 = new PatternNode();
        final PatternNode helix2 = new PatternNode();
        loop1.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Internal Loop".equals(value);
                }
                return false;
            }
        });
        loop1.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    int length = Integer.parseInt(length1.substring(1));
                    switch (length1.charAt(0)) {
                        case '=': {
                            return (Integer)value == length;
                        }
                        case '>': {
                            return (Integer)value > length;
                        }
                        case '<': {
                            return (Integer)value < length;
                        }
                    }
                }
                return false;
            }
        });
        loop2.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Internal Loop".equals(value);
                }
                return false;
            }
        });
        loop2.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    int length = Integer.parseInt(length2.substring(1));
                    switch (length2.charAt(0)) {
                        case '=': {
                            return (Integer)value == length;
                        }
                        case '>': {
                            return (Integer)value > length;
                        }
                        case '<': {
                            return (Integer)value < length;
                        }
                    }
                }
                return false;
            }
        });
        helix1.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Helix".equals(value);
                }
                return false;
            }
        });
        helix1.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    return (Integer)value >= 2;
                }
                return false;
            }
        });
        helix2.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Helix".equals(value);
                }
                return false;
            }
        });
        helix2.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    return (Integer)value >= 2;
                }
                return false;
            }
        });
        helix1.createRelationshipTo(loop1, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        loop1.createRelationshipTo(helix2, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        helix2.createRelationshipTo(loop2, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        loop2.createRelationshipTo(helix1, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        for (Node n : graphDb.getAllNodes()) {
            for (PatternMatch match : new FilteringIterable<PatternMatch>(matcher.match(loop1, n)){

                protected boolean passes(PatternMatch match) {
                    String[] location1 = ((String)match.getNodeFor(loop1).getProperty("Location")).split(" ");
                    String[] location2 = ((String)match.getNodeFor(loop2).getProperty("Location")).split(" ");
                    try {
                        return location1[0].equals(location2[0]) && new Location(location1[1]).getEnd() + (Integer)match.getNodeFor(helix2).getProperty("Length") + 1 != new Location(location2[1]).getStart();
                    }
                    catch (BiologicalSymbolException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            }) {
                int i;
                MyPDBHit hit = new MyPDBHit((String)match.getNodeFor(helix1).getProperty("PDBID"));
                String[] location = ((String)match.getNodeFor(helix1).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(helix2).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(loop1).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(loop2).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                hits.add(hit);
            }
        }
        tx.success();
        tx.finish();
        graphDb.shutdown();
        return hits;
    }

    public static Set<MyPDBHit> searchApicalLoops(final String length1) throws BiologicalSymbolException {
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(Paradise.getMyPDBIndex().getAbsolutePath());
        HashSet<MyPDBHit> hits = new HashSet<MyPDBHit>();
        Transaction tx = graphDb.beginTx();
        PatternMatcher matcher = PatternMatcher.getMatcher();
        PatternNode apicalLoop = new PatternNode();
        apicalLoop.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Apical Loop".equals(value);
                }
                return false;
            }
        });
        apicalLoop.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    int length = Integer.parseInt(length1.substring(1));
                    switch (length1.charAt(0)) {
                        case '=': {
                            return (Integer)value == length;
                        }
                        case '>': {
                            return (Integer)value > length;
                        }
                        case '<': {
                            return (Integer)value < length;
                        }
                    }
                }
                return false;
            }
        });
        for (Node n : graphDb.getAllNodes()) {
            for (PatternMatch match : matcher.match(apicalLoop, n)) {
                MyPDBHit hit = new MyPDBHit((String)match.getNodeFor(apicalLoop).getProperty("PDBID"));
                String[] location = ((String)match.getNodeFor(apicalLoop).getProperty("Location")).split(" ");
                for (int i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                hits.add(hit);
            }
        }
        tx.success();
        tx.finish();
        graphDb.shutdown();
        return hits;
    }

    public static Set<MyPDBHit> searchThreeWayJunctions(final String length12, final String length23, final String length31) throws BiologicalSymbolException {
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(Paradise.getMyPDBIndex().getAbsolutePath());
        HashSet<MyPDBHit> hits = new HashSet<MyPDBHit>();
        Transaction tx = graphDb.beginTx();
        PatternMatcher matcher = PatternMatcher.getMatcher();
        final PatternNode junction12 = new PatternNode();
        PatternNode junction23 = new PatternNode();
        final PatternNode junction31 = new PatternNode();
        final PatternNode helix1 = new PatternNode();
        PatternNode helix2 = new PatternNode();
        PatternNode helix3 = new PatternNode();
        junction12.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Junction".equals(value);
                }
                return false;
            }
        });
        junction12.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    int length = Integer.parseInt(length12.substring(1));
                    switch (length12.charAt(0)) {
                        case '=': {
                            return (Integer)value == length;
                        }
                        case '>': {
                            return (Integer)value > length;
                        }
                        case '<': {
                            return (Integer)value < length;
                        }
                    }
                }
                return false;
            }
        });
        junction23.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Junction".equals(value);
                }
                return false;
            }
        });
        junction23.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    int length = Integer.parseInt(length23.substring(1));
                    switch (length23.charAt(0)) {
                        case '=': {
                            return (Integer)value == length;
                        }
                        case '>': {
                            return (Integer)value > length;
                        }
                        case '<': {
                            return (Integer)value < length;
                        }
                    }
                }
                return false;
            }
        });
        junction31.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Junction".equals(value);
                }
                return false;
            }
        });
        junction31.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    int length = Integer.parseInt(length31.substring(1));
                    switch (length31.charAt(0)) {
                        case '=': {
                            return (Integer)value == length;
                        }
                        case '>': {
                            return (Integer)value > length;
                        }
                        case '<': {
                            return (Integer)value < length;
                        }
                    }
                }
                return false;
            }
        });
        helix1.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Helix".equals(value);
                }
                return false;
            }
        });
        helix1.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    return (Integer)value >= 2;
                }
                return false;
            }
        });
        helix2.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Helix".equals(value);
                }
                return false;
            }
        });
        helix2.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    return (Integer)value >= 2;
                }
                return false;
            }
        });
        helix3.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Helix".equals(value);
                }
                return false;
            }
        });
        helix3.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    return (Integer)value >= 2;
                }
                return false;
            }
        });
        helix1.createRelationshipTo(junction12, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        junction12.createRelationshipTo(helix2, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        helix2.createRelationshipTo(junction23, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        junction23.createRelationshipTo(helix3, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        helix3.createRelationshipTo(junction31, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        junction31.createRelationshipTo(helix1, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        for (Node n : graphDb.getAllNodes()) {
            for (PatternMatch match : new FilteringIterable<PatternMatch>(matcher.match(helix1, n)){

                protected boolean passes(PatternMatch match) {
                    String[] helix1Location = ((String)match.getNodeFor(helix1).getProperty("Location")).split(" ");
                    String[] junction12Location = ((String)match.getNodeFor(junction12).getProperty("Location")).split(" ");
                    String[] junction31Location = ((String)match.getNodeFor(junction31).getProperty("Location")).split(" ");
                    try {
                        return new Location(helix1Location[1]).getStart() - 1 == new Location(junction31Location[1]).getEnd() && new Location(helix1Location[1]).getEnd() + 1 == new Location(junction12Location[1]).getStart() || new Location(helix1Location[1]).getEnd() - (Integer)match.getNodeFor(helix1).getProperty("Length") == new Location(junction31Location[1]).getEnd() && new Location(helix1Location[1]).getStart() + (Integer)match.getNodeFor(helix1).getProperty("Length") == new Location(junction12Location[1]).getStart();
                    }
                    catch (BiologicalSymbolException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            }) {
                int i;
                MyPDBHit hit = new MyPDBHit((String)match.getNodeFor(helix1).getProperty("PDBID"));
                String[] location = ((String)match.getNodeFor(helix1).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(helix2).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(helix3).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(junction12).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(junction23).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(junction31).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                hits.add(hit);
            }
        }
        tx.success();
        tx.finish();
        graphDb.shutdown();
        return hits;
    }

    public static Set<MyPDBHit> searchFourWayJunctions(final String length12, final String length23, final String length34, final String length41) throws BiologicalSymbolException {
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(Paradise.getMyPDBIndex().getAbsolutePath());
        HashSet<MyPDBHit> hits = new HashSet<MyPDBHit>();
        Transaction tx = graphDb.beginTx();
        PatternMatcher matcher = PatternMatcher.getMatcher();
        final PatternNode junction12 = new PatternNode();
        PatternNode junction23 = new PatternNode();
        PatternNode junction34 = new PatternNode();
        final PatternNode junction41 = new PatternNode();
        final PatternNode helix1 = new PatternNode();
        PatternNode helix2 = new PatternNode();
        PatternNode helix3 = new PatternNode();
        PatternNode helix4 = new PatternNode();
        junction12.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Junction".equals(value);
                }
                return false;
            }
        });
        junction12.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    int length = Integer.parseInt(length12.substring(1));
                    switch (length12.charAt(0)) {
                        case '=': {
                            return (Integer)value == length;
                        }
                        case '>': {
                            return (Integer)value > length;
                        }
                        case '<': {
                            return (Integer)value < length;
                        }
                    }
                }
                return false;
            }
        });
        junction23.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Junction".equals(value);
                }
                return false;
            }
        });
        junction23.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    int length = Integer.parseInt(length23.substring(1));
                    switch (length23.charAt(0)) {
                        case '=': {
                            return (Integer)value == length;
                        }
                        case '>': {
                            return (Integer)value > length;
                        }
                        case '<': {
                            return (Integer)value < length;
                        }
                    }
                }
                return false;
            }
        });
        junction34.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Junction".equals(value);
                }
                return false;
            }
        });
        junction34.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    int length = Integer.parseInt(length34.substring(1));
                    switch (length34.charAt(0)) {
                        case '=': {
                            return (Integer)value == length;
                        }
                        case '>': {
                            return (Integer)value > length;
                        }
                        case '<': {
                            return (Integer)value < length;
                        }
                    }
                }
                return false;
            }
        });
        junction41.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Junction".equals(value);
                }
                return false;
            }
        });
        junction41.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    int length = Integer.parseInt(length41.substring(1));
                    switch (length41.charAt(0)) {
                        case '=': {
                            return (Integer)value == length;
                        }
                        case '>': {
                            return (Integer)value > length;
                        }
                        case '<': {
                            return (Integer)value < length;
                        }
                    }
                }
                return false;
            }
        });
        helix1.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Helix".equals(value);
                }
                return false;
            }
        });
        helix1.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    return (Integer)value >= 2;
                }
                return false;
            }
        });
        helix2.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Helix".equals(value);
                }
                return false;
            }
        });
        helix2.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    return (Integer)value >= 2;
                }
                return false;
            }
        });
        helix3.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Helix".equals(value);
                }
                return false;
            }
        });
        helix3.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    return (Integer)value >= 2;
                }
                return false;
            }
        });
        helix4.addPropertyConstraint("Type", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof String) {
                    return "Helix".equals(value);
                }
                return false;
            }
        });
        helix4.addPropertyConstraint("Length", new ValueMatcher(){

            public boolean matches(Object value) {
                if (value instanceof Integer) {
                    return (Integer)value >= 2;
                }
                return false;
            }
        });
        helix1.createRelationshipTo(junction12, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        junction12.createRelationshipTo(helix2, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        helix2.createRelationshipTo(junction23, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        junction23.createRelationshipTo(helix3, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        helix3.createRelationshipTo(junction34, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        junction34.createRelationshipTo(helix4, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        helix4.createRelationshipTo(junction41, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        junction41.createRelationshipTo(helix1, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
        for (Node n : graphDb.getAllNodes()) {
            for (PatternMatch match : new FilteringIterable<PatternMatch>(matcher.match(helix1, n)){

                protected boolean passes(PatternMatch match) {
                    String[] helix1Location = ((String)match.getNodeFor(helix1).getProperty("Location")).split(" ");
                    String[] junction12Location = ((String)match.getNodeFor(junction12).getProperty("Location")).split(" ");
                    String[] junction41Location = ((String)match.getNodeFor(junction41).getProperty("Location")).split(" ");
                    try {
                        return new Location(helix1Location[1]).getStart() - 1 == new Location(junction41Location[1]).getEnd() && new Location(helix1Location[1]).getEnd() + 1 == new Location(junction12Location[1]).getStart() || new Location(helix1Location[1]).getEnd() - (Integer)match.getNodeFor(helix1).getProperty("Length") == new Location(junction41Location[1]).getEnd() && new Location(helix1Location[1]).getStart() + (Integer)match.getNodeFor(helix1).getProperty("Length") == new Location(junction12Location[1]).getStart();
                    }
                    catch (BiologicalSymbolException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            }) {
                int i;
                MyPDBHit hit = new MyPDBHit((String)match.getNodeFor(helix1).getProperty("PDBID"));
                String[] location = ((String)match.getNodeFor(helix1).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(helix2).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(helix3).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(helix4).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(junction12).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(junction23).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(junction34).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                location = ((String)match.getNodeFor(junction41).getProperty("Location")).split(" ");
                for (i = 0; i <= location.length - 2; i += 2) {
                    hit.addLocation(location[i], new Location(location[i + 1]));
                }
                hits.add(hit);
            }
        }
        tx.success();
        tx.finish();
        graphDb.shutdown();
        return hits;
    }

    public static Set<MyPDBHit> searchSingleStrands(String description) throws BiologicalSymbolException {
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(Paradise.getMyPDBIndex().getAbsolutePath());
        HashSet<MyPDBHit> hits = new HashSet<MyPDBHit>();
        Transaction tx = graphDb.beginTx();
        PatternMatcher matcher = PatternMatcher.getMatcher();
        if (description.matches("I1\\([=><].+\\)I4\\([=><].+\\)A\\([=><].+\\)")) {
            final PatternNode singleStrand1 = new PatternNode();
            final PatternNode singleStrand2 = new PatternNode();
            PatternNode singleStrand4 = new PatternNode();
            final PatternNode helix = new PatternNode();
            final int length1 = Integer.parseInt(description.substring(description.indexOf("I1(") + 4, description.indexOf(")I4")));
            final char operator1 = description.charAt(description.indexOf("I1(") + 3);
            if (length1 != 0 || operator1 == '>') {
                singleStrand1.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Internal Loop".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand1.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator1) {
                                case '=': {
                                    return (Integer)value == length1;
                                }
                                case '<': {
                                    return (Integer)value < length1;
                                }
                                case '>': {
                                    return (Integer)value > length1;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand1.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand1.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            final int length2 = Integer.parseInt(description.substring(description.indexOf("A(") + 3, description.length() - 1));
            final char operator2 = description.charAt(description.indexOf("A(") + 2);
            if (length2 == 0 && operator2 != '>') {
                return hits;
            }
            singleStrand2.addPropertyConstraint("Type", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof String) {
                        return "Apical Loop".equals(value);
                    }
                    return false;
                }
            });
            singleStrand2.addPropertyConstraint("Length", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof Integer) {
                        switch (operator2) {
                            case '=': {
                                return (Integer)value == length2;
                            }
                            case '<': {
                                return (Integer)value < length2;
                            }
                            case '>': {
                                return (Integer)value > length2;
                            }
                        }
                    }
                    return false;
                }
            });
            final int length4 = Integer.parseInt(description.substring(description.indexOf("I4(") + 4, description.indexOf(")A")));
            final char operator4 = description.charAt(description.indexOf("I4(") + 3);
            if (length4 != 0 || operator4 == '>') {
                singleStrand4.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Internal Loop".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand4.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator4) {
                                case '=': {
                                    return (Integer)value == length4;
                                }
                                case '<': {
                                    return (Integer)value < length4;
                                }
                                case '>': {
                                    return (Integer)value > length4;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand4.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand4.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            helix.addPropertyConstraint("Type", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof String) {
                        return "Helix".equals(value);
                    }
                    return false;
                }
            });
            helix.addPropertyConstraint("Length", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof Integer) {
                        return (Integer)value >= 2;
                    }
                    return false;
                }
            });
            singleStrand1.createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            helix.createRelationshipTo(singleStrand2, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            singleStrand2.createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            helix.createRelationshipTo(singleStrand4, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            for (Node n : graphDb.getAllNodes()) {
                for (PatternMatch match : new FilteringIterable<PatternMatch>(matcher.match(singleStrand1, n)){

                    protected boolean passes(PatternMatch match) {
                        String[] location1 = ((String)match.getNodeFor(singleStrand1).getProperty("Location")).split(" ");
                        String[] location2 = ((String)match.getNodeFor(singleStrand2).getProperty("Location")).split(" ");
                        try {
                            return location1[0].equals(location2[0]) && new Location(location1[1]).getEnd() + (Integer)match.getNodeFor(helix).getProperty("Length") + 1 == new Location(location2[1]).getStart();
                        }
                        catch (BiologicalSymbolException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                }) {
                    int i;
                    MyPDBHit hit = new MyPDBHit((String)match.getNodeFor(singleStrand1).getProperty("PDBID"));
                    String[] location = ((String)match.getNodeFor(singleStrand1).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand2).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand4).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(helix).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    hits.add(hit);
                }
            }
        } else if (description.matches("J1\\([=><].+\\)J4\\([=><].+\\)A\\([=><].+\\)")) {
            final PatternNode singleStrand1 = new PatternNode();
            final PatternNode singleStrand2 = new PatternNode();
            PatternNode singleStrand4 = new PatternNode();
            final PatternNode helix = new PatternNode();
            final int length1 = Integer.parseInt(description.substring(description.indexOf("J1(") + 4, description.indexOf(")J4")));
            final char operator1 = description.charAt(description.indexOf("J1(") + 3);
            if (length1 != 0) {
                singleStrand1.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Junction".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand1.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator1) {
                                case '=': {
                                    return (Integer)value == length1;
                                }
                                case '<': {
                                    return (Integer)value < length1;
                                }
                                case '>': {
                                    return (Integer)value > length1;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand1.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand1.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            final int length2 = Integer.parseInt(description.substring(description.indexOf("A(") + 3, description.length() - 1));
            final char operator2 = description.charAt(description.indexOf("A(") + 2);
            if (length2 == 0) {
                return hits;
            }
            singleStrand2.addPropertyConstraint("Type", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof String) {
                        return "Apical Loop".equals(value);
                    }
                    return false;
                }
            });
            singleStrand2.addPropertyConstraint("Length", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof Integer) {
                        switch (operator2) {
                            case '=': {
                                return (Integer)value == length2;
                            }
                            case '<': {
                                return (Integer)value < length2;
                            }
                            case '>': {
                                return (Integer)value > length2;
                            }
                        }
                    }
                    return false;
                }
            });
            final int length4 = Integer.parseInt(description.substring(description.indexOf("J4(") + 4, description.indexOf(")A")));
            final char operator4 = description.charAt(description.indexOf("J4(") + 3);
            if (length4 != 0) {
                singleStrand4.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Junction".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand4.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator4) {
                                case '=': {
                                    return (Integer)value == length4;
                                }
                                case '<': {
                                    return (Integer)value < length4;
                                }
                                case '>': {
                                    return (Integer)value > length4;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand4.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand4.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            helix.addPropertyConstraint("Type", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof String) {
                        return "Helix".equals(value);
                    }
                    return false;
                }
            });
            helix.addPropertyConstraint("Length", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof Integer) {
                        return (Integer)value >= 2;
                    }
                    return false;
                }
            });
            singleStrand1.createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            helix.createRelationshipTo(singleStrand2, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            singleStrand2.createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            helix.createRelationshipTo(singleStrand4, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            for (Node n : graphDb.getAllNodes()) {
                for (PatternMatch match : new FilteringIterable<PatternMatch>(matcher.match(singleStrand1, n)){

                    protected boolean passes(PatternMatch match) {
                        String[] location1 = ((String)match.getNodeFor(singleStrand1).getProperty("Location")).split(" ");
                        String[] location2 = ((String)match.getNodeFor(singleStrand2).getProperty("Location")).split(" ");
                        try {
                            return location1[0].equals(location2[0]) && new Location(location1[1]).getEnd() + (Integer)match.getNodeFor(helix).getProperty("Length") + 1 == new Location(location2[1]).getStart();
                        }
                        catch (BiologicalSymbolException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                }) {
                    int i;
                    MyPDBHit hit = new MyPDBHit((String)match.getNodeFor(singleStrand1).getProperty("PDBID"));
                    String[] location = ((String)match.getNodeFor(singleStrand1).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand2).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand4).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(helix).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    hits.add(hit);
                }
            }
        } else if (description.matches("I1\\([=><].+\\)I4\\([=><].+\\)I2\\([=><].+\\)I3\\([=><].+\\)")) {
            final PatternNode singleStrand1 = new PatternNode();
            final PatternNode singleStrand2 = new PatternNode();
            PatternNode singleStrand3 = new PatternNode();
            PatternNode singleStrand4 = new PatternNode();
            final PatternNode helix = new PatternNode();
            final int length1 = Integer.parseInt(description.substring(description.indexOf("I1(") + 4, description.indexOf(")I4")));
            final char operator1 = description.charAt(description.indexOf("I1(") + 3);
            if (length1 != 0 || operator1 == '>') {
                singleStrand1.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Internal Loop".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand1.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator1) {
                                case '=': {
                                    return (Integer)value == length1;
                                }
                                case '<': {
                                    return (Integer)value < length1;
                                }
                                case '>': {
                                    return (Integer)value > length1;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand1.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand1.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            final int length2 = Integer.parseInt(description.substring(description.indexOf("I2(") + 4, description.indexOf(")I3")));
            final char operator2 = description.charAt(description.indexOf("I2(") + 3);
            if (length2 != 0 || operator2 == '>') {
                singleStrand2.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Internal Loop".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand2.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator2) {
                                case '=': {
                                    return (Integer)value == length2;
                                }
                                case '<': {
                                    return (Integer)value < length2;
                                }
                                case '>': {
                                    return (Integer)value > length2;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand2.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand2.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            final int length3 = Integer.parseInt(description.substring(description.indexOf("I3(") + 4, description.length() - 1));
            final char operator3 = description.charAt(description.indexOf("I3(") + 3);
            if (length3 != 0 || operator3 == '>') {
                singleStrand3.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Internal Loop".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand3.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator3) {
                                case '=': {
                                    return (Integer)value == length3;
                                }
                                case '<': {
                                    return (Integer)value < length3;
                                }
                                case '>': {
                                    return (Integer)value > length3;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand3.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand3.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            final int length4 = Integer.parseInt(description.substring(description.indexOf("I4(") + 4, description.indexOf(")I2")));
            final char operator4 = description.charAt(description.indexOf("I4(") + 3);
            if (length4 != 0 || operator4 == '>') {
                singleStrand4.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Internal Loop".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand4.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator4) {
                                case '=': {
                                    return (Integer)value == length4;
                                }
                                case '<': {
                                    return (Integer)value < length4;
                                }
                                case '>': {
                                    return (Integer)value > length4;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand4.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Internal Loop".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand4.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value == length4;
                        }
                        return false;
                    }
                });
            }
            helix.addPropertyConstraint("Type", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof String) {
                        return "Helix".equals(value);
                    }
                    return false;
                }
            });
            helix.addPropertyConstraint("Length", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof Integer) {
                        return (Integer)value >= 2;
                    }
                    return false;
                }
            });
            singleStrand1.createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            helix.createRelationshipTo(singleStrand2, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            singleStrand3.createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            helix.createRelationshipTo(singleStrand4, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            for (Node n : graphDb.getAllNodes()) {
                for (PatternMatch match : new FilteringIterable<PatternMatch>(matcher.match(singleStrand1, n)){

                    protected boolean passes(PatternMatch match) {
                        String[] location1 = ((String)match.getNodeFor(singleStrand1).getProperty("Location")).split(" ");
                        String[] location2 = ((String)match.getNodeFor(singleStrand2).getProperty("Location")).split(" ");
                        try {
                            return location1[0].equals(location2[0]) && new Location(location1[1]).getEnd() + (Integer)match.getNodeFor(helix).getProperty("Length") + 1 == new Location(location2[1]).getStart();
                        }
                        catch (BiologicalSymbolException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                }) {
                    int i;
                    MyPDBHit hit = new MyPDBHit((String)match.getNodeFor(singleStrand1).getProperty("PDBID"));
                    String[] location = ((String)match.getNodeFor(singleStrand1).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand2).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand3).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand4).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(helix).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    hits.add(hit);
                }
            }
        } else if (description.matches("J1\\([=><].+\\)J4\\([=><].+\\)J2\\([=><].+\\)J3\\([=><].+\\)")) {
            final PatternNode singleStrand1 = new PatternNode();
            final PatternNode singleStrand2 = new PatternNode();
            PatternNode singleStrand3 = new PatternNode();
            PatternNode singleStrand4 = new PatternNode();
            final PatternNode helix = new PatternNode();
            final int length1 = Integer.parseInt(description.substring(description.indexOf("J1(") + 4, description.indexOf(")J4")));
            final char operator1 = description.charAt(description.indexOf("J1(") + 3);
            if (length1 != 0 || operator1 == '>') {
                singleStrand1.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Junction".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand1.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator1) {
                                case '=': {
                                    return (Integer)value == length1;
                                }
                                case '<': {
                                    return (Integer)value < length1;
                                }
                                case '>': {
                                    return (Integer)value > length1;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand1.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand1.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            final int length2 = Integer.parseInt(description.substring(description.indexOf("J2(") + 4, description.indexOf(")J3")));
            final char operator2 = description.charAt(description.indexOf("J2(") + 3);
            if (length2 != 0 || operator2 == '>') {
                singleStrand2.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Junction".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand2.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator2) {
                                case '=': {
                                    return (Integer)value == length2;
                                }
                                case '<': {
                                    return (Integer)value < length2;
                                }
                                case '>': {
                                    return (Integer)value > length2;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand2.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand2.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            final int length3 = Integer.parseInt(description.substring(description.indexOf("J3(") + 4, description.length() - 1));
            final char operator3 = description.charAt(description.indexOf("J3(") + 3);
            if (length3 != 0 || operator3 == '>') {
                singleStrand3.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Junction".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand3.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator3) {
                                case '=': {
                                    return (Integer)value == length3;
                                }
                                case '<': {
                                    return (Integer)value < length3;
                                }
                                case '>': {
                                    return (Integer)value > length3;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand3.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand3.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            final int length4 = Integer.parseInt(description.substring(description.indexOf("J4(") + 4, description.indexOf(")J2")));
            final char operator4 = description.charAt(description.indexOf("J4(") + 3);
            if (length4 != 0 || operator4 == '>') {
                singleStrand4.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Junction".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand4.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator4) {
                                case '=': {
                                    return (Integer)value == length4;
                                }
                                case '<': {
                                    return (Integer)value < length4;
                                }
                                case '>': {
                                    return (Integer)value > length4;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand4.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand4.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            helix.addPropertyConstraint("Type", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof String) {
                        return "Helix".equals(value);
                    }
                    return false;
                }
            });
            helix.addPropertyConstraint("Length", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof Integer) {
                        return (Integer)value >= 2;
                    }
                    return false;
                }
            });
            singleStrand1.createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            helix.createRelationshipTo(singleStrand2, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            singleStrand3.createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            helix.createRelationshipTo(singleStrand4, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            for (Node n : graphDb.getAllNodes()) {
                for (PatternMatch match : new FilteringIterable<PatternMatch>(matcher.match(singleStrand1, n)){

                    protected boolean passes(PatternMatch match) {
                        String[] location1 = ((String)match.getNodeFor(singleStrand1).getProperty("Location")).split(" ");
                        String[] location2 = ((String)match.getNodeFor(singleStrand2).getProperty("Location")).split(" ");
                        try {
                            return location1[0].equals(location2[0]) && new Location(location1[1]).getEnd() + (Integer)match.getNodeFor(helix).getProperty("Length") + 1 == new Location(location2[1]).getStart();
                        }
                        catch (BiologicalSymbolException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                }) {
                    int i;
                    MyPDBHit hit = new MyPDBHit((String)match.getNodeFor(singleStrand1).getProperty("PDBID"));
                    String[] location = ((String)match.getNodeFor(singleStrand1).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand2).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand3).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand4).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(helix).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    hits.add(hit);
                }
            }
        } else if (description.matches("J1\\([=><].+\\)J4\\([=><].+\\)I2\\([=><].+\\)I3\\([=><].+\\)")) {
            final PatternNode singleStrand1 = new PatternNode();
            final PatternNode singleStrand2 = new PatternNode();
            PatternNode singleStrand3 = new PatternNode();
            PatternNode singleStrand4 = new PatternNode();
            final PatternNode helix = new PatternNode();
            final int length1 = Integer.parseInt(description.substring(description.indexOf("J1(") + 4, description.indexOf(")J4")));
            final char operator1 = description.charAt(description.indexOf("J1(") + 3);
            if (length1 != 0 || operator1 == '>') {
                singleStrand1.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Junction".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand1.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator1) {
                                case '=': {
                                    return (Integer)value == length1;
                                }
                                case '<': {
                                    return (Integer)value < length1;
                                }
                                case '>': {
                                    return (Integer)value > length1;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand1.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand1.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            final int length2 = Integer.parseInt(description.substring(description.indexOf("I2(") + 4, description.indexOf(")I3")));
            final char operator2 = description.charAt(description.indexOf("I2(") + 3);
            if (length2 != 0 || operator2 == '>') {
                singleStrand2.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Internal Loop".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand2.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator2) {
                                case '=': {
                                    return (Integer)value == length2;
                                }
                                case '<': {
                                    return (Integer)value < length2;
                                }
                                case '>': {
                                    return (Integer)value > length2;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand2.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand2.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            final int length3 = Integer.parseInt(description.substring(description.indexOf("I3(") + 4, description.length() - 1));
            final char operator3 = description.charAt(description.indexOf("I3(") + 3);
            if (length3 != 0 || operator3 == '>') {
                singleStrand3.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Internal Loop".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand3.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator3) {
                                case '=': {
                                    return (Integer)value == length3;
                                }
                                case '<': {
                                    return (Integer)value < length3;
                                }
                                case '>': {
                                    return (Integer)value > length3;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand3.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand3.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            final int length4 = Integer.parseInt(description.substring(description.indexOf("J4(") + 4, description.indexOf(")I2")));
            final char operator4 = description.charAt(description.indexOf("J4(") + 3);
            if (length4 != 0 || operator4 == '>') {
                singleStrand4.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Junction".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand4.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            switch (operator4) {
                                case '=': {
                                    return (Integer)value == length4;
                                }
                                case '<': {
                                    return (Integer)value < length4;
                                }
                                case '>': {
                                    return (Integer)value > length4;
                                }
                            }
                        }
                        return false;
                    }
                });
            } else {
                singleStrand4.addPropertyConstraint("Type", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof String) {
                            return "Helix".equals(value);
                        }
                        return false;
                    }
                });
                singleStrand4.addPropertyConstraint("Length", new ValueMatcher(){

                    public boolean matches(Object value) {
                        if (value instanceof Integer) {
                            return (Integer)value >= 2;
                        }
                        return false;
                    }
                });
            }
            helix.addPropertyConstraint("Type", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof String) {
                        return "Helix".equals(value);
                    }
                    return false;
                }
            });
            helix.addPropertyConstraint("Length", new ValueMatcher(){

                public boolean matches(Object value) {
                    if (value instanceof Integer) {
                        return (Integer)value >= 2;
                    }
                    return false;
                }
            });
            singleStrand1.createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            helix.createRelationshipTo(singleStrand2, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            singleStrand3.createRelationshipTo(helix, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            helix.createRelationshipTo(singleStrand4, (RelationshipType)Paradise.CustomRelationships.PHOSPHODIESTER_BOND, Paradise.FIVEPRIME_TO_THREEPRIME_DIRECTION);
            for (Node n : graphDb.getAllNodes()) {
                for (PatternMatch match : new FilteringIterable<PatternMatch>(matcher.match(singleStrand1, n)){

                    protected boolean passes(PatternMatch match) {
                        String[] location1 = ((String)match.getNodeFor(singleStrand1).getProperty("Location")).split(" ");
                        String[] location2 = ((String)match.getNodeFor(singleStrand2).getProperty("Location")).split(" ");
                        try {
                            return location1[0].equals(location2[0]) && new Location(location1[1]).getEnd() + (Integer)match.getNodeFor(helix).getProperty("Length") + 1 == new Location(location2[1]).getStart();
                        }
                        catch (BiologicalSymbolException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                }) {
                    int i;
                    MyPDBHit hit = new MyPDBHit((String)match.getNodeFor(singleStrand1).getProperty("PDBID"));
                    String[] location = ((String)match.getNodeFor(singleStrand1).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand2).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand3).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(singleStrand4).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    location = ((String)match.getNodeFor(helix).getProperty("Location")).split(" ");
                    for (i = 0; i <= location.length - 2; i += 2) {
                        hit.addLocation(location[i], new Location(location[i + 1]));
                    }
                    hits.add(hit);
                }
            }
        } else if (description.matches("J1\\([=><].+\\)J4\\([=><].+\\)X2\\([=><].+\\)X3\\([=><].+\\)")) {
            hits.addAll(MyPDBQuery.searchSingleStrands(description.replace("X2", "I2").replace("X3", "I3")));
            hits.addAll(MyPDBQuery.searchSingleStrands(description.replace("X2", "J2").replace("X3", "J3")));
        } else if (description.matches("I1\\([=><].+\\)I4\\([=><].+\\)X2\\([=><].+\\)X3\\([=><].+\\)")) {
            hits.addAll(MyPDBQuery.searchSingleStrands(description.replace("X2", "I2").replace("X3", "I3")));
            hits.addAll(MyPDBQuery.searchSingleStrands(description.replace("X2", "J2").replace("X3", "J3")));
        } else if (description.matches("X1\\([=><].+\\)X4\\([=><].+\\)J2\\([=><].+\\)J3\\([=><].+\\)")) {
            hits.addAll(MyPDBQuery.searchSingleStrands(description.replace("X1", "I1").replace("X4", "I4")));
            hits.addAll(MyPDBQuery.searchSingleStrands(description.replace("X1", "J1").replace("X4", "J4")));
        } else if (description.matches("X1\\([=><].+\\)X4\\([=><].+\\)I2\\([=><].+\\)I3\\([=><].+\\)")) {
            hits.addAll(MyPDBQuery.searchSingleStrands(description.replace("X1", "I1").replace("X4", "I4")));
            hits.addAll(MyPDBQuery.searchSingleStrands(description.replace("X1", "J1").replace("X4", "J4")));
        }
        tx.success();
        tx.finish();
        graphDb.shutdown();
        return hits;
    }
}

