/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.apache.commons.io.FileUtils;

public class Client {
    private static final String urlBase = "http://paradise-ibmc.u-strasbg.fr/webservices/";

    public static void main(String[] args) throws IOException {
        new Client(args);
    }

    private Client(String[] args) throws IOException {
        StringBuffer parameters = new StringBuffer();
        String ws = null;
        String server = null;
        for (int i = 0; i < args.length - 1; i += 2) {
            String optionName = args[i].trim();
            String optionValue = args[i + 1].trim();
            if ("-ws".equals(optionName)) {
                ws = optionValue;
                continue;
            }
            if (optionName.startsWith("-server")) {
                server = optionValue;
                continue;
            }
            String data = null;
            if ("-".equals(optionValue)) {
                StringBuffer buff = new StringBuffer();
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                String str = in.readLine();
                while (str != null) {
                    buff.append(str + "\n");
                    str = in.readLine();
                }
                in.close();
                data = buff.toString();
            } else if (optionValue.startsWith("file:")) {
                String rightPart = optionValue.split("file:")[1];
                String[] file_names = rightPart.split(",");
                StringBuffer buff = new StringBuffer();
                for (int j = 0; j < file_names.length; ++j) {
                    String file_name = file_names[j];
                    File input = new File(file_name);
                    if (!input.exists()) {
                        System.err.println("\nWARNING: cannot find the input file " + file_name);
                        System.exit(-1);
                    }
                    buff.append(FileUtils.readFileToString((File)input));
                }
                data = buff.toString();
            } else {
                data = optionValue;
            }
            if (parameters.length() != 0) {
                parameters.append("&");
            }
            parameters.append(URLEncoder.encode(optionName.split("-")[1], "UTF-8") + "=" + URLEncoder.encode(data, "UTF-8"));
        }
        if (ws == null) {
            this.printUsage();
            System.exit(-1);
        }
        URL url = null;
        try {
            url = new URL((server == null ? urlBase : server) + ws);
        }
        catch (MalformedURLException e) {
            System.err.println("WARNING: this address is not valid " + (server == null ? urlBase : server) + ws);
            System.exit(-1);
        }
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(parameters.toString());
        System.out.println(parameters.toString());
        wr.flush();
        BufferedReader rd = null;
        try {
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        }
        catch (FileNotFoundException e) {
            System.err.println("\nWARNING: problem to connect " + (server == null ? urlBase : server) + ws);
            System.exit(-1);
        }
        String line = null;
        while ((line = rd.readLine()) != null) {
            System.out.println(line);
        }
        wr.close();
        rd.close();
    }

    private void printUsage() {
        System.out.println("\"Simple Java Client to consume RNA WebServices\"\n");
        System.out.println("Usage: java -jar client.jar -ws webservice_name -webservice_parameter1 value1 -webservice_parameter2 value2 ....\n");
        System.out.println("If the value for a webservice parameter comes from a file, prefix it with \"file:\"\n");
        System.out.println("If the value for a webservice parameter comes from pipe, it has to be equal to \"-\"\n");
        System.out.println("Online Documentation: http://paradise-ibmc.u-strasbg.fr/");
        System.out.println("Contact: f.jossinet@ibmc.u-strasbg.fr");
    }
}

