/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.utils;

public class FGMFormat {
    private static final int ATOM = 0;
    private static final int CHI = 1;
    private int type;
    private int atomNumber;
    private int residueNumber;
    private String atomName;
    private float x;
    private float y;
    private float z;
    private float chi;

    public FGMFormat(String line) {
        if (line.substring(0, 5).replaceAll(" ", "").length() > 0) {
            this.atomNumber = Integer.parseInt(line.substring(0, 5).replaceAll(" ", ""));
            this.residueNumber = Integer.parseInt(line.substring(9, 11).replaceAll(" ", ""));
            this.atomName = line.substring(11, 15).replaceAll(" ", "");
            this.x = Float.parseFloat(line.substring(18, 28).replaceAll(" ", ""));
            this.y = Float.parseFloat(line.substring(28, 38).replaceAll(" ", ""));
            this.z = Float.parseFloat(line.substring(38, 48).replaceAll(" ", ""));
            this.type = 0;
        } else {
            this.residueNumber = Integer.parseInt(line.substring(8, 11).replaceAll(" ", ""));
            this.chi = Float.parseFloat(line.substring(18, 28).replaceAll(" ", ""));
            this.type = 1;
        }
    }

    public String getAtomName() {
        return this.atomName;
    }

    public float getChi() {
        return this.chi;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    private static String atomSerialNumber(int nb) throws Exception {
        String ret = nb + "";
        while (ret.length() < 5) {
            ret = " " + ret;
        }
        if (ret.length() != 5) {
            throw new Exception("inapropriate string length while formatting the text");
        }
        return ret;
    }

    private static String atomName(String name) throws Exception {
        String ret = name.replaceAll(" ", "");
        while (ret.length() < 5) {
            ret = ret + " ";
        }
        if (ret.length() != 5) {
            throw new Exception("inapropriate string length while formatting the text");
        }
        return ret;
    }

    private static String residueSequenceNumber(int num) throws Exception {
        String ret = num + "";
        while (ret.length() < 4) {
            ret = " " + ret;
        }
        if (ret.length() != 4) {
            throw new Exception("inapropriate string length while formatting the text");
        }
        return ret;
    }

    private static String coord(float f) throws Exception {
        String ret = "";
        String fl = f + "";
        if (fl.indexOf("E") != -1) {
            String nb = fl.substring(0, fl.indexOf("E"));
            int mult = Integer.parseInt(fl.substring(fl.indexOf("E") + 1));
            if (mult < -3) {
                ret = "    0.0000";
            } else if (mult > 4) {
                ret = "99999.9999";
                throw new Exception("in FGM.coord(" + f + ") the number exceeds 99999.9999");
            }
        } else {
            int p = fl.indexOf(".");
            if (p == -1) {
                throw new Exception("FGM.coord(" + fl + ") : no dot in this string");
            }
            String head = fl.substring(0, ++p);
            String queue = fl.substring(p);
            if (queue.length() > 5 && Integer.parseInt(queue.charAt(5) + "") > 4) {
                fl = f > 0.0f ? f + 1.0E-4f + "" : f - 1.0E-4f + "";
                head = fl.substring(0, p);
                queue = fl.substring(p);
            }
            while (queue.length() < 5) {
                queue = queue + "0";
            }
            while (head.length() < 5) {
                head = " " + head;
            }
            ret = head + queue.substring(0, 5);
        }
        if (ret.length() != 10) {
            throw new Exception("in FGM.coord(" + f + ") : inapropriate string length while formatting the text");
        }
        return ret;
    }

    private static int atomCode(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == 'C') {
                return 1;
            }
            if (s.charAt(i) == 'M') {
                return 1;
            }
            if (s.charAt(i) == 'N') {
                return 2;
            }
            if (s.charAt(i) == 'O') {
                return 3;
            }
            if (s.charAt(i) != 'P') continue;
            return 4;
        }
        return 0;
    }

    public static String chi(String ch) {
        String chi = ch + "    ";
        return chi.substring(0, 4);
    }

    public static String getAtomString(int nn, int nres, String atomn, double mx, double my, double mz) throws Exception {
        String atomNumber = FGMFormat.atomSerialNumber(nn);
        String residueNumber = FGMFormat.residueSequenceNumber(nres);
        String atomName = FGMFormat.atomName(atomn);
        int atomCode = FGMFormat.atomCode(atomn);
        String x = FGMFormat.coord((float)mx);
        String y = FGMFormat.coord((float)my);
        String z = FGMFormat.coord((float)mz);
        String ret = "" + atomNumber + "  " + residueNumber + atomName + " " + atomCode + x + y + z;
        return ret;
    }

    public static String getChiString(int nres, String ch, double ator) throws Exception {
        String residueNumber = FGMFormat.residueSequenceNumber(nres);
        String chi = FGMFormat.chi(ch);
        String angle = FGMFormat.coord((float)ator);
        String ret = "       " + residueNumber + chi + "   " + angle;
        return ret;
    }
}

