/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.utils;

import fr.unistra.ibmc.paradise.core.utils.OutputMode;
import fr.unistra.ibmc.paradise.core.utils.Printing;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class FileHandler {
    public static final int READING = 0;
    public static final int WRITING = 1;
    public static final int R_APPEND = 2;
    public static final int W_APPEND = 3;
    public String name = "";
    public int mode = 0;
    private BufferedReader in;
    private PrintWriter out;

    public static void appendTo(String filenameA, String filenameB) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filenameA));
            PrintWriter out = new PrintWriter(new FileWriter(filenameB, true));
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
            out.close();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] readFile(String filename) {
        byte[] ret = null;
        try {
            int read;
            FileInputStream in = new FileInputStream(filename);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] temp = new byte[1024];
            while ((read = in.read(temp)) > 0) {
                buffer.write(temp, 0, read);
            }
            in.close();
            ret = buffer.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String readFileToString(String filename) {
        return new String(FileHandler.readFile(filename));
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public BufferedReader getIn() {
        return this.in;
    }

    public FileHandler(String s, int mod) {
        try {
            if (mod == 0) {
                this.name = s;
                this.mode = mod;
                this.in = new BufferedReader(new FileReader(s));
            }
            if (mod == 1) {
                this.name = s;
                this.mode = mod;
                this.out = new PrintWriter(new FileWriter(s));
            }
            if (mod == 3) {
                this.name = s;
                this.mode = mod;
                this.out = new PrintWriter(new FileWriter(s, true));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String readLine() {
        try {
            String s = this.in.readLine();
            Throwable toto = new Throwable();
            StackTraceElement t = toto.getStackTrace()[1];
            String cn = t.getClassName();
            if (cn.lastIndexOf(".") > -1) {
                cn = cn.substring(cn.lastIndexOf(".") + 1);
            }
            if (Printing.getReadMode() == OutputMode.onOut) {
                System.out.println("Read : " + cn + "." + t.getMethodName() + "() line :" + t.getLineNumber() + " | in " + this.name + " | " + s);
            }
            if (Printing.getReadMode() == OutputMode.onErr) {
                System.err.println("Read : " + cn + "." + t.getMethodName() + "() line :" + t.getLineNumber() + " | in " + this.name + " | " + s);
            }
            return s;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void println() {
        this.out.println();
    }

    public void println(String s) {
        this.out.println(s);
        Throwable toto = new Throwable();
        StackTraceElement t = toto.getStackTrace()[1];
        String cn = t.getClassName();
        if (cn.lastIndexOf(".") > -1) {
            cn = cn.substring(cn.lastIndexOf(".") + 1);
        }
        if (Printing.getWriteMode() == OutputMode.onOut) {
            System.out.println("Write : " + cn + "." + t.getMethodName() + "() line :" + t.getLineNumber() + " | in " + this.name + " | " + s);
        }
        if (Printing.getWriteMode() == OutputMode.onErr) {
            System.err.println("Write : " + cn + "." + t.getMethodName() + "() line :" + t.getLineNumber() + " | in " + this.name + " | " + s);
        }
    }

    public void close() {
        try {
            if (this.mode == 0) {
                this.in.close();
            }
            if (this.mode == 1) {
                this.out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void rewind() {
        try {
            if (this.mode == 0) {
                this.in.close();
                this.in = new BufferedReader(new FileReader(this.name));
            }
            if (this.mode == 1) {
                this.out.close();
                this.out = new PrintWriter(new FileWriter(this.name));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void switchToReadMode() {
        try {
            if (this.mode == 0) {
                this.in.close();
            }
            if (this.mode == 1) {
                this.out.close();
            }
            this.mode = 0;
            this.in = new BufferedReader(new FileReader(this.name));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void switchToWriteMode() {
        try {
            if (this.mode == 0) {
                this.in.close();
            }
            if (this.mode == 1) {
                this.out.close();
            }
            this.mode = 1;
            this.out = new PrintWriter(new FileWriter(this.name));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

