/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.utils;

import fr.unistra.ibmc.paradise.core.utils.FileFormattingException;
import fr.unistra.ibmc.paradise.core.utils.HD;
import fr.unistra.ibmc.paradise.core.utils.Parser;
import fr.unistra.ibmc.paradise.core.utils.ParsingException;
import fr.unistra.ibmc.paradise.core.utils.SortedIntArrayList;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class PDB {
    String type;
    int atomNumber;
    String atomName;
    int residueNumber;
    String residueName;
    String chain;
    double x;
    double y;
    double z;
    double b;
    double q;
    char altLoc = (char)32;

    public String getType() {
        return this.type;
    }

    public static boolean isProtein(String r) {
        String[] prot = new String[]{"ALA", "VAL", "PHE", "PRO", "MET", "ILE", "LEU", "ASP", "GLU", "LYS", "ARG", "SER", "THR", "TYR", "HIS", "CYS", "ASN", "GLN", "TRP", "GLY", "MSE"};
        for (int i = 0; i < prot.length; ++i) {
            if (!prot[i].equals(r)) continue;
            return true;
        }
        return false;
    }

    public static String getResidue(String line) {
        return line.substring(17, 20).replaceAll(" ", "");
    }

    public static void renumberPDB(String filename) throws ParsingException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            PrintWriter out = new PrintWriter(new FileWriter(filename.substring(0, filename.lastIndexOf(".pdb")) + "numbered.pdb"));
            char chain = 'A';
            int readResidue = -1;
            int residue = 0;
            int atom = 1;
            String rname = "";
            while ((line = in.readLine()) != null) {
                if (line.substring(0, 4).equals("ATOM")) {
                    PDB pdb = new PDB(line);
                    if (readResidue != pdb.residueNumber) {
                        readResidue = pdb.residueNumber;
                        ++residue;
                    }
                    rname = pdb.residueName;
                    out.println(PDB.getAtomString(atom, pdb.atomName, rname, chain, residue, (float)pdb.x, (float)pdb.y, (float)pdb.z));
                }
                if (line.substring(0, 3).equals("TER")) {
                    out.println(PDB.getTerString(atom, rname, chain, residue));
                    chain = (char)(chain + '\u0001');
                }
                ++atom;
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean belong(SortedIntArrayList list, int x) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.getInt(i) > x) {
                return false;
            }
            if (list.getInt(i) != x) continue;
            return true;
        }
        return false;
    }

    public static void ter(String filein, String fileout, SortedIntArrayList list) throws ParsingException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filein));
            PrintWriter out = new PrintWriter(new FileWriter(fileout));
            char chain = 'A';
            int atom = 1;
            int last = -1;
            int cur = 0;
            String resname = "";
            int resnumber = 0;
            while ((line = in.readLine()) != null) {
                PDB pdb = new PDB(line);
                last = cur;
                cur = pdb.getResidueNumber();
                if (cur > last && PDB.belong(list, last)) {
                    out.println(PDB.getTerString(atom, resname, chain, resnumber));
                    ++atom;
                    chain = (char)(chain + '\u0001');
                }
                resname = pdb.getResidueName();
                resnumber = pdb.getResidueNumber();
                if (!line.substring(0, 4).equals("ATOM")) continue;
                out.println(PDB.getAtomString(atom, pdb.getAtomName(), pdb.getResidueName(), chain, pdb.getResidueNumber(), (float)pdb.getX(), (float)pdb.getY(), (float)pdb.getZ()));
                ++atom;
            }
            out.println(PDB.getTerString(atom, resname, chain, resnumber));
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sortPDBFile(String filenameA, String filenameB, String tmpDir) throws ParsingException {
        SortedIntArrayList list = new SortedIntArrayList();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filenameA));
            PrintWriter out = null;
            while ((line = in.readLine()) != null) {
                if (out == null) {
                    int index = new PDB(line).getResidueNumber();
                    list.add(index);
                    out = new PrintWriter(new FileWriter(tmpDir + index + ".pdb"));
                }
                out.println(line);
                if (line.charAt(0) == 'A') continue;
                out.close();
                out = null;
            }
            in.close();
            int atom = 1;
            out = new PrintWriter(new FileWriter(filenameB));
            char chain = 'A';
            for (int i = 0; i < list.size(); ++i) {
                in = new BufferedReader(new FileReader(tmpDir + list.getInt(i) + ".pdb"));
                while ((line = in.readLine()) != null) {
                    PDB p = new PDB(line);
                    if (p.getType().equals("ATOM  ")) {
                        out.println(PDB.getAtomString(atom, p.getAtomName(), p.getResidueName(), chain, p.getResidueNumber(), (float)p.getX(), (float)p.getY(), (float)p.getZ()));
                    } else {
                        out.println(PDB.getTerString(atom, p.getResidueName(), chain, p.getResidueNumber()));
                    }
                    ++atom;
                }
                in.close();
                chain = (char)(chain + 1);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void removeProteines(String filename) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            PrintWriter out = new PrintWriter(new FileWriter(filename.substring(0, filename.lastIndexOf(".pdb")) + "noprot.pdb"));
            while ((line = in.readLine()) != null) {
                String res;
                String h;
                if (line.length() <= 4 || !(h = line.substring(0, 3)).equals("ATO") && !h.equals("TER") || PDB.isProtein(res = PDB.getResidue(line))) continue;
                out.println(line);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getAtomCode() {
        if (this.atomName.indexOf("H") != -1) {
            return 0;
        }
        if (this.atomName.indexOf("O") != -1) {
            return 3;
        }
        if (this.atomName.indexOf("N") != -1) {
            return 2;
        }
        if (this.atomName.indexOf("C") != -1 || this.atomName.indexOf("M") != -1) {
            return 1;
        }
        if (this.atomName.indexOf("P") != -1) {
            return 4;
        }
        if (this.atomName.indexOf("S") != -1) {
            return 5;
        }
        return 0;
    }

    public int getAtomNumber() {
        return this.atomNumber;
    }

    public String getAtomName() {
        return this.atomName;
    }

    public int getResidueNumber() {
        return this.residueNumber;
    }

    public String getResidueName() {
        return this.residueName;
    }

    public String getChain() {
        return this.chain;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getB() {
        return this.b;
    }

    public double getQ() {
        return this.q;
    }

    public char getAltLoc() {
        return this.altLoc;
    }

    public PDB() {
    }

    public PDB(String line) throws ParsingException {
        this.type = line.substring(0, 6);
        if (this.type.equals("ATOM  ")) {
            this.atomNumber = Parser.parseInt(line.substring(6, 11).trim());
            this.atomName = line.substring(12, 16).trim();
            this.residueName = line.substring(17, 21).trim();
            this.chain = line.substring(21, 22).trim();
            this.residueNumber = Parser.parseInt(line.substring(22, 27).trim());
            this.x = Parser.parseDouble(line.substring(30, 38).trim());
            this.y = Parser.parseDouble(line.substring(38, 46).trim());
            this.z = Parser.parseDouble(line.substring(46, 54).trim());
            this.altLoc = line.charAt(16);
            if (line.length() > 60) {
                String bS = line.substring(54, 60).replaceAll(" ", "");
                this.b = bS.equals("") ? 0.0 : Parser.parseDouble(bS);
                if (line.length() > 66) {
                    String qS = line.substring(60, 66).replaceAll(" ", "");
                    this.q = qS.equals("") ? 0.0 : Parser.parseDouble(qS);
                }
            }
        }
        if (this.type.equals("TER   ")) {
            this.atomNumber = Parser.parseInt(line.substring(6, 11).trim());
            this.residueName = line.substring(17, 20).replaceAll(" ", "");
            this.chain = line.substring(21, 22).trim();
            this.residueNumber = Parser.parseInt(line.substring(22, 27).trim());
        }
    }

    public static String getType(String line) {
        return line.substring(0, 6);
    }

    public static String getAtomName(String line) {
        return line.substring(12, 16).replaceAll(" ", "");
    }

    static String atomSerialNumber(int nb) {
        String ret = nb + "";
        try {
            while (ret.length() < 5) {
                ret = " " + ret;
            }
            if (ret.length() != 5) {
                throw new FileFormattingException("inapropriate string length while formatting the text : " + nb);
            }
        }
        catch (FileFormattingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    static String atomName(String name) {
        String ret = " " + name.replace('\'', '*').trim();
        char first = ret.charAt(1);
        if (first < '0' || first > '9') {
            ret = " " + ret;
        }
        try {
            while (ret.length() < 5) {
                ret = ret + " ";
            }
            if (ret.length() != 5) {
                throw new FileFormattingException("inapropriate string length while formatting the text : " + name);
            }
        }
        catch (FileFormattingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    static String residueName(String type) {
        String ret = type;
        try {
            while (ret.length() < 3) {
                ret = " " + ret;
            }
            if (ret.length() != 3) {
                throw new FileFormattingException("inapropriate string length while formatting the text : " + type);
            }
        }
        catch (FileFormattingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    static String residueSequenceNumber(int num) {
        String ret = num + "";
        try {
            while (ret.length() < 4) {
                ret = " " + ret;
            }
            if (ret.length() != 4) {
                throw new FileFormattingException("inapropriate string length while formatting the text : " + num);
            }
        }
        catch (FileFormattingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    static String coord(float f) throws ParsingException {
        String ret = "";
        try {
            String fl = f + "";
            if (fl.indexOf("E") != -1) {
                String nb = fl.substring(0, fl.indexOf("E"));
                int mult = Parser.parseInt(fl.substring(fl.indexOf("E") + 1));
                if (mult < -3) {
                    ret = "   0.000";
                } else if (mult > 4) {
                    ret = "9999.999";
                    throw new FileFormattingException("in PDB.coord(" + f + ") the number exceeds 9999.999 : " + f);
                }
            } else {
                int p = fl.indexOf(".");
                String head = fl.substring(0, p);
                String queue = fl.substring(p);
                if (queue.length() > 4 && Parser.parseInt(queue.charAt(4) + "") > 4) {
                    fl = f > 0.0f ? f + 0.001f + "" : f - 0.001f + "";
                    head = fl.substring(0, p);
                    queue = fl.substring(p);
                }
                while (queue.length() < 4) {
                    queue = queue + "0";
                }
                while (head.length() < 4) {
                    head = " " + head;
                }
                ret = head + queue.substring(0, 4);
            }
            if (ret.length() != 8) {
                throw new FileFormattingException("in PDB.coord(" + f + ") : inapropriate string length while formatting the text ");
            }
        }
        catch (FileFormattingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getAtomString(int nb, String name, String type, char chId, int num, double x, double y, double z) throws ParsingException {
        return PDB.getAtomString(nb, name, type, chId, num, (float)x, (float)y, (float)z);
    }

    public static String getAtomString(int nb, String name, String type, char chId, int num, float x, float y, float z) throws ParsingException {
        String ret = "";
        String o2 = "      ";
        String o3 = "    ";
        char o4 = ' ';
        String o5 = "    ";
        char o6 = ' ';
        String o7 = "    ";
        String o8 = "    ";
        String o9 = "        ";
        String o10 = "        ";
        String o11 = "        ";
        String o12 = "     ";
        o2 = PDB.atomSerialNumber(nb);
        o3 = PDB.atomName(name);
        o5 = PDB.residueName(type);
        o6 = chId;
        o7 = PDB.residueSequenceNumber(num);
        o9 = PDB.coord(x);
        o10 = PDB.coord(y);
        o11 = PDB.coord(z);
        ret = "ATOM  " + o2 + o3 + o4 + o5 + " " + o6 + o7 + o8 + o9 + o10 + o11;
        return ret;
    }

    public static String getTerString(int nb, String type, char chId, int num) {
        String ret = "";
        String o2 = "      ";
        String o5 = "    ";
        char o6 = ' ';
        String o7 = "    ";
        String o8 = "    ";
        o2 = PDB.atomSerialNumber(nb);
        o5 = PDB.residueName(type);
        o6 = chId;
        o7 = PDB.residueSequenceNumber(num);
        ret = "TER   " + o2 + "      " + o5 + " " + o6 + o7 + o8;
        return ret;
    }

    public static void printRnaml3D(String filename) throws ParsingException {
        int res = -1;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 3 || !line.substring(0, 4).equals("ATOM")) continue;
                PDB pdb = new PDB(line);
                if (pdb.getResidueNumber() != res) {
                    pdb.printRNAML3DResidue();
                }
                pdb.printRNAML3DAtom();
                res = pdb.getResidueNumber();
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printRNAML3DResidue() {
        System.out.println("\t\t\t</base>\n\t\t\t<base>\n\t\t\t\t<position>" + this.getResidueNumber() + "</position>\n" + "\t\t\t\t<base-type>" + this.getResidueName() + "</base-type>");
    }

    public void printRNAML3DAtom() throws ParsingException {
        System.out.println("\t\t\t\t<atom serial=\"" + this.getAtomNumber() + "\">\n" + "\t\t\t\t\t<atom-type>" + this.atomName + "</atom-type>\n" + "\t\t\t\t\t<coordinates>" + PDB.coord((float)this.x) + " " + PDB.coord((float)this.y) + " " + PDB.coord((float)this.z) + "</coordinates>\n" + "\t\t\t\t</atom>");
    }

    public static void printPDBFromHD(String PDBFile, String HDFile) throws ParsingException {
        int lastA = 0;
        int lastR = 0;
        char lastN = 'A';
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(HDFile));
            PrintWriter out = new PrintWriter(new FileWriter(PDBFile));
            while ((line = in.readLine()) != null) {
                HD hd = new HD(line);
                lastA = hd.atomNumber;
                lastR = hd.residueNumber;
                lastN = hd.residueName;
                out.println(PDB.getAtomString(hd.atomNumber, hd.atomName, hd.residueName + "", 'A', hd.residueNumber, hd.x, hd.y, hd.z));
            }
            out.println(PDB.getTerString(lastA + 1, lastN + "", 'A', lastR));
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

