/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.utils;

import fr.unistra.ibmc.paradise.tools.Paradise;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ParadiseConfig {
    private static final String defaultWebSevicesAddress = "http://paradise-ibmc.u-strasbg.fr/webservices/";
    private static Document document;

    private static void loadConfig() {
        File configFile = new File(Paradise.getUserDir(), "config.xml");
        if (!configFile.exists()) {
            Element root = new Element("paradise-config");
            document = new Document(root);
            Element e = new Element("webservices-address");
            e.addContent(defaultWebSevicesAddress);
            document.getRootElement().addContent((Content)e);
            ParadiseConfig.save();
        } else {
            SAXBuilder builder = new SAXBuilder();
            try {
                document = builder.build(configFile);
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getCurrentWebServicesAddress() {
        Element e;
        if (document == null) {
            ParadiseConfig.loadConfig();
        }
        if ((e = document.getRootElement().getChild("webservices-address")) == null) {
            e = new Element("webservices-address");
            e.addContent(defaultWebSevicesAddress);
            document.getRootElement().addContent((Content)e);
        }
        return e.getTextTrim();
    }

    public static void save() {
        try {
            if (document != null) {
                XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
                FileWriter writer = new FileWriter(new File(Paradise.getUserDir(), "config.xml"));
                outputter.output(document, (Writer)writer);
                writer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean useWebServices() {
        if (document == null) {
            ParadiseConfig.loadConfig();
        }
        return document.getRootElement().getChild("use-local-algorithms") == null;
    }
}

