/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.utils;

import fr.unistra.ibmc.paradise.core.utils.Printing;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SystemTools {
    public static void mv(String sourceName, String destName) {
        File d = new File(destName);
        if (!d.delete()) {
            // empty if block
        }
        System.gc();
        SystemTools.cp(sourceName, destName);
        File s = new File(sourceName);
        if (!s.delete()) {
            Printing.warning("Could not delete file : " + s.getName());
        }
    }

    public static boolean isFileEmpty(String filename) {
        boolean ret = true;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ret = in.readLine() == null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static String createTempDirectory(String name) {
        try {
            File tmp = File.createTempFile("paradise-" + name + "-" + SystemTools.epoc(), "");
            tmp.delete();
            tmp.mkdir();
            tmp.deleteOnExit();
            return tmp.getCanonicalPath() + System.getProperty("file.separator");
        }
        catch (IOException e) {
            System.err.println("Can't create temporary directory");
            return "." + System.getProperty("file.separator");
        }
    }

    public static void renameTo(String sourceName, String destName) {
        File d = new File(destName);
        if (!d.delete()) {
            // empty if block
        }
        boolean success = false;
        File source = new File(sourceName);
        File dest = new File(destName);
        for (int i = 0; i < 20 && !(success = source.renameTo(dest)); ++i) {
            System.gc();
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!success) {
            Printing.warning("The file " + sourceName + " could not been renamed to " + destName);
            System.exit(1);
        }
    }

    public static void cp(String sourceName, String destName) {
        try {
            int b;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(sourceName));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destName));
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void cp(BufferedReader in, PrintWriter out, long length) {
        char[] buf = new char[(int)length];
        int read = 0;
        try {
            read = in.read(buf, 0, (int)length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (read != (int)length) {
            Printing.warning("READ " + read + " / " + length + " bytes");
        }
        out.print(buf);
        out.flush();
    }

    public static void rm(String filename) {
        File tmp = new File(filename);
        tmp.delete();
    }

    public static String unifySpaces(String s) {
        String ret = s.replace('\n', ' ');
        ret = ret.replace('\t', ' ');
        ret = ret.replace('\r', ' ');
        return ret.replace('\f', ' ');
    }

    public static long epoc() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public static int dailyEpoc() {
        return (int)(Calendar.getInstance().getTimeInMillis() % 86400000L);
    }

    public static void deleteDirectory(File dir) {
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                SystemTools.deleteDirectory(child);
                continue;
            }
            child.delete();
        }
        dir.delete();
    }

    public static int countLines(String filename) {
        int c = 0;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while (in.readLine() != null) {
                ++c;
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return c;
    }

    public static void emptyDirectory(File dir) {
        File[] children;
        for (File aChildren : children = dir.listFiles()) {
            if (aChildren.isDirectory()) {
                SystemTools.deleteDirectory(aChildren);
                continue;
            }
            aChildren.delete();
        }
    }

    public static String getIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "0.0.0.0";
        }
    }

    public static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        Date now = new Date();
        return df.format(now);
    }

    public static String getTime() {
        SimpleDateFormat df = new SimpleDateFormat("hh:mmm:ss");
        Date now = new Date();
        return df.format(now);
    }
}

