/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ebi.vrnafold;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.io.CTFileIO;
import fr.unistra.ibmc.paradise.core.utils.IOUtils;
import fr.unistra.ibmc.paradise.services.analysis.ebi.vrnafold.SequenceInput;
import fr.unistra.ibmc.paradise.services.analysis.ebi.vrnafold.Vrnafold;
import fr.unistra.ibmc.paradise.services.analysis.ebi.vrnafold.VrnafoldService;
import fr.unistra.ibmc.paradise.tools.component.DefaultProgressMonitor;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.xml.ws.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBIVrnafoldAnalysis
extends AbstractAnalysis {
    protected EBIVrnafoldAnalysis(ParadiseWorkingSession ws) {
        super("RNAFold (EBI Server)", ws);
        this.addCategory("2D prediction");
    }

    @Override
    public void run(List<Molecule> molecules, Parameters parameters) throws AnalysisException, NoSolutionException {
        try {
            VrnafoldService service = new VrnafoldService();
            Vrnafold vrnafold = service.getVrnafoldPort();
            Holder outfile = new Holder();
            Holder report = new Holder();
            Holder detailedStatus = new Holder();
            SequenceInput seqInput = new SequenceInput();
            seqInput.setDirectData(">" + molecules.get(0).getName() + "\n" + molecules.get(0).printSequence());
            this.status = "Query to the webservice";
            vrnafold.runAndWaitFor(seqInput, "", "", "", "", Float.valueOf(37.0f), false, true, true, true, true, "", true, "0", Float.valueOf(1.07f), "1", (Holder<String>)report, (Holder<Long>)detailedStatus, (Holder<String>)outfile, (Holder<String>)new Holder(), (Holder<String>)new Holder(), (Holder<String>)new Holder());
            String[] tokens = ((String)outfile.value).split(" ")[0].split("\\n");
            File vrnafoldOutput = IOUtils.createTemporaryFile("vrnafold");
            CTFileIO.writeCTFile(vrnafoldOutput, tokens[0].trim(), tokens[1].trim());
            CTFileIO parser = new CTFileIO(this.workingSession);
            parser.parseFile(vrnafoldOutput, new DefaultProgressMonitor());
            molecules.get(0).removeAllSelectedFeatures();
            if (parser.getMolecules().size() != 0) {
                SecondaryStructure ss = (SecondaryStructure)parser.getMolecules().get(0).getAnnotations(SecondaryStructure.class).get(0).getFeature();
                SecondaryStructure copySS = ss.getFactory().copySecondaryStructure(Arrays.asList(molecules.get(0)), ss, false);
                copySS.setParadiseID(new ParadiseID());
                copySS.setName("Secondary Structure");
                copySS.setSource(Source.getAnalysisAsSource(this.description));
                molecules.get(0).addSelectedFeature(copySS);
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

