/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ebi.vrnaplot;

import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.Residue2D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.services.analysis.ebi.vrnaplot.Vrnaplot;
import fr.unistra.ibmc.paradise.services.analysis.ebi.vrnaplot.VrnaplotService;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import javax.xml.ws.Holder;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBIVrnaplotAnalysis
extends AbstractAnalysis {
    protected EBIVrnaplotAnalysis(ParadiseWorkingSession ws) {
        super("RNAPlot (EBI Server)", ws);
        this.addCategory("2D drawing");
    }

    @Override
    public void run(List<Molecule> molecules, Parameters parameters) throws AnalysisException, NoSolutionException {
        try {
            SecondaryStructureDisplay display = null;
            SecondaryStructure ss = null;
            for (Molecule m : molecules) {
                if (ss == null) {
                    ss = m.getSelectedFeatures(SecondaryStructure.class).get(0);
                }
                if (display == null) {
                    display = ss.getFactory().createSecondaryStructureDisplay(ss, m, new Location(1, m.getLength()));
                }
                VrnaplotService service = new VrnaplotService();
                Vrnaplot vrnaplot = service.getVrnaplotPort();
                Holder outfile = new Holder();
                Holder report = new Holder();
                Holder detailedStatus = new Holder();
                this.status = "Query to the webservice";
                vrnaplot.runAndWaitFor(">" + m.getName() + "\n" + m.printSequence() + "\n" + ss.printAsBracketNotation(m, false, false) + " 0.0)", "", "naview", "svg", "", "", (Holder<String>)report, (Holder<Long>)detailedStatus, (Holder<String>)outfile, (Holder<String>)new Holder());
                String svgOutput = (String)outfile.value;
                this.status = "Parsing of VRNAplot output";
                Document doc = new SAXBuilder().build((Reader)new StringReader(svgOutput));
                Iterator it = doc.getRootElement().getDescendants((Filter)new ElementFilter("text"));
                int pos = 0;
                float minX = 0.0f;
                float minY = 0.0f;
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    ++pos;
                    Residue2D r = ss.getFactory().createResidue2D(display, Float.parseFloat(e.getAttributeValue("x")), Float.parseFloat(e.getAttributeValue("y")), m, pos);
                    if (r.getX() < minX) {
                        minX = r.getX();
                    }
                    if (!(r.getY() < minY)) continue;
                    minY = r.getY();
                }
                for (Residue2D r : display.getResidues2D()) {
                    r.setX(r.getX() + Math.abs(minX));
                    r.setY(r.getY() + Math.abs(minY));
                }
                m.removeAllSelectedFeatures();
                m.addSelectedFeature(display);
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

