/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ibmc.fragment;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.RiboNucleotide3D;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.core.utils.IOUtils;
import fr.unistra.ibmc.paradise.tools.component.DefaultProgressMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBMCFragmentAnalysis
extends AbstractAnalysis {
    public static final String REFERENCE_RESIDUES = "reference residues";
    public static final String TARGET_SEQUENCE = "target sequence";

    public IBMCFragmentAnalysis(ParadiseWorkingSession ws) {
        super("Fragment (PARADISE Server)", ws);
        this.addCategory("Apply 3D folds");
    }

    @Override
    public void run(List<Molecule> molecules, Parameters parameters) throws AnalysisException, NoSolutionException {
        try {
            if (Thread.interrupted()) {
                throw new AnalysisException("The analysis has been cancelled");
            }
            ArrayList<Residue3D> residues = new ArrayList<Residue3D>();
            boolean phosphateAdded = false;
            block3: for (Parameter p : parameters.getParameters(REFERENCE_RESIDUES).getParameters()) {
                Residue3D r = (Residue3D)p.getFeature();
                residues.add(r);
                if (residues.size() != 1) continue;
                for (String phosphate : RiboNucleotide3D.P) {
                    if (r.getAtom(phosphate).hasCoordinatesFilled()) continue block3;
                }
                phosphateAdded = true;
                r.setAtomCoordinates("P", 0.0f, 0.0f, 0.0f);
                r.setAtomCoordinates("O1P", 0.0f, 0.0f, 0.0f);
                r.setAtomCoordinates("O2P", 0.0f, 0.0f, 0.0f);
                if (r.getAtom("O5'").hasCoordinatesFilled()) continue;
                r.setAtomCoordinates("O5'", 0.0f, 0.0f, 0.0f);
            }
            String targetSequence = parameters.getParameters(TARGET_SEQUENCE).getParameter(0).getValue();
            File f = null;
            f = IOUtils.createTemporaryFile("fragment");
            PDBFileIO.writeSimplePDB(residues, f);
            Hashtable<String, String> data = new Hashtable<String, String>();
            data.put("data", FileUtils.readFileToString((File)f));
            data.put("sequence", targetSequence);
            String pdb = this.postData("infer3d", data);
            File result = IOUtils.createTemporaryFile("fragment");
            FileUtils.writeStringToFile((File)result, (String)pdb);
            PDBFileIO parser = new PDBFileIO(this.workingSession);
            parser.parseFile(result, new DefaultProgressMonitor());
            for (Molecule m : molecules) {
                m.removeAllSelectedFeatures();
            }
            TertiaryStructure ts = parser.getTertiaryStructures().get(0);
            if (phosphateAdded) {
                for (Residue3D r : ts.getResidues3D()) {
                    if (r.getFullLocation(r.getMolecules().iterator().next()).getStart() != 1) continue;
                    r.getAtom("P").eraseCoordinates();
                    r.getAtom("O1P").eraseCoordinates();
                    r.getAtom("O2P").eraseCoordinates();
                    if (r.getAtom("O5'").getX() != 0.0f || r.getAtom("O5'").getY() != 0.0f || r.getAtom("O5'").getZ() != 0.0f) continue;
                    r.getAtom("O5'").eraseCoordinates();
                }
            }
            molecules.get(0).addSelectedFeature(ts);
        }
        catch (AnalysisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

