/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ibmc.mcannotate;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.Adenine3D;
import fr.unistra.ibmc.paradise.core.features.Cytosine3D;
import fr.unistra.ibmc.paradise.core.features.Guanine3D;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.Uracil3D;
import fr.unistra.ibmc.paradise.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.core.io.RNAMLFileIO;
import fr.unistra.ibmc.paradise.core.utils.IOUtils;
import fr.unistra.ibmc.paradise.tools.component.DefaultProgressMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBMCMCannotateAnalysis
extends AbstractAnalysis {
    public IBMCMCannotateAnalysis(ParadiseWorkingSession ws) {
        super("MCAnnotate (PARADISE Server)", ws);
        this.addCategory("3D annotation");
    }

    @Override
    public void run(List<Molecule> molecules, Parameters parameters) throws AnalysisException, NoSolutionException {
        long start = System.currentTimeMillis();
        try {
            ArrayList<Residue3D> residues = new ArrayList<Residue3D>();
            for (Molecule molecule : molecules) {
                if (Thread.interrupted()) {
                    throw new AnalysisException("The analysis has been cancelled");
                }
                for (ParadiseFeature r : molecule.getSelectedFeatures()) {
                    residues.add((Residue3D)r);
                }
            }
            ArrayList<Residue3D.Atom> atomsFilled = new ArrayList<Residue3D.Atom>();
            for (Residue3D r : residues) {
                if (Thread.interrupted()) {
                    throw new AnalysisException("The analysis has been cancelled");
                }
                List<Residue3D.Atom> atoms = r.getAtoms();
                for (Residue3D.Atom a : atoms) {
                    if ((!Adenine3D.class.isInstance(r) || !a.getName().equals("N9") && !a.getName().equals("C8") && !a.getName().equals("N7") && !a.getName().equals("C5") && !a.getName().equals("C6") && !a.getName().equals("N6") && !a.getName().equals("N1") && !a.getName().equals("C2") && !a.getName().equals("N3") && !a.getName().equals("C4")) && (!Guanine3D.class.isInstance(r) || !a.getName().equals("N9") && !a.getName().equals("C8") && !a.getName().equals("N7") && !a.getName().equals("C5") && !a.getName().equals("C6") && !a.getName().equals("O6") && !a.getName().equals("N1") && !a.getName().equals("C2") && !a.getName().equals("N2") && !a.getName().equals("N3") && !a.getName().equals("C4")) && (!Uracil3D.class.isInstance(r) || !a.getName().equals("N1") && !a.getName().equals("C2") && !a.getName().equals("O2") && !a.getName().equals("N3") && !a.getName().equals("C4") && !a.getName().equals("04") && !a.getName().equals("C5") && !a.getName().equals("C6")) && (!Cytosine3D.class.isInstance(r) || !a.getName().equals("N1") && !a.getName().equals("C2") && !a.getName().equals("O2") && !a.getName().equals("N3") && !a.getName().equals("C4") && !a.getName().equals("N4") && !a.getName().equals("C5") && !a.getName().equals("C6")) || a.hasCoordinatesFilled()) continue;
                    a.setCoordinates(0.0f, 0.0f, 0.0f);
                    atomsFilled.add(a);
                }
            }
            this.status = "Generation of the PDB file";
            File f = IOUtils.createTemporaryFile("mcannotate");
            PDBFileIO.writePDBFile(residues, false, f);
            for (Residue3D.Atom a : atomsFilled) {
                a.eraseCoordinates();
            }
            this.status = "PDB generated in " + (System.currentTimeMillis() - start) / 1000L + "s";
            RNAMLFileIO rnamlParser = new RNAMLFileIO(this.workingSession);
            start = System.currentTimeMillis();
            this.status = "MCAnnotate is running";
            Hashtable<String, String> data = new Hashtable<String, String>();
            data.put("data", FileUtils.readFileToString((File)f));
            data.put("tool", "mcannotate");
            String pdbAnnotation = this.postData("annotate3d", data);
            System.out.println(pdbAnnotation);
            this.status = "MCAnnotate done in " + (System.currentTimeMillis() - start) / 1000L + "s";
            if (pdbAnnotation == null || pdbAnnotation.length() == 0) {
                throw new NoSolutionException("No base-pairs found, no 2D structure plotted (may be a single strand??)");
            }
            start = System.currentTimeMillis();
            this.status = "Parsing of MCAnnotate output";
            File pdbAnnotationFile = IOUtils.createTemporaryFile("mcannotate");
            FileUtils.writeStringToFile((File)pdbAnnotationFile, (String)pdbAnnotation);
            rnamlParser.parseFile(pdbAnnotationFile, new DefaultProgressMonitor());
            this.status = "Parsing done in " + (System.currentTimeMillis() - start) / 1000L + "s";
            SecondaryStructure ss = rnamlParser.getSecondaryStructures().get(0);
            ss.setParadiseID(new ParadiseID());
            ss.setName("Secondary Structure");
            ss.setSource(Source.getAnalysisAsSource(this.description));
            ArrayList<Molecule> returnedMolecules = new ArrayList<Molecule>(ss.getMolecules());
            for (int i = 0; i < returnedMolecules.size(); ++i) {
                Molecule returnedMolecule = (Molecule)returnedMolecules.get(i);
                Molecule localMolecule = molecules.get(i);
                if (!returnedMolecule.printSequence().equals(localMolecule.printSequence())) continue;
                returnedMolecule.getParadiseID().setValue(localMolecule.getParadiseID().getValue());
            }
            ss.getFactory().copySecondaryStructure(molecules, ss, false);
            for (Molecule m : molecules) {
                if (Thread.interrupted()) {
                    throw new AnalysisException("The analysis has been cancelled");
                }
                m.removeAllSelectedFeatures();
                m.addSelectedFeature(ss);
            }
        }
        catch (AnalysisException e) {
            throw e;
        }
        catch (NoSolutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

