/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ibmc.rnaplot;

import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.Residue2D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBMCRnaplotAnalysis
extends AbstractAnalysis {
    protected IBMCRnaplotAnalysis(ParadiseWorkingSession ws) {
        super("RNAPlot (PARADISE Server)", ws);
        this.addCategory("2D drawing");
    }

    @Override
    public void run(List<Molecule> molecules, Parameters parameters) throws AnalysisException, NoSolutionException {
        try {
            SecondaryStructureDisplay display = null;
            SecondaryStructure ss = null;
            for (Molecule m : molecules) {
                if (ss == null) {
                    ss = m.getSelectedFeatures(SecondaryStructure.class).get(0);
                }
                if (display == null) {
                    display = ss.getFactory().createSecondaryStructureDisplay(ss, m, new Location(1, m.getLength()));
                }
                this.status = "Query to the webservice";
                Hashtable<String, String> data = new Hashtable<String, String>();
                data.put("data", ">" + m.getName() + "\n" + m.printSequence() + "\n" + ss.printAsBracketNotation(m, false, false));
                data.put("input", "vienna");
                data.put("output", "bpseq");
                String bpSeqOutput = this.postData("convert", data);
                if (bpSeqOutput == null || bpSeqOutput.length() == 0) {
                    throw new NoSolutionException("Problem to convert your data to the BPSEQ format");
                }
                data = new Hashtable();
                data.put("data", bpSeqOutput);
                data.put("tool", "rnaplot");
                data.put("format", "svg");
                String svgOutput = this.postData("plot2d", data);
                if (svgOutput == null || svgOutput.length() == 0) {
                    throw new NoSolutionException("RNAplot cannot compute a 2D plot with your data");
                }
                this.status = "Parsing of RNAplot output";
                Document doc = new SAXBuilder().build((Reader)new StringReader(svgOutput));
                Iterator it = doc.getRootElement().getDescendants((Filter)new ElementFilter("text"));
                int pos = 0;
                float minX = 0.0f;
                float minY = 0.0f;
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    ++pos;
                    Residue2D r = ss.getFactory().createResidue2D(display, Float.parseFloat(e.getAttributeValue("x")), Float.parseFloat(e.getAttributeValue("y")), m, pos);
                    if (r.getX() < minX) {
                        minX = r.getX();
                    }
                    if (!(r.getY() < minY)) continue;
                    minY = r.getY();
                }
                for (Residue2D r : display.getResidues2D()) {
                    r.setX(r.getX() + Math.abs(minX));
                    r.setY(r.getY() + Math.abs(minY));
                }
                m.removeAllSelectedFeatures();
                m.addSelectedFeature(display);
            }
        }
        catch (NoSolutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

