/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ibmc.rnaview;

import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.Adenine3D;
import fr.unistra.ibmc.paradise.core.features.Cytosine3D;
import fr.unistra.ibmc.paradise.core.features.Guanine3D;
import fr.unistra.ibmc.paradise.core.features.Residue2D;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.core.features.Uracil3D;
import fr.unistra.ibmc.paradise.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.core.io.RNAMLFileIO;
import fr.unistra.ibmc.paradise.core.utils.IOUtils;
import fr.unistra.ibmc.paradise.tools.Paradise;
import fr.unistra.ibmc.paradise.tools.component.DefaultProgressMonitor;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBMCRnaviewAnalysis
extends AbstractAnalysis {
    public IBMCRnaviewAnalysis(ParadiseWorkingSession ws) {
        super("RNAVIEW (PARADISE Server)", ws);
        this.addCategory("3D annotation");
    }

    @Override
    public void run(List<Molecule> molecules, Parameters parameters) throws AnalysisException, NoSolutionException {
        long start = System.currentTimeMillis();
        try {
            ArrayList<Residue3D> residues = new ArrayList<Residue3D>();
            for (Molecule molecule : molecules) {
                if (Thread.interrupted()) {
                    throw new AnalysisException("The analysis has been cancelled");
                }
                for (ParadiseFeature r : molecule.getSelectedFeatures()) {
                    residues.add((Residue3D)r);
                }
            }
            ArrayList<Residue3D.Atom> atomsFilled = new ArrayList<Residue3D.Atom>();
            for (Residue3D r : residues) {
                if (Thread.interrupted()) {
                    throw new AnalysisException("The analysis has been cancelled");
                }
                List<Residue3D.Atom> atoms = r.getAtoms();
                for (Residue3D.Atom a : atoms) {
                    if ((!Adenine3D.class.isInstance(r) || !a.getName().equals("N9") && !a.getName().equals("C8") && !a.getName().equals("N7") && !a.getName().equals("C5") && !a.getName().equals("C6") && !a.getName().equals("N6") && !a.getName().equals("N1") && !a.getName().equals("C2") && !a.getName().equals("N3") && !a.getName().equals("C4")) && (!Guanine3D.class.isInstance(r) || !a.getName().equals("N9") && !a.getName().equals("C8") && !a.getName().equals("N7") && !a.getName().equals("C5") && !a.getName().equals("C6") && !a.getName().equals("O6") && !a.getName().equals("N1") && !a.getName().equals("C2") && !a.getName().equals("N2") && !a.getName().equals("N3") && !a.getName().equals("C4")) && (!Uracil3D.class.isInstance(r) || !a.getName().equals("N1") && !a.getName().equals("C2") && !a.getName().equals("O2") && !a.getName().equals("N3") && !a.getName().equals("C4") && !a.getName().equals("04") && !a.getName().equals("C5") && !a.getName().equals("C6")) && (!Cytosine3D.class.isInstance(r) || !a.getName().equals("N1") && !a.getName().equals("C2") && !a.getName().equals("O2") && !a.getName().equals("N3") && !a.getName().equals("C4") && !a.getName().equals("N4") && !a.getName().equals("C5") && !a.getName().equals("C6")) || a.hasCoordinatesFilled()) continue;
                    a.setCoordinates(0.0f, 0.0f, 0.0f);
                    atomsFilled.add(a);
                }
            }
            this.status = "Generation of the PDB file";
            File f = IOUtils.createTemporaryFile("rnaview");
            PDBFileIO.writePDBFile(residues, false, f);
            for (Residue3D.Atom a : atomsFilled) {
                a.eraseCoordinates();
            }
            this.status = "PDB generated in " + (System.currentTimeMillis() - start) / 1000L + "s";
            RNAMLFileIO rnamlParser = new RNAMLFileIO(this.workingSession);
            start = System.currentTimeMillis();
            this.status = "RNAVIEW is running";
            Hashtable<String, String> data = new Hashtable<String, String>();
            data.put("data", FileUtils.readFileToString((File)f));
            data.put("tool", "rnaview");
            String pdbAnnotation = this.postData("annotate3d", data);
            this.status = "RNAVIEW done in " + (System.currentTimeMillis() - start) / 1000L + "s";
            if (pdbAnnotation == null || pdbAnnotation.length() == 0) {
                throw new NoSolutionException("No base-pairs found, no 2D structure plotted (may be a single strand??)");
            }
            start = System.currentTimeMillis();
            this.status = "Parsing of RNAVIEW output";
            File pdbAnnotationFile = IOUtils.createTemporaryFile("rnaview");
            FileUtils.writeStringToFile((File)pdbAnnotationFile, (String)pdbAnnotation);
            rnamlParser.parseFile(pdbAnnotationFile, new DefaultProgressMonitor());
            this.status = "Parsing done in " + (System.currentTimeMillis() - start) / 1000L + "s";
            SecondaryStructure ss = rnamlParser.getSecondaryStructures().get(0);
            ss.setParadiseID(new ParadiseID());
            ss.setName("Secondary Structure");
            ss.setSource(Source.getAnalysisAsSource(this.description));
            ArrayList<Molecule> returnedMolecules = new ArrayList<Molecule>(ss.getMolecules());
            for (int i = 0; i < returnedMolecules.size(); ++i) {
                Molecule returnedMolecule = (Molecule)returnedMolecules.get(i);
                Molecule localMolecule = molecules.get(i);
                if (!returnedMolecule.printSequence().equals(localMolecule.printSequence())) continue;
                returnedMolecule.getParadiseID().setValue(localMolecule.getParadiseID().getValue());
            }
            for (Molecule m : returnedMolecules) {
                if (m.searchCopy(molecules) != null) continue;
                File rnaviewLog = new File(new File(Paradise.getInstallPath()).getParent(), "rnaview.log");
                rnaviewLog.createNewFile();
                PrintWriter pw = new PrintWriter(rnaviewLog);
                pw.println("Log generated at " + new SimpleDateFormat("yyyy.MM.dd HH:mm").format(new Date()) + "\n");
                pw.println("When RNAVIEW meets a problem with a residue (some missing atoms for example), this residue is removed from the original sequence.\n");
                pw.println("The following molecules of your tertiary structure have been sent to RNAVIEW:\n");
                for (Molecule _m : molecules) {
                    pw.println(_m.printSequence() + "\n");
                }
                pw.println("And RNAVIEW returned this unknown molecule:\n");
                pw.println(m.printSequence());
                pw.println("\nWe suggest you to localize and fix the problematic residues before to re-open the tertiary structure with S2S or Assemble");
                pw.close();
                throw new AnalysisException("Cannot process your data since RNAVIEW has altered your molecule(s). Check the rnaview.log file in the S2S/Assemble directory");
            }
            SecondaryStructureDisplay display = null;
            SecondaryStructure copySS = null;
            if (ss.hasOnlyInterhelices() || ss.hasAtLeastOneMoleculeOnlyWithInterhelices() || Paradise.COPY_PSEUDOKNOTS_AND_INTER_MOLECULAR_HELICES) {
                copySS = ss.getFactory().copySecondaryStructure(molecules, ss, true);
            } else {
                copySS = ss.getFactory().copySecondaryStructure(molecules, ss, false);
                copySS.removeSecondaryStructureDisplay(copySS.getSecondaryStructureDisplay());
                for (Molecule m : copySS.getMolecules()) {
                    if (display == null) {
                        display = copySS.getFactory().createSecondaryStructureDisplay(copySS, m, new Location(1, m.getLength()));
                    }
                    data.put("data", ">" + m.getName() + "\n" + m.printSequence() + "\n" + copySS.printAsBracketNotation(m, false, false));
                    data.put("input", "vienna");
                    data.put("output", "bpseq");
                    String bpSeqOutput = this.postData("convert", data);
                    if (bpSeqOutput == null || bpSeqOutput.length() == 0) {
                        throw new NoSolutionException("Problem to convert your data to the BPSEQ format");
                    }
                    data = new Hashtable();
                    data.put("data", bpSeqOutput);
                    data.put("tool", "rnaplot");
                    data.put("format", "svg");
                    String svgOutput = this.postData("plot2d", data);
                    if (svgOutput == null || svgOutput.length() == 0) {
                        throw new NoSolutionException("RNAplot cannot compute a 2D plot with your data");
                    }
                    this.status = "Parsing of RNAplot output";
                    Document doc = new SAXBuilder().build((Reader)new StringReader(svgOutput));
                    Iterator it = doc.getRootElement().getDescendants((Filter)new ElementFilter("text"));
                    int pos = 0;
                    float minX = 0.0f;
                    float minY = 0.0f;
                    while (it.hasNext()) {
                        Element e = (Element)it.next();
                        ++pos;
                        Residue2D r = ss.getFactory().createResidue2D(display, Float.parseFloat(e.getAttributeValue("x")), Float.parseFloat(e.getAttributeValue("y")), m, pos);
                        if (r.getX() < minX) {
                            minX = r.getX();
                        }
                        if (!(r.getY() < minY)) continue;
                        minY = r.getY();
                    }
                    for (Residue2D r : display.getResidues2D()) {
                        r.setX(r.getX() + Math.abs(minX));
                        r.setY(r.getY() + Math.abs(minY));
                    }
                }
            }
            for (Molecule m : molecules) {
                if (Thread.interrupted()) {
                    throw new AnalysisException("The analysis has been cancelled");
                }
                m.removeAllSelectedFeatures();
                m.addSelectedFeature(copySS);
            }
        }
        catch (AnalysisException e) {
            throw e;
        }
        catch (NoSolutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

