/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.rnamotif;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.utils.IOUtils;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.tools.Paradise;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNAMotifAnalysis
extends AbstractAnalysis {
    public static final String DATABASE_PARAMETER_NAME = "database";
    public static final String MINLENGTH_PARAMETER_NAME = "minlength";
    public static final String MAXLENGTH_PARAMETER_NAME = "maxlength";

    public RNAMotifAnalysis(ParadiseWorkingSession ws) {
        super("RNAMotif 3.0.5 (PARADISE Server)", ws);
        this.addCategory("non-coding RNAs candidates searching");
    }

    @Override
    public void run(List<Molecule> molecules, Parameters parameters) throws AnalysisException, NoSolutionException {
        try {
            StructuralDomain sd;
            String databaseSelected = null;
            Parameters p = parameters.getParameters(DATABASE_PARAMETER_NAME);
            if (p.size() == 0) {
                throw new AnalysisException("No database selected for the RNAMotif service");
            }
            databaseSelected = p.getParameter(0).getValue();
            Molecule m = molecules.get(0);
            SecondaryStructure ss = m.getSelectedFeatures(SecondaryStructure.class).get(0);
            File descrFile = IOUtils.createTemporaryFile("descr");
            PrintWriter pw = new PrintWriter(descrFile);
            pw.println("descr");
            ArrayList<StructuralDomain> domains = new ArrayList<StructuralDomain>();
            for (int i = 1; i <= m.getLength(); i += sd.getLength()) {
                sd = ss.getEnclosingStructuralDomain(new Residue(i, m));
                domains.add(sd);
            }
            ArrayList<StructuralDomain> helicesAlreadyOutputted = new ArrayList<StructuralDomain>();
            for (StructuralDomain sd2 : domains) {
                Parameters params = parameters.getParameters(sd2);
                if (Helix.class.isInstance(sd2)) {
                    if (!helicesAlreadyOutputted.contains(sd2)) {
                        pw.println("h5( minlen=" + params.getParameters(MINLENGTH_PARAMETER_NAME).getParameter(0).getValue() + ", maxlen=" + params.getParameters(MAXLENGTH_PARAMETER_NAME).getParameter(0).getValue() + ")");
                        helicesAlreadyOutputted.add(sd2);
                        continue;
                    }
                    pw.println("h3");
                    continue;
                }
                if (!SingleStrand.class.isInstance(sd2)) continue;
                pw.println("ss( minlen=" + params.getParameters(MINLENGTH_PARAMETER_NAME).getParameter(0).getValue() + ", maxlen=" + params.getParameters(MAXLENGTH_PARAMETER_NAME).getParameter(0).getValue() + ")");
            }
            pw.close();
            for (File fastaFile : new File(Paradise.getDatabasesDirectory(), databaseSelected).listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().endsWith(".fasta");
                }
            })) {
            }
        }
        catch (AnalysisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

