/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.tools;

import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.features.IdentityFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.ParadiseFeatureFactoryFactory;
import fr.unistra.ibmc.paradise.core.features.SequenceFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.tools.ParadiseTool;
import fr.unistra.ibmc.paradise.tools.ParadiseToolAgent;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public abstract class AbstractParadiseGUITool
extends Application
implements ParadiseTool,
ParadiseFeatureFactoryFactory {
    protected Window window;
    protected String description;
    protected ParadiseToolAgent agent;
    protected ParadiseWorkingSession workingSession;
    protected boolean launchedTheParadisePlatform;

    protected AbstractParadiseGUITool(String description, ParadiseWorkingSession workingSession, boolean launchedTheParadisePlatform) {
        this.description = description;
        this.workingSession = workingSession;
        this.launchedTheParadisePlatform = launchedTheParadisePlatform;
    }

    public void launch() {
        Runnable doCreateAndShowGUI = new Runnable(){

            public void run() {
                try {
                    ApplicationContext ctx = AbstractParadiseGUITool.this.getContext();
                    ctx.setApplicationClass(AbstractParadiseGUITool.class);
                    ctx.setApplication(AbstractParadiseGUITool.this);
                    ResourceMap appResourceMap = ctx.getResourceMap();
                    appResourceMap.putResource("platform", AbstractParadiseGUITool.platform());
                    AbstractParadiseGUITool.this.initialize(new String[0]);
                    AbstractParadiseGUITool.this.startup();
                    AbstractParadiseGUITool.this.waitForReady();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(doCreateAndShowGUI);
    }

    public void setAgent(ParadiseToolAgent agent) {
        this.agent = agent;
    }

    public ParadiseToolAgent getAgent() {
        return this.agent;
    }

    public ParadiseWorkingSession getWorkingSession() {
        return this.workingSession;
    }

    public IdentityFeatureFactory createIdentityFeatureFactory() {
        return new IdentityFeatureFactory(this.workingSession, this.description);
    }

    public StructuralFeatureFactory createStructuralFeatureFactory() {
        return new StructuralFeatureFactory(this.workingSession, this.description);
    }

    public SequenceFeatureFactory createSequenceFeatureFactory() {
        return new SequenceFeatureFactory(this.workingSession, this.description);
    }

    public String getDescription() {
        return this.description;
    }
}

