/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.tools.component;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.core.io.ParadiseFileIO;
import fr.unistra.ibmc.paradise.tools.component.ParadiseTask;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.application.Application;

public class FileParsingTask
extends ParadiseTask {
    private File f;
    private ParadiseFileIO parser;
    private List<Molecule> moleculesBeforeParsing;
    private ParadiseWorkingSession session;

    public FileParsingTask(Application app, File f, ParadiseFileIO parser, ProgressMonitor monitor, ParadiseWorkingSession session) {
        super(app, monitor);
        this.f = f;
        this.parser = parser;
        this.session = session;
        this.moleculesBeforeParsing = new ArrayList<Molecule>(session.getMolecules());
    }

    protected Void doInBackground() {
        try {
            this.setMessage("Parsing of " + this.f.getName());
            this.monitor.startAnimation();
            long start = System.currentTimeMillis();
            this.parser.parseFile(this.f, this.monitor);
            this.setMessage("End of Parsing. Parsing time: " + (System.currentTimeMillis() - start) / 1000L + "s");
        }
        catch (InterruptedException e) {
            block3: for (Molecule m : this.session.getMolecules()) {
                for (Molecule _m : this.moleculesBeforeParsing) {
                    if (!_m.getParadiseID().equals(m.getParadiseID())) continue;
                    continue block3;
                }
                this.session.removeMolecule(m);
            }
            return null;
        }
        catch (FileParsingException e) {
            this.monitor.printException(e);
            for (Molecule m : this.parser.getMolecules()) {
                this.session.removeMolecule(m);
            }
            return null;
        }
        return null;
    }
}

