/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.tools.component;

import fr.unistra.ibmc.paradise.core.utils.GeneralUtils;
import fr.unistra.ibmc.paradise.tools.ParadiseToolAgent;
import jade.core.AID;
import jade.lang.acl.ACLMessage;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressBar
extends JFrame {
    private JProgressBar progress;
    private JLabel label1;
    private JButton cancel;
    private JPanel topPanel;
    private AID receiver;
    private ParadiseToolAgent toolAgent;
    private String conversationId;

    public ProgressBar(String conversationId, String text, AID receiver, ParadiseToolAgent toolAgent) {
        this.conversationId = conversationId;
        this.receiver = receiver;
        this.toolAgent = toolAgent;
        this.setTitle("Please wait...");
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.topPanel = new JPanel();
        this.topPanel.setPreferredSize(new Dimension(310, 100));
        this.add(this.topPanel);
        this.label1 = new JLabel(text);
        this.label1.setPreferredSize(new Dimension(280, 24));
        this.topPanel.add(this.label1);
        this.progress = new JProgressBar();
        this.progress.setPreferredSize(new Dimension(300, 20));
        this.progress.setIndeterminate(true);
        this.topPanel.add(this.progress);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new CancelListener());
        this.topPanel.add(this.cancel);
        this.pack();
        GeneralUtils.centerOnScreen(this);
        this.setVisible(true);
        this.toFront();
    }

    public void setReceiver(AID receiver) {
        this.receiver = receiver;
    }

    public void setMessage(String message) {
        this.label1.setText(message);
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ACLMessage cancel = new ACLMessage(2);
            cancel.setConversationId(ProgressBar.this.conversationId);
            if (ProgressBar.this.receiver != null) {
                cancel.addReceiver(ProgressBar.this.receiver);
            }
            ProgressBar.this.toolAgent.send(cancel);
            ProgressBar.this.dispose();
        }
    }
}

