/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core;

import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location
implements Serializable {
    private List<Block> blocks = new ArrayList<Block>();

    public Location() {
    }

    public int[] getSinglePositions() {
        int[] positions = new int[this.getLength()];
        int count = 0;
        for (Block b : this.blocks) {
            int i = b.start;
            while (i <= b.end) {
                positions[count++] = i++;
            }
        }
        return positions;
    }

    public Location(String location) throws BiologicalSymbolException {
        this();
        String[] blocks = location.trim().split(",");
        String[] ends = null;
        String[] _ends = null;
        try {
            for (String b : blocks) {
                ends = b.split("-");
                _ends = b.split(":");
                if (ends.length == 2) {
                    this.addBlock(new Block(Integer.parseInt(ends[0]), Integer.parseInt(ends[1])));
                    continue;
                }
                if (_ends.length == 2) {
                    this.addBlock(new Block(Integer.parseInt(_ends[0]), Integer.parseInt(_ends[0]) + Integer.parseInt(_ends[1]) - 1));
                    continue;
                }
                if (ends.length == 1 && _ends.length == 1) {
                    this.addBlock(new Block(Integer.parseInt(_ends[0]), Integer.parseInt(_ends[0])));
                    continue;
                }
                throw new BiologicalSymbolException("Unknown location description", location, this);
            }
        }
        catch (NumberFormatException e) {
            throw new BiologicalSymbolException("The description of the location contains an alpha character", location, this);
        }
    }

    public Location(int pos) {
        this(pos, pos);
    }

    public Location(int start, int end) {
        this();
        if (start != 0 && end != 0) {
            this.addBlock(new Block(start, end));
        }
    }

    public Location(Location l1, Location l2) {
        this();
        for (Block b : l1.blocks) {
            this.addBlock(new Block(b));
        }
        for (Block b : l2.blocks) {
            this.addBlock(new Block(b));
        }
    }

    public Location(Location l) {
        this();
        for (Block b : l.blocks) {
            this.addBlock(new Block(b));
        }
    }

    protected Location(List<Block> blocks) {
        this();
        for (Block b : blocks) {
            this.addBlock(new Block(b));
        }
    }

    public Location intersectionOf(Location l) {
        Location new_location = new Location();
        for (Block b1 : this.blocks) {
            for (Block b2 : l.blocks) {
                if (!b1.intersect(b2)) continue;
                new_location.addBlock(b1.intersectionOf(b2));
            }
        }
        return new_location;
    }

    public boolean hasAtLeastOnePositionInCommonWith(Location l) {
        int[] boundaries = this.getBoundaries();
        for (int i = 0; i < boundaries.length - 1; i += 2) {
            for (int j = boundaries[i]; j <= boundaries[i + 1]; ++j) {
                if (!l.hasPosition(j)) continue;
                return true;
            }
        }
        return false;
    }

    public Location unionOf(Location l) {
        Location new_location = new Location();
        for (Block b1 : this.blocks) {
            new_location.addBlock(new Block(b1));
        }
        for (Block b2 : l.blocks) {
            new_location.addBlock(new Block(b2));
        }
        return new_location;
    }

    public Location differenceOf(Location l) {
        Location new_location = new Location();
        for (Block b1 : this.blocks) {
            block1: for (int i = b1.start; i <= b1.end; ++i) {
                for (Block b2 : l.blocks) {
                    if (!b2.contains(i)) continue;
                    continue block1;
                }
                new_location.addBlock(new Block(i, i));
            }
        }
        return new_location;
    }

    public int[] getBoundaries() {
        int[] boundaries = new int[this.blocks.size() * 2];
        int i = 0;
        for (Block b : this.blocks) {
            boundaries[i] = b.start;
            boundaries[i + 1] = b.end;
            i += 2;
        }
        return boundaries;
    }

    public void add(Location l) {
        for (Block b : l.blocks) {
            this.addBlock(new Block(b));
        }
    }

    public void add(int start, int end) {
        this.addBlock(new Block(start, end));
    }

    public void add(int pos) {
        this.add(pos, pos);
    }

    public void remove(int pos) {
        this.remove(new Location(pos, pos));
    }

    public int getLength() {
        int length = 0;
        for (Block b : this.blocks) {
            length += b.getLength();
        }
        return length;
    }

    public void remove(Location l) {
        Location difference = this.differenceOf(l);
        this.blocks.clear();
        this.add(difference);
    }

    public boolean intersect(Location l) {
        return l.getStart() >= this.getStart() && l.getStart() <= this.getEnd() || l.getEnd() >= this.getStart() && l.getEnd() <= this.getEnd();
    }

    public boolean contains(Location l) {
        return l.getStart() >= this.getStart() && l.getEnd() <= this.getEnd();
    }

    public boolean strictlyContains(Location l) {
        for (Block b1 : this.blocks) {
            for (Block b2 : l.blocks) {
                if (b1.contains(b2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasPosition(int pos) {
        for (Block b : this.blocks) {
            if (pos < b.start || pos > b.end) continue;
            return true;
        }
        return false;
    }

    public boolean hasPosition(Location location) {
        for (Block sourceBlock : location.blocks) {
            for (Block b : this.blocks) {
                if (sourceBlock.isIncludedIn(b)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isIncludedIn(Location l) {
        return l.getStart() <= this.getStart() && l.getEnd() >= this.getEnd();
    }

    public boolean isStrictlyIncludedIn(Location l) {
        return this.isIncludedIn(l) && !this.matchWith(l);
    }

    public boolean isIndependantWith(Location l) {
        return !this.intersect(l) && !this.contains(l) && !this.isIncludedIn(l);
    }

    public boolean matchWith(Location l) {
        return this.matchWith(this.blocks, l.blocks);
    }

    public int getStart() {
        return this.blocks.size() == 0 ? 0 : this.blocks.get(0).start;
    }

    public int getEnd() {
        return this.blocks.size() == 0 ? 0 : this.blocks.get(this.blocks.size() - 1).end;
    }

    public boolean isSinglePosition() {
        return this.blocks.size() == 1 && this.blocks.get(0).isSinglePosition();
    }

    public boolean isEmpty() {
        return this.blocks.size() == 0;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.isEmpty()) {
            return buff.append("EMPTY").toString();
        }
        if (this.isSinglePosition()) {
            return buff.append(this.getStart()).toString();
        }
        for (Block b : this.blocks) {
            if (b.isSinglePosition()) {
                buff.append(b.start);
            } else {
                buff.append(b.start);
                buff.append(":");
                buff.append(b.end - b.start + 1);
            }
            if (this.blocks.indexOf(b) == this.blocks.size() - 1) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    public String toString(Map<Integer, String> residuesLabels) {
        StringBuffer buff = new StringBuffer();
        if (this.isEmpty()) {
            return buff.append("EMPTY").toString();
        }
        if (this.isSinglePosition()) {
            return buff.append(residuesLabels.get(this.getStart())).toString();
        }
        for (Block b : this.blocks) {
            if (b.isSinglePosition()) {
                buff.append(residuesLabels.get(b.start));
            } else {
                buff.append(residuesLabels.get(b.start));
                buff.append(":");
                buff.append(b.end - b.start + 1);
            }
            if (this.blocks.indexOf(b) == this.blocks.size() - 1) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    private boolean matchWith(List<Block> blocks_1, List<Block> blocks_2) {
        for (Block b1 : blocks_1) {
            for (Block b2 : blocks_2) {
                if (b1.matchWith(b2)) continue;
                return false;
            }
        }
        return true;
    }

    protected void addBlock(Block newBlock) {
        int i;
        ArrayList<Block> blocksToRemoved = new ArrayList<Block>();
        Block bl = null;
        boolean merged = false;
        for (i = 0; i < this.blocks.size() && (!newBlock.isBefore(bl = this.blocks.get(i)) || newBlock.isBeside(bl)); ++i) {
            if (newBlock.intersect(bl) || newBlock.isBeside(bl)) {
                newBlock.merge(bl);
                blocksToRemoved.add(bl);
                merged = true;
                continue;
            }
            if (merged) break;
        }
        if (merged) {
            this.blocks.add(i, newBlock);
            this.blocks.removeAll(blocksToRemoved);
        } else if (i == this.blocks.size()) {
            this.blocks.add(newBlock);
        } else {
            this.blocks.add(i, newBlock);
        }
    }

    public Location translate(int range) {
        ArrayList<Block> new_blocks = new ArrayList<Block>(this.blocks.size());
        for (Block b : this.blocks) {
            new_blocks.add(new Block(b.start + range, b.end + range));
        }
        return new Location(new_blocks);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!Location.class.isInstance(o)) {
            return false;
        }
        Location otherLocation = (Location)o;
        if (otherLocation.getBoundaries().length != this.getBoundaries().length) {
            return false;
        }
        for (int i = 0; i < this.getBoundaries().length; ++i) {
            if (this.getBoundaries()[i] == otherLocation.getBoundaries()[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuffer buffer = new StringBuffer();
        for (int i : this.getBoundaries()) {
            buffer.append(i);
            buffer.append(",");
        }
        return buffer.toString().hashCode();
    }

    public static void main(String[] args) {
        Location l = new Location();
        l.add(new Location(1, 2));
        l.remove(new Location(1, 2));
        System.out.println(l);
    }

    private final class Block
    implements Serializable {
        private int start;
        private int end;

        private Block(int start, int end) {
            if (start < end) {
                this.start = start;
                this.end = end;
            } else {
                this.start = end;
                this.end = start;
            }
        }

        private Block(Block b) {
            this.start = b.start;
            this.end = b.end;
        }

        private int getLength() {
            return this.end - this.start + 1;
        }

        private boolean matchWith(Block b) {
            return b.start == this.start && b.end == this.end;
        }

        private boolean isIncludedIn(Block b) {
            return this.start >= b.start && this.end <= b.end;
        }

        private boolean intersect(Block b) {
            return b.start >= this.start && b.start <= this.end || b.end >= this.start && b.end <= this.end || b.isIncludedIn(this) || this.isIncludedIn(b);
        }

        private boolean isBefore(Block b) {
            return this.end < b.start;
        }

        private boolean isAfter(Block b) {
            return this.start > b.end;
        }

        public boolean isBeside(Block bl) {
            return this.start - 1 == bl.end || this.end + 1 == bl.start || bl.start - 1 == this.end || bl.end + 1 == this.start;
        }

        private void merge(Block b) {
            if (b.start < this.start) {
                this.start = b.start;
            }
            if (b.end > this.end) {
                this.end = b.end;
            }
        }

        private Block intersectionOf(Block b) {
            if (this.isIncludedIn(b)) {
                return new Block(this.start, this.end);
            }
            if (b.isIncludedIn(this)) {
                return new Block(b.start, b.end);
            }
            if (b.start >= this.start && b.start <= this.end) {
                return new Block(b.start, this.end);
            }
            if (b.end >= this.start && b.end <= this.end) {
                return new Block(this.start, b.end);
            }
            return null;
        }

        private boolean isSinglePosition() {
            return this.start == this.end;
        }

        public String toString() {
            return "block " + this.start + "-" + this.end;
        }

        public boolean contains(int position) {
            return position >= this.start && position <= this.end;
        }

        public boolean contains(Block b) {
            return b.start >= this.start && b.end <= this.end;
        }
    }
}

