/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core;

import fr.unistra.ibmc.paradise.core.ArchitectureException;
import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Documentable;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Organism;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.ParadiseProjectItem;
import fr.unistra.ibmc.paradise.core.Taxon;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Molecule
extends Documentable,
ParadiseProjectItem {
    public void addResidue(String var1) throws BiologicalSymbolException;

    public void removeFeature(ParadiseFeature var1);

    public void addFeature(ParadiseFeature var1, Location var2) throws ArchitectureException;

    public ParadiseID getParadiseID();

    public void makeAllAnnotationsPersistent();

    public void makeAllAnnotationsNotPersistent();

    public void recoverBackupAnnotations();

    public String[] getPhylogeny();

    public Organism getOrganism();

    public void setOrganism(Organism var1);

    public void moveFeature(ParadiseFeature var1, Location var2) throws ArchitectureException;

    public List<Annotation> getAnnotations();

    public boolean isSelected(ParadiseFeature var1);

    public List<Annotation> getAnnotations(Class var1, Location var2);

    public List<Annotation> getAnnotations(Location var1);

    public Annotation getAnnotation(ParadiseFeature var1);

    public List<Annotation> getAnnotations(Class var1);

    public void addSelectedFeature(ParadiseFeature var1);

    public void removeSelectedFeature(ParadiseFeature var1);

    public void removeAllSelectedFeatures();

    public List<ParadiseFeature> getSelectedFeatures();

    public <T extends ParadiseFeature> List<T> getSelectedFeatures(Class<T> var1);

    public void setName(String var1);

    public String getName();

    public int getLength();

    public String printSequence(Location var1);

    public String printSequence();

    public Molecule searchCopy(List<Molecule> var1);

    public String getResidueAt(int var1) throws ArchitectureException;

    public Taxon getTaxon();

    public void setTaxon(Taxon var1);

    public boolean equals(Object var1);

    public static interface Annotation
    extends Documentable {
        public Molecule getMolecule();

        public ParadiseFeature getFeature();

        public Location getLocation();

        public void addToLocation(Location var1) throws ArchitectureException;

        public void removeFromLocation(Location var1);
    }
}

