/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core;

import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.NucleicAcid;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.tools.Paradise;
import javax.swing.JOptionPane;

public final class RNA
extends NucleicAcid {
    RNA(ParadiseID paradiseID, MoleculeFactory moleculeFactory, String name, Source source, String sequence) throws BiologicalSymbolException {
        super(paradiseID, moleculeFactory, name, source);
        sequence = sequence.trim().toUpperCase();
        int step = 1;
        for (int i = 0; i < sequence.length(); i += step) {
            String res = sequence.substring(i, i + step);
            try {
                this.addResidue(res);
                continue;
            }
            catch (BiologicalSymbolException e) {
                if (!BiologicalSymbolException.UNKNOWN_RESIDUE.equals(e.getMessage())) continue;
                System.out.println("New unknown residue " + res + " in " + source.getId());
                String choice = null;
                while (choice == null || choice.length() == 0) {
                    choice = (String)JOptionPane.showInputDialog(null, "Please choose an unmodified residue", "Unknown Residue " + res, 2, null, new String[]{"A", "U", "G", "C"}, "A");
                    Paradise.addModifiedResidue(res, choice);
                }
                this.addResidue(choice);
            }
        }
    }

    public void addResidue(String residueSymbol) throws BiologicalSymbolException {
        String unModifiedNucleotide = Paradise.getModifiedNucleotides().get(residueSymbol);
        if (unModifiedNucleotide != null) {
            this.sequence.append(unModifiedNucleotide);
            this.moleculeFactory.getSequenceFeatureFactory().createModifiedResidue(residueSymbol, this, this.sequence.length());
        } else if ("ADE".equals(residueSymbol) || "A".equals(residueSymbol)) {
            this.sequence.append("A");
        } else if ("URA".equals(residueSymbol) || "URI".equals(residueSymbol) || "U".equals(residueSymbol)) {
            this.sequence.append("U");
        } else if ("GUA".equals(residueSymbol) || "G".equals(residueSymbol)) {
            this.sequence.append("G");
        } else if ("CYT".equals(residueSymbol) || "C".equals(residueSymbol)) {
            this.sequence.append("C");
        } else if ("M".equals(residueSymbol)) {
            this.sequence.append("M");
        } else if ("R".equals(residueSymbol)) {
            this.sequence.append("R");
        } else if ("W".equals(residueSymbol)) {
            this.sequence.append("W");
        } else if ("S".equals(residueSymbol)) {
            this.sequence.append("S");
        } else if ("Y".equals(residueSymbol)) {
            this.sequence.append("Y");
        } else if ("K".equals(residueSymbol)) {
            this.sequence.append("K");
        } else if ("V".equals(residueSymbol)) {
            this.sequence.append("V");
        } else if ("H".equals(residueSymbol)) {
            this.sequence.append("H");
        } else if ("D".equals(residueSymbol)) {
            this.sequence.append("D");
        } else if ("B".equals(residueSymbol)) {
            this.sequence.append("B");
        } else if ("X".equals(residueSymbol)) {
            this.sequence.append("X");
        } else if ("N".equals(residueSymbol)) {
            this.sequence.append("N");
        } else {
            throw new BiologicalSymbolException(BiologicalSymbolException.UNKNOWN_RESIDUE, residueSymbol, this);
        }
    }
}

