/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.analysis;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.analysis.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters
implements Serializable {
    private List<Parameter> parameters = new ArrayList<Parameter>();

    public List<Parameter> getParameters() {
        return new ArrayList<Parameter>(this.parameters);
    }

    public Parameters getParameters(String parameterName) {
        Parameters parameters = new Parameters();
        for (Parameter p : this.parameters) {
            if (!parameterName.equals(p.getName())) continue;
            parameters.addParameter(p);
        }
        return parameters;
    }

    public Parameter getParameter(int index) {
        return this.parameters.get(index);
    }

    public Parameters getParameters(ParadiseFeature feature) {
        Parameters parameters = new Parameters();
        for (Parameter p : this.parameters) {
            if (p.getFeature() == null || !feature.getParadiseID().equals(p.getFeature().getParadiseID())) continue;
            parameters.addParameter(p);
        }
        return parameters;
    }

    public Parameters getParameters(Molecule m) {
        Parameters parameters = new Parameters();
        for (Parameter p : this.parameters) {
            if (p.getMolecule() == null || !((Object)m).equals(p.getMolecule())) continue;
            parameters.addParameter(p);
        }
        return parameters;
    }

    public boolean contains(String parameterName) {
        return this.getParameters(parameterName).size() != 0;
    }

    public int size() {
        return this.parameters.size();
    }

    public void addParameter(Parameter parameter) {
        if (!this.parameters.contains(parameter)) {
            this.parameters.add(parameter);
        }
    }

    public void removeParameter(Parameter parameter) {
        if (this.parameters.contains(parameter)) {
            this.parameters.remove(parameter);
        }
    }

    public void clear() {
        this.parameters.clear();
    }
}

