/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.features;

import fr.unistra.ibmc.paradise.core.AbstractDocumentable;
import fr.unistra.ibmc.paradise.core.ArchitectureException;
import fr.unistra.ibmc.paradise.core.CollectionFilter;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.MainParadiseFeature;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Residues;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.ParadiseFeatureFactory;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParadiseFeature
extends AbstractDocumentable
implements ParadiseFeature {
    protected List<ParadiseFeature> subfeatures;
    protected List<ParadiseFeature> parentfeatures;
    protected Map<Molecule, Molecule.Annotation> annotations;
    protected ParadiseFeatureFactory factory;
    protected Source source;
    protected File associatedFile;
    protected ParadiseID paradiseID;

    protected AbstractParadiseFeature(ParadiseFeatureFactory factory, int subFeaturesNb) {
        this.factory = factory;
        this.subfeatures = new ArrayList<ParadiseFeature>(subFeaturesNb);
        for (int i = 0; i < subFeaturesNb; ++i) {
            this.subfeatures.add(null);
        }
        this.parentfeatures = new ArrayList<ParadiseFeature>();
        this.annotations = new HashMap<Molecule, Molecule.Annotation>();
        this.paradiseID = new ParadiseID();
    }

    @Override
    public ParadiseID getParadiseID() {
        return this.paradiseID;
    }

    protected AbstractParadiseFeature(ParadiseFeatureFactory factory) {
        this(factory, 0);
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public void setSource(Source source) {
        this.source = source;
    }

    @Override
    public void setAssociatedFile(File file) {
        this.associatedFile = file;
    }

    @Override
    public File getAssociatedFile() {
        return this.associatedFile;
    }

    @Override
    public ParadiseFeatureFactory getFactory() {
        return this.factory;
    }

    @Override
    public List<ParadiseFeature> getSubFeatures() {
        return new ArrayList<ParadiseFeature>(this.subfeatures);
    }

    @Override
    public <T extends ParadiseFeature> List<T> getSubFeatures(Class<T> c) {
        return CollectionFilter.filter(c, this.getSubFeatures());
    }

    @Override
    public <T extends ParadiseFeature> List<T> getSubFeatures(Class<T> c, Molecule molecule) {
        ArrayList<ParadiseFeature> list = new ArrayList<ParadiseFeature>();
        for (ParadiseFeature feature : this.getSubFeatures(c)) {
            if (!feature.annotates(molecule)) continue;
            list.add(feature);
        }
        return list;
    }

    @Override
    public <T extends ParadiseFeature> List<T> getSubFeatures(Class<T> c, Molecule molecule, Location location) {
        ArrayList<ParadiseFeature> list = new ArrayList<ParadiseFeature>();
        for (ParadiseFeature feature : this.getSubFeatures(c)) {
            if (!feature.annotates(molecule) || !feature.getFullLocation(molecule).matchWith(location)) continue;
            list.add(feature);
        }
        return list;
    }

    @Override
    public <T extends ParadiseFeature> List<T> getSubFeaturesRecursively(Class<T> c) {
        ArrayList<T> ret = new ArrayList<T>();
        for (ParadiseFeature subFeature : this.getSubFeatures()) {
            if (c.isInstance(subFeature)) {
                ret.add(c.cast(subFeature));
                continue;
            }
            ret.addAll(subFeature.getSubFeaturesRecursively(c));
        }
        return ret;
    }

    @Override
    public List<ParadiseFeature> getSubFeaturesRecursively() {
        ArrayList<ParadiseFeature> ret = new ArrayList<ParadiseFeature>();
        for (ParadiseFeature subFeature : this.getSubFeatures()) {
            ret.add(subFeature);
            ret.addAll(subFeature.getSubFeaturesRecursively());
        }
        return ret;
    }

    @Override
    public List<ParadiseFeature> getParentFeatures() {
        return new ArrayList<ParadiseFeature>(this.parentfeatures);
    }

    @Override
    public <T extends ParadiseFeature> List<T> getParentFeatures(Class<T> c) {
        return CollectionFilter.filter(c, this.getParentFeatures());
    }

    @Override
    public List<Molecule.Annotation> getAnnotations() {
        return new ArrayList<Molecule.Annotation>(this.annotations.values());
    }

    @Override
    public boolean annotates(Molecule molecule) {
        for (Molecule.Annotation annotation : this.getAnnotations()) {
            if (annotation.getMolecule() == null || !annotation.getMolecule().getParadiseID().equals(molecule.getParadiseID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSubFeature(ParadiseFeature subFeature) {
        for (ParadiseFeature feature : this.getSubFeatures()) {
            if (feature != subFeature && !feature.hasSubFeature(subFeature)) continue;
            return true;
        }
        return false;
    }

    protected void addSubFeature(int index, ParadiseFeature feature) throws ArchitectureException {
        if (feature.getAnnotations().size() == 0) {
            throw new ArchitectureException("A feature has to annotate at least one Molecule before to be added as a subfeature", this, feature);
        }
        if (!this.subfeatures.contains(feature)) {
            this.subfeatures.add(index, feature);
            ((AbstractParadiseFeature)feature).parentfeatures.add(this);
            for (Molecule.Annotation a : feature.getAnnotations()) {
                a.getMolecule().addFeature(this, a.getLocation());
            }
        }
    }

    protected void addSubFeature(ParadiseFeature feature) throws ArchitectureException {
        this.addSubFeature(this.subfeatures.size(), feature);
    }

    public void removeSubFeature(ParadiseFeature feature) {
        if (this.subfeatures.contains(feature)) {
            this.subfeatures.remove(feature);
            ((AbstractParadiseFeature)feature).parentfeatures.remove(this);
        }
    }

    @Override
    public Location getFullLocation(Molecule molecule) {
        Location l = new Location();
        Molecule.Annotation a = this.annotations.get(molecule);
        if (a != null) {
            l.add(a.getLocation());
        }
        for (ParadiseFeature f : new ArrayList<ParadiseFeature>(this.subfeatures)) {
            if (MainParadiseFeature.class.isInstance(f)) continue;
            l.add(f.getFullLocation(molecule));
        }
        return l;
    }

    @Override
    public void addAnnotation(Molecule.Annotation a) throws ArchitectureException {
        if (a.getFeature().equals(this) && !this.annotations.containsValue(a)) {
            this.annotations.put(a.getMolecule(), a);
        }
    }

    @Override
    public void removeAnnotation(Molecule.Annotation a) {
        if (this.annotations.containsValue(a)) {
            this.annotations.remove(a.getMolecule());
            if (a.getMolecule() != null) {
                a.getMolecule().removeFeature(this);
            }
            if (this.annotations.size() == 0) {
                for (ParadiseFeature f : this.parentfeatures) {
                    ((AbstractParadiseFeature)f).subfeatures.remove(this);
                }
                this.parentfeatures.clear();
                for (ParadiseFeature f : this.subfeatures) {
                    ((AbstractParadiseFeature)f).parentfeatures.remove(this);
                }
                this.subfeatures.clear();
            }
        }
    }

    @Override
    public void addToLocation(Location l, Molecule m) throws ArchitectureException {
        if (l.getEnd() > m.getLength()) {
            throw new ArchitectureException("Location to add to a feature outside of a molecule boundaries", m, l, this);
        }
        Molecule.Annotation a = m.getAnnotation(this);
        if (a != null) {
            a.getLocation().add(l);
        } else {
            m.addFeature(this, l);
        }
    }

    @Override
    public void removeFromLocation(Location l, Molecule m) {
        Molecule.Annotation a = m.getAnnotation(this);
        if (a != null) {
            l = a.getLocation().intersectionOf(l);
            for (ParadiseFeature f : this.subfeatures) {
                for (Molecule.Annotation _a : f.getAnnotations()) {
                    if (m != _a.getMolecule()) continue;
                    l = l.differenceOf(_a.getLocation());
                }
            }
            a.getLocation().remove(l);
            for (ParadiseFeature f : this.getParentFeatures()) {
                f.removeFromLocation(l, m);
            }
            if (a.getLocation().isEmpty()) {
                m.removeFeature(this);
            }
        }
    }

    @Override
    public Collection<Molecule> getMolecules() {
        TreeSet<Molecule> molecules = new TreeSet<Molecule>(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Molecule)o1).getParadiseID().toString().compareTo(((Molecule)o2).getParadiseID().toString());
            }
        });
        molecules.addAll(this.annotations.keySet());
        for (ParadiseFeature f : new ArrayList<ParadiseFeature>(this.subfeatures)) {
            if (MainParadiseFeature.class.isInstance(f)) continue;
            molecules.addAll(f.getMolecules());
        }
        return molecules;
    }

    @Override
    public boolean contains(Residue r) {
        for (Molecule m : this.getMolecules()) {
            Location l;
            if (!m.getParadiseID().equals(r.getMoleculeId()) || !(l = this.getFullLocation(m)).hasPosition(r.getAbsolutePosition())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNoSubFeatures() {
        return this.subfeatures.size() == 0;
    }

    @Override
    public boolean hasNoParentFeatures() {
        return this.parentfeatures.size() == 0;
    }

    @Override
    public boolean annotatesNothing() {
        return this.annotations.size() == 0;
    }

    @Override
    public Residues getResidues() {
        Residues residues = new Residues();
        for (Molecule m : this.getMolecules()) {
            int[] boundaries = this.getFullLocation(m).getBoundaries();
            for (int i = 0; i < boundaries.length; i += 2) {
                for (int j = boundaries[i]; j <= boundaries[i + 1]; ++j) {
                    residues.add(new Residue(j, m));
                }
            }
        }
        return residues;
    }

    public boolean equals(Object o) {
        if (!ParadiseFeature.class.isInstance(o)) {
            return false;
        }
        return this.getParadiseID().equals(((ParadiseFeature)o).getParadiseID());
    }
}

