/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.features;

import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.features.AtomAtomInteraction;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.StructuralInteraction;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseBaseInteraction
extends StructuralInteraction {
    public static final char EDGE_WATSON_CRICK = 'W';
    public static final char EDGE_HOOGSTEEN = 'H';
    public static final char EDGE_SUGAR_EDGE = 'S';
    public static final char UNDEFINED_EDGE = '?';
    public static final char ORIENTATION_CIS = 'C';
    public static final char ORIENTATION_TRANS = 'T';
    public static final char UNDEFINED_ORIENTATION = '?';
    public static final int RESIDUE_1 = 1;
    public static final int RESIDUE_2 = 2;
    public static final int UNDEFINED_RESIDUE = -1;
    public static Map<String, String> isostericFamiliesInstances = new HashMap<String, String>();

    protected BaseBaseInteraction(StructuralFeatureFactory factory, Molecule m, Location l) {
        super(factory);
        m.addFeature(this, l);
    }

    protected BaseBaseInteraction(StructuralFeatureFactory factory, Molecule m1, Location l1, Molecule m2, Location l2) {
        super(factory);
        m1.addFeature(this, l1);
        m2.addFeature(this, l2);
    }

    public abstract void generateAtomAtomInteractions();

    public void removeAtomAtomInteractions() {
        for (AtomAtomInteraction interaction : this.getAtomAtomInteractions()) {
            this.removeAtomAtomInteraction(interaction);
        }
    }

    public String getFamily() {
        return new StringBuffer().append(this.getOrientation()).append(this.getEdge1()).append(this.getEdge2()).toString();
    }

    public abstract char getEdge1();

    public abstract char getEdge2();

    public abstract char getOrientation();

    public List<AtomAtomInteraction> getAtomAtomInteractions() {
        return this.getSubFeatures(AtomAtomInteraction.class);
    }

    public static boolean isAmbiguous(char residue1, char residue2, char edge1, char edge2, char orientation) throws BiologicalSymbolException {
        String[] ambiguous;
        if (residue1 != 'A' && residue1 != 'C' && residue1 != 'G' && residue1 != 'U') {
            throw new BiologicalSymbolException("Residue symbol must be A,C,G or U", "" + residue1, null);
        }
        if (residue2 != 'A' && residue2 != 'C' && residue2 != 'G' && residue2 != 'U') {
            throw new BiologicalSymbolException("Residue symbol must be A,C,G or U", "" + residue2, null);
        }
        if (edge1 != 'H' && edge1 != 'S' && edge1 != 'W') {
            throw new BiologicalSymbolException("Edge must be H, S or W", "" + edge1, null);
        }
        if (edge2 != 'H' && edge2 != 'S' && edge2 != 'W') {
            throw new BiologicalSymbolException("Edge must be H, S or W", "" + edge2, null);
        }
        if (orientation != 'C' && orientation != 'T') {
            throw new BiologicalSymbolException("Orientation must be C or T", "" + orientation, null);
        }
        String signature = orientation + "" + edge1 + "" + edge2 + "" + residue1 + residue2;
        for (String value : ambiguous = new String[]{"CHHGG", "CSSAA", "CSSAC", "CSSAG", "CSSAU", "CSSCA", "CSSCC", "CSSCG", "CSSCU", "CSSGA", "CSSGC", "CSSGG", "CSSGU", "CSSUA", "CSSUC", "CSSUG", "CCSUU", "CWWAA", "CWWCC", "CWWUU", "THHAA", "THHGG", "TSSAA", "TSSAG", "TSSGA"}) {
            if (!value.equals(signature)) continue;
            return true;
        }
        return false;
    }

    public void removeAtomAtomInteraction(AtomAtomInteraction aai) {
        super.removeSubFeature(aai);
    }

    public Residue getResidue() {
        if (this.getMolecules().size() > 0) {
            Molecule m = this.getMolecules().iterator().next();
            return new Residue(this.getFullLocation(m).getStart(), m);
        }
        return null;
    }

    public Residue getPartnerResidue() {
        if (this.getMolecules().size() > 0) {
            Iterator<Molecule> i = this.getMolecules().iterator();
            Molecule m = i.next();
            if (i.hasNext()) {
                m = i.next();
                return new Residue(this.getFullLocation(m).getStart(), m);
            }
            return new Residue(this.getFullLocation(m).getEnd(), m);
        }
        return null;
    }

    public boolean isSecondaryInteraction() {
        for (ParadiseFeature f : this.parentfeatures) {
            if (!Helix.class.isInstance(f)) continue;
            return true;
        }
        return false;
    }

    public int isIsosteric(char b, int baseId, char pb, int partnerBaseId) {
        char base = baseId == this.getResidue().getAbsolutePosition() ? b : pb;
        char partnerBase = partnerBaseId == this.getPartnerResidue().getAbsolutePosition() ? pb : b;
        String iso1 = isostericFamiliesInstances.get(new StringBuffer().append(base).append(this.getOrientation()).append(this.getEdge1()).append(this.getEdge2()).append(partnerBase).toString());
        String iso2 = isostericFamiliesInstances.get(new StringBuffer().append(this.getResidue().getSymbol()).append(this.getOrientation()).append(this.getEdge1()).append(this.getEdge2()).append(this.getPartnerResidue().getSymbol()).toString());
        if (iso2 == null) {
            iso2 = isostericFamiliesInstances.get(new StringBuffer().append(this.getPartnerResidue().getSymbol()).append(this.getOrientation()).append(this.getEdge2()).append(this.getEdge1()).append(this.getResidue().getSymbol()).toString());
        }
        if (iso1 == null) {
            iso1 = isostericFamiliesInstances.get(new StringBuffer().append(partnerBase).append(this.getOrientation()).append(this.getEdge2()).append(this.getEdge1()).append(base).toString());
        }
        if (iso2 == null) {
            return 0;
        }
        if (iso1 == null) {
            return 0;
        }
        if (iso1.equals(iso2)) {
            return 2;
        }
        if (iso1.split("-")[0].equals(iso2.split("-")[0])) {
            return 1;
        }
        return 0;
    }

    public boolean isCanonical() {
        String type = this.getFamily();
        String canonicalType = new StringBuffer().append('C').append('W').append('W').toString();
        return canonicalType.equals(type) && ('G' == this.getResidue().getSymbol() && 'U' == this.getPartnerResidue().getSymbol() || 'U' == this.getResidue().getSymbol() && 'G' == this.getPartnerResidue().getSymbol() || 'A' == this.getResidue().getSymbol() && 'U' == this.getPartnerResidue().getSymbol() || 'U' == this.getResidue().getSymbol() && 'A' == this.getPartnerResidue().getSymbol() || 'G' == this.getResidue().getSymbol() && 'C' == this.getPartnerResidue().getSymbol() || 'C' == this.getResidue().getSymbol() && 'G' == this.getPartnerResidue().getSymbol());
    }

    public boolean fitsInHelix(Helix h) {
        List<Molecule.Annotation> ans = h.getAnnotations();
        List<Molecule.Annotation> ians = this.getAnnotations();
        if (ans.size() == ians.size()) {
            Molecule mi;
            Molecule mh;
            if (ans.size() == 1 && ((Object)(mh = ans.get(0).getMolecule())).equals(mi = ians.get(0).getMolecule())) {
                int spread;
                Location lh = ans.get(0).getLocation();
                Location li = ians.get(0).getLocation();
                int[] bh = lh.getBoundaries();
                if (bh.length == 4) {
                    spread = bh[0] + bh[3];
                    if (li.getStart() + li.getEnd() == spread && bh[0] <= li.getStart() && li.getStart() <= bh[1]) {
                        return true;
                    }
                } else {
                    bh = new int[]{lh.getStart(), lh.getStart() + lh.getLength() / 2 - 1, lh.getEnd() - lh.getLength() / 2 + 1, lh.getEnd()};
                    spread = bh[0] + bh[3];
                    if (li.getStart() + li.getEnd() == spread && bh[0] <= li.getStart() && li.getStart() <= bh[1]) {
                        return true;
                    }
                }
            }
            if (ans.size() == 2) {
                Molecule mh1 = ans.get(0).getMolecule();
                Molecule mh2 = ans.get(1).getMolecule();
                Molecule mi1 = null;
                Molecule mi2 = null;
                Molecule mi3 = ians.get(0).getMolecule();
                if (((Object)mi3).equals(mh1)) {
                    mi1 = mi3;
                } else if (((Object)mi3).equals(mh2)) {
                    mi2 = mi3;
                } else {
                    return false;
                }
                mi3 = ians.get(1).getMolecule();
                if (((Object)mi3).equals(mh1)) {
                    mi1 = mi3;
                } else if (((Object)mi3).equals(mh2)) {
                    mi2 = mi3;
                } else {
                    return false;
                }
                Location lh1 = ans.get(0).getLocation();
                Location lh2 = ans.get(1).getLocation();
                Location li1 = null;
                Location li2 = null;
                if (((Object)mi1).equals(mh1)) {
                    li1 = ians.get(0).getLocation();
                    li2 = ians.get(1).getLocation();
                } else {
                    li1 = ians.get(1).getLocation();
                    li2 = ians.get(0).getLocation();
                }
                int spread = lh1.getStart() + lh2.getEnd();
                if (li1.getStart() + li2.getEnd() == spread && lh1.getStart() <= li1.getStart() && li1.getStart() <= lh1.getEnd()) {
                    return true;
                }
            }
        }
        return false;
    }

    public int getDominant() {
        return -1;
    }

    static {
        isostericFamiliesInstances.put("ACWWA", "CWW-I4");
        isostericFamiliesInstances.put("ACWWC", "CWW-I2");
        isostericFamiliesInstances.put("ACWWG", "CWW-I3");
        isostericFamiliesInstances.put("ACWWU", "CWW-I1");
        isostericFamiliesInstances.put("CCWWC", "CWW-I6");
        isostericFamiliesInstances.put("CCWWG", "CWW-I1");
        isostericFamiliesInstances.put("CCWWU", "CWW-I5");
        isostericFamiliesInstances.put("GCWWU", "CWW-I1");
        isostericFamiliesInstances.put("UCWWU", "CWW-I6");
        isostericFamiliesInstances.put("ATWWA", "TWW-I4");
        isostericFamiliesInstances.put("ATWWC", "TWW-I3");
        isostericFamiliesInstances.put("ATWWU", "TWW-I1");
        isostericFamiliesInstances.put("CTWWC", "TWW-I6");
        isostericFamiliesInstances.put("CTWWG", "TWW-I2");
        isostericFamiliesInstances.put("CTWWU", "TWW-I5");
        isostericFamiliesInstances.put("GTWWG", "TWW-I4");
        isostericFamiliesInstances.put("GTWWU", "TWW-I3");
        isostericFamiliesInstances.put("UTWWU", "TWW-I6");
        isostericFamiliesInstances.put("ACWHG", "CWH-I3");
        isostericFamiliesInstances.put("ACWHU", "CWH-I3");
        isostericFamiliesInstances.put("CCWHC", "CWH-I2");
        isostericFamiliesInstances.put("CCWHG", "CWH-I1");
        isostericFamiliesInstances.put("CCWHU", "CWH-I1");
        isostericFamiliesInstances.put("GCWHA", "CWH-I3");
        isostericFamiliesInstances.put("GCWHG", "CWH-I4");
        isostericFamiliesInstances.put("UCWHA", "CWH-I1");
        isostericFamiliesInstances.put("UCWHG", "CWH-I1");
        isostericFamiliesInstances.put("UCWHU", "CWH-I2");
        isostericFamiliesInstances.put("ATWHA", "TWH-I4");
        isostericFamiliesInstances.put("ATWHG", "TWH-I4");
        isostericFamiliesInstances.put("CTWHA", "TWH-I2");
        isostericFamiliesInstances.put("CTWHC", "TWH-I1");
        isostericFamiliesInstances.put("CTWHG", "TWH-I2");
        isostericFamiliesInstances.put("GTWHG", "TWH-I5");
        isostericFamiliesInstances.put("GTWHU", "TWH-I4");
        isostericFamiliesInstances.put("UTWHA", "TWH-I1");
        isostericFamiliesInstances.put("UTWHG", "TWH-I3");
        isostericFamiliesInstances.put("UTWHU", "TWH-I2");
        isostericFamiliesInstances.put("ACWSA", "CWS-I1");
        isostericFamiliesInstances.put("ACWSC", "CWS-I1");
        isostericFamiliesInstances.put("ACWSG", "CWS-I1");
        isostericFamiliesInstances.put("ACWSU", "CWS-I1");
        isostericFamiliesInstances.put("CCWSA", "CWS-I2");
        isostericFamiliesInstances.put("CCWSC", "CWS-I2");
        isostericFamiliesInstances.put("CCWSG", "CWS-I2");
        isostericFamiliesInstances.put("CCWSU", "CWS-I2");
        isostericFamiliesInstances.put("GCWSA", "CWS-I3");
        isostericFamiliesInstances.put("GCWSC", "CWS-I3");
        isostericFamiliesInstances.put("GCWSG", "CWS-I5");
        isostericFamiliesInstances.put("GCWSU", "CWS-I3");
        isostericFamiliesInstances.put("UCWSA", "CWS-I4");
        isostericFamiliesInstances.put("UCWSC", "CWS-I4");
        isostericFamiliesInstances.put("UCWSG", "CWS-I4");
        isostericFamiliesInstances.put("UCWSU", "CWS-I4");
        isostericFamiliesInstances.put("ATWSA", "TWS-I1");
        isostericFamiliesInstances.put("ATWSC", "TWS-I1");
        isostericFamiliesInstances.put("ATWSG", "TWS-I1");
        isostericFamiliesInstances.put("ATWSU", "TWS-I1");
        isostericFamiliesInstances.put("CTWSA", "TWS-I1");
        isostericFamiliesInstances.put("CTWSC", "TWS-I1");
        isostericFamiliesInstances.put("CTWSG", "TWS-I1");
        isostericFamiliesInstances.put("CTWSU", "TWS-I1");
        isostericFamiliesInstances.put("GTWSC", "TWS-I2");
        isostericFamiliesInstances.put("GTWSU", "TWS-I2");
        isostericFamiliesInstances.put("UTWSA", "TWS-I3");
        isostericFamiliesInstances.put("UTWSC", "TWS-I3");
        isostericFamiliesInstances.put("UTWSG", "TWS-I4");
        isostericFamiliesInstances.put("UTWSU", "TWS-I3");
        isostericFamiliesInstances.put("ACHHG", "CHH-I2");
        isostericFamiliesInstances.put("CCHHG", "CHH-I1");
        isostericFamiliesInstances.put("GCHHG", "CHH-I1");
        isostericFamiliesInstances.put("ATHHA", "THH-I1");
        isostericFamiliesInstances.put("ATHHC", "THH-I1");
        isostericFamiliesInstances.put("ATHHG", "THH-I2");
        isostericFamiliesInstances.put("ATHHU", "THH-I2");
        isostericFamiliesInstances.put("CTHHG", "THH-I1");
        isostericFamiliesInstances.put("CTHHU", "THH-I2");
        isostericFamiliesInstances.put("GTHHG", "THH-I3");
        isostericFamiliesInstances.put("UTHHC", "THH-I2");
        isostericFamiliesInstances.put("ACHSA", "CHS-I1");
        isostericFamiliesInstances.put("ACHSC", "CHS-I1");
        isostericFamiliesInstances.put("ACHSG", "CHS-I1");
        isostericFamiliesInstances.put("ACHSU", "CHS-I1");
        isostericFamiliesInstances.put("CCHSA", "CHS-I1");
        isostericFamiliesInstances.put("CCHSC", "CHS-I1");
        isostericFamiliesInstances.put("CCHSG", "CHS-I1");
        isostericFamiliesInstances.put("CCHSU", "CHS-I1");
        isostericFamiliesInstances.put("GCHSA", "CHS-I1");
        isostericFamiliesInstances.put("GCHSG", "CHS-I1");
        isostericFamiliesInstances.put("UCHSA", "CHS-I2");
        isostericFamiliesInstances.put("UCHSC", "CHS-I1");
        isostericFamiliesInstances.put("UCHSG", "CHS-I1");
        isostericFamiliesInstances.put("UCHSU", "CHS-I1");
        isostericFamiliesInstances.put("ATHSA", "THS-I1");
        isostericFamiliesInstances.put("ATHSC", "THS-I1");
        isostericFamiliesInstances.put("ATHSG", "THS-I1");
        isostericFamiliesInstances.put("ATHSU", "THS-I1");
        isostericFamiliesInstances.put("CTHSA", "THS-I1");
        isostericFamiliesInstances.put("CTHSC", "THS-I1");
        isostericFamiliesInstances.put("CTHSU", "THS-I1");
        isostericFamiliesInstances.put("GTHSG", "THS-I2");
        isostericFamiliesInstances.put("UTHSA", "THS-I2");
        isostericFamiliesInstances.put("UTHSG", "THS-I2");
        isostericFamiliesInstances.put("ACSSA", "CSS-I1");
        isostericFamiliesInstances.put("ACSSC", "CSS-I1");
        isostericFamiliesInstances.put("ACSSG", "CSS-I1");
        isostericFamiliesInstances.put("ACSSU", "CSS-I1");
        isostericFamiliesInstances.put("CCSSC", "CSS-I1");
        isostericFamiliesInstances.put("CCSSG", "CSS-I1");
        isostericFamiliesInstances.put("CCSSU", "CSS-I1");
        isostericFamiliesInstances.put("GCSSG", "CSS-I1");
        isostericFamiliesInstances.put("GCSSU", "CSS-I1");
        isostericFamiliesInstances.put("UCSSU", "CSS-I1");
        isostericFamiliesInstances.put("ATSSA", "TSS-I1");
        isostericFamiliesInstances.put("ATSSC", "TSS-I1");
        isostericFamiliesInstances.put("ATSSG", "TSS-I1");
        isostericFamiliesInstances.put("ATSSU", "TSS-I1");
        isostericFamiliesInstances.put("GTSSA", "TSS-I2");
        isostericFamiliesInstances.put("GTSSC", "TSS-I2");
        isostericFamiliesInstances.put("GTSSG", "TSS-I2");
        isostericFamiliesInstances.put("GTSSU", "TSS-I2");
        isostericFamiliesInstances.put("ACsSA", "CSS-I1");
        isostericFamiliesInstances.put("ACsSC", "CSS-I1");
        isostericFamiliesInstances.put("ACsSG", "CSS-I1");
        isostericFamiliesInstances.put("ACsSU", "CSS-I1");
        isostericFamiliesInstances.put("CCsSA", "CSS-I1");
        isostericFamiliesInstances.put("CCsSC", "CSS-I1");
        isostericFamiliesInstances.put("CCsSG", "CSS-I1");
        isostericFamiliesInstances.put("CCsSU", "CSS-I1");
        isostericFamiliesInstances.put("GCsSA", "CSS-I1");
        isostericFamiliesInstances.put("GCsSC", "CSS-I1");
        isostericFamiliesInstances.put("GCsSG", "CSS-I1");
        isostericFamiliesInstances.put("GCsSU", "CSS-I1");
        isostericFamiliesInstances.put("UCsSA", "CSS-I1");
        isostericFamiliesInstances.put("UCsSC", "CSS-I1");
        isostericFamiliesInstances.put("UCsSG", "CSS-I1");
        isostericFamiliesInstances.put("UCsSU", "CSS-I1");
        isostericFamiliesInstances.put("ATsSA", "TSS-I1");
        isostericFamiliesInstances.put("ATsSC", "TSS-I1");
        isostericFamiliesInstances.put("ATsSG", "TSS-I1");
        isostericFamiliesInstances.put("ATsSU", "TSS-I1");
        isostericFamiliesInstances.put("GTsSA", "TSS-I2");
        isostericFamiliesInstances.put("GTsSC", "TSS-I2");
        isostericFamiliesInstances.put("GTsSG", "TSS-I2");
        isostericFamiliesInstances.put("GTsSU", "TSS-I2");
        isostericFamiliesInstances.put("ACSsA", "CSS-I1");
        isostericFamiliesInstances.put("ACSsC", "CSS-I1");
        isostericFamiliesInstances.put("ACSsG", "CSS-I1");
        isostericFamiliesInstances.put("ACSsU", "CSS-I1");
        isostericFamiliesInstances.put("CCSsA", "CSS-I1");
        isostericFamiliesInstances.put("CCSsC", "CSS-I1");
        isostericFamiliesInstances.put("CCSsG", "CSS-I1");
        isostericFamiliesInstances.put("CCSsU", "CSS-I1");
        isostericFamiliesInstances.put("GCSsA", "CSS-I1");
        isostericFamiliesInstances.put("GCSsC", "CSS-I1");
        isostericFamiliesInstances.put("GCSsG", "CSS-I1");
        isostericFamiliesInstances.put("GCSsU", "CSS-I1");
        isostericFamiliesInstances.put("UCSsA", "CSS-I1");
        isostericFamiliesInstances.put("UCSsC", "CSS-I1");
        isostericFamiliesInstances.put("UCSsG", "CSS-I1");
        isostericFamiliesInstances.put("UCSsU", "CSS-I1");
        isostericFamiliesInstances.put("ATSsA", "TSS-I1");
        isostericFamiliesInstances.put("ATSsC", "TSS-I1");
        isostericFamiliesInstances.put("ATSsG", "TSS-I1");
        isostericFamiliesInstances.put("ATSsU", "TSS-I1");
        isostericFamiliesInstances.put("GTSsA", "TSS-I2");
        isostericFamiliesInstances.put("GTSsC", "TSS-I2");
        isostericFamiliesInstances.put("GTSsG", "TSS-I2");
        isostericFamiliesInstances.put("GTSsU", "TSS-I2");
    }
}

