/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.features;

import fr.unistra.ibmc.paradise.core.ArchitectureException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.AtomAtomInteraction;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;

public class CisHHInteraction
extends BaseBaseInteraction {
    private int dominant;

    protected CisHHInteraction(StructuralFeatureFactory factory, int dominantResidue, Molecule m, Location l) {
        super(factory, m, l);
        this.dominant = dominantResidue;
    }

    protected CisHHInteraction(StructuralFeatureFactory factory, int dominantResidue, Molecule m1, Location l1, Molecule m2, Location l2) {
        super(factory, m1, l1, m2, l2);
        this.dominant = dominantResidue;
    }

    protected CisHHInteraction(StructuralFeatureFactory factory, Molecule m, Location l) {
        super(factory, m, l);
        this.dominant = -1;
    }

    protected CisHHInteraction(StructuralFeatureFactory factory, Molecule m1, Location l1, Molecule m2, Location l2) {
        super(factory, m1, l1, m2, l2);
        this.dominant = -1;
    }

    public void generateAtomAtomInteractions() {
        if (this.getAnnotations().size() == 1) {
            Molecule m = this.getAnnotations().get(0).getMolecule();
            Location l = this.getAnnotations().get(0).getLocation();
            char f = m.getResidueAt(l.getStart()).charAt(0);
            char s = m.getResidueAt(l.getEnd()).charAt(0);
            block0 : switch (f) {
                case 'A': {
                    AtomAtomInteraction aai;
                    switch (s) {
                        case 'A': {
                            break block0;
                        }
                        case 'C': {
                            break block0;
                        }
                        case 'G': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N6", "O6", 'H', m, l);
                            break block0;
                        }
                    }
                    break;
                }
                case 'C': {
                    AtomAtomInteraction aai;
                    switch (s) {
                        case 'A': {
                            break block0;
                        }
                        case 'C': {
                            break block0;
                        }
                        case 'G': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "C6", "O6", 'C', m, l);
                            break block0;
                        }
                    }
                    break;
                }
                case 'G': {
                    AtomAtomInteraction aai;
                    switch (s) {
                        case 'A': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O6", "N6", 'H', m, l);
                            break block0;
                        }
                        case 'C': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O6", "C6", 'C', m, l);
                            break block0;
                        }
                        case 'G': {
                            if (this.getDominant() == -1) {
                                throw new ArchitectureException("This interaction is ambiguous, you must specify the dominant residue");
                            }
                            if (this.getDominant() == 1) {
                                aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O6", "C8", 'C', m, l);
                                break block0;
                            }
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "C8", "O6", 'C', m, l);
                            break block0;
                        }
                    }
                    break;
                }
                case 'U': {
                    switch (s) {
                        case 'A': {
                            break block0;
                        }
                        case 'C': {
                            break block0;
                        }
                        case 'G': {
                            break block0;
                        }
                    }
                }
            }
        }
        if (this.getAnnotations().size() == 2) {
            Molecule m1 = this.getAnnotations().get(0).getMolecule();
            Molecule m2 = this.getAnnotations().get(1).getMolecule();
            Location l1 = this.getAnnotations().get(0).getLocation();
            Location l2 = this.getAnnotations().get(1).getLocation();
            char f = m1.getResidueAt(l1.getStart()).charAt(0);
            char s = m2.getResidueAt(l2.getEnd()).charAt(0);
            block26 : switch (f) {
                case 'A': {
                    switch (s) {
                        case 'A': {
                            break block26;
                        }
                        case 'C': {
                            break block26;
                        }
                        case 'G': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N6", "O6", 'H', m1, l1, m2, l2);
                            break block26;
                        }
                    }
                    break;
                }
                case 'C': {
                    switch (s) {
                        case 'A': {
                            break block26;
                        }
                        case 'C': {
                            break block26;
                        }
                        case 'G': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "C6", "O6", 'C', m1, l1, m2, l2);
                            break block26;
                        }
                    }
                    break;
                }
                case 'G': {
                    switch (s) {
                        case 'A': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O6", "N6", 'H', m1, l1, m2, l2);
                            break block26;
                        }
                        case 'C': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O6", "C6", 'C', m1, l1, m2, l2);
                            break block26;
                        }
                        case 'G': {
                            if (this.getDominant() == -1) {
                                throw new ArchitectureException("This interaction is ambiguous, you must specify the dominant residue");
                            }
                            if (this.getDominant() == 1) {
                                AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O6", "C8", 'C', m1, l1, m2, l2);
                                break block26;
                            }
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "C8", "O6", 'C', m1, l1, m2, l2);
                            break block26;
                        }
                    }
                    break;
                }
                case 'U': {
                    switch (s) {
                        case 'A': {
                            break block26;
                        }
                        case 'C': {
                            break block26;
                        }
                        case 'G': {
                            break block26;
                        }
                    }
                }
            }
        }
    }

    public char getEdge1() {
        return 'H';
    }

    public char getEdge2() {
        return 'H';
    }

    public char getOrientation() {
        return 'C';
    }

    public int getDominant() {
        return this.dominant;
    }
}

