/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.features;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.AbstractMainParadiseFeature;
import fr.unistra.ibmc.paradise.core.features.AtomAtomInteraction;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecondaryStructure
extends AbstractMainParadiseFeature {
    protected SecondaryStructure(StructuralFeatureFactory factory, String name, Source source) {
        super(factory, name, source);
    }

    @Override
    public StructuralFeatureFactory getFactory() {
        return (StructuralFeatureFactory)super.getFactory();
    }

    public List<BaseBaseInteraction> getTertiaryInteractions() {
        return this.getSubFeatures(BaseBaseInteraction.class);
    }

    public void addTertiaryInteraction(BaseBaseInteraction bbi) {
        this.addSubFeature(bbi);
    }

    public List<BaseBaseInteraction> getSecondaryInteractions() {
        ArrayList<BaseBaseInteraction> secondaryInteractions = new ArrayList<BaseBaseInteraction>();
        for (Helix h : this.getHelices()) {
            secondaryInteractions.addAll(h.getBaseBaseInteractions());
        }
        return secondaryInteractions;
    }

    public List<BaseBaseInteraction> getBaseBaseInteractions() {
        ArrayList<BaseBaseInteraction> allInteractions = new ArrayList<BaseBaseInteraction>();
        allInteractions.addAll(this.getSubFeatures(BaseBaseInteraction.class));
        for (Helix h : this.getHelices()) {
            allInteractions.addAll(h.getBaseBaseInteractions());
        }
        return allInteractions;
    }

    public List<AtomAtomInteraction> getAtomAtomInteractions() {
        ArrayList<AtomAtomInteraction> allInteractions = new ArrayList<AtomAtomInteraction>();
        allInteractions.addAll(this.getSubFeatures(AtomAtomInteraction.class));
        for (BaseBaseInteraction bbi : this.getBaseBaseInteractions()) {
            allInteractions.addAll(bbi.getAtomAtomInteractions());
        }
        return allInteractions;
    }

    public List<SingleStrand> getSingleStrands() {
        return this.getSubFeatures(SingleStrand.class);
    }

    public void removeSingleStrand(SingleStrand ss) {
        for (Molecule m : ss.getMolecules()) {
            m.removeFeature(ss);
        }
        this.removeSubFeature(ss);
    }

    public void removeBaseBaseInteraction(BaseBaseInteraction interaction) {
        interaction.removeAtomAtomInteractions();
        for (Molecule m : interaction.getMolecules()) {
            m.removeFeature(interaction);
        }
        this.removeSubFeature(interaction);
    }

    public List<TertiaryStructure> getLinkedTertiaryStructures() {
        return this.getSubFeatures(TertiaryStructure.class);
    }

    public List<Helix> getHelices() {
        return new ArrayList<Helix>(this.getSubFeatures(Helix.class));
    }

    public List<Helix> getHelicesWithoutPKnots() {
        HashSet<Helix> allHelices = new HashSet<Helix>();
        for (Helix h : this.getSubFeatures(Helix.class)) {
            if (h.isPseudoKnot()) continue;
            allHelices.add(h);
        }
        return new ArrayList<Helix>(allHelices);
    }

    public void removeHelix(Helix h) {
        for (BaseBaseInteraction interaction : h.getBaseBaseInteractions()) {
            h.removeBaseBaseInteraction(interaction);
        }
        for (Molecule m : h.getMolecules()) {
            m.removeFeature(h);
        }
        this.removeSubFeature(h);
    }

    public boolean hasOnlyInterhelices() {
        for (Helix h : this.getHelices()) {
            if (h.isInterMolecular()) continue;
            return false;
        }
        return true;
    }

    public boolean hasAtLeastOneMoleculeOnlyWithInterhelices() {
        ArrayList<Molecule> hits = new ArrayList<Molecule>(this.getMolecules());
        block0: for (Molecule m : this.getMolecules()) {
            for (Molecule.Annotation a : m.getAnnotations(Helix.class)) {
                if (((Helix)a.getFeature()).isInterMolecular()) continue;
                hits.remove(m);
                continue block0;
            }
        }
        return !hits.isEmpty();
    }

    public void removeSecondaryStructureDisplay(SecondaryStructureDisplay display) {
        for (Molecule m : display.getMolecules()) {
            m.removeFeature(display);
        }
        super.removeSubFeature(display);
    }

    public SecondaryStructureDisplay getSecondaryStructureDisplay() {
        List<SecondaryStructureDisplay> displays = this.getSubFeatures(SecondaryStructureDisplay.class);
        if (displays.isEmpty()) {
            return null;
        }
        return displays.get(0);
    }

    public StructuralDomain getEnclosingStructuralDomain(Residue r) {
        for (Helix h : this.getHelices()) {
            if (!h.contains(r)) continue;
            return h;
        }
        for (SingleStrand ss : this.getSingleStrands()) {
            if (!ss.contains(r)) continue;
            return ss;
        }
        return null;
    }

    public Residue getPairedResidueInSecondaryInteraction(Residue r) {
        for (Helix h : this.getHelices()) {
            for (BaseBaseInteraction interaction : h.getBaseBaseInteractions()) {
                if (interaction.getResidue().equals(r)) {
                    return interaction.getPartnerResidue();
                }
                if (!interaction.getPartnerResidue().equals(r)) continue;
                return interaction.getResidue();
            }
        }
        return null;
    }

    public void linkStructuralAlignment(StructuralAlignment alignment) {
        this.addSubFeature(alignment);
    }

    public List<StructuralAlignment> getLinkedStructuralAlignments() {
        return this.getSubFeatures(StructuralAlignment.class);
    }

    public List<Helix> getPseudoKnots() {
        ArrayList<Helix> pknots = new ArrayList<Helix>();
        for (Helix h : this.getHelices()) {
            if (!h.isPseudoKnot()) continue;
            pknots.add(h);
        }
        return pknots;
    }

    public String printAsBracketNotation(Molecule m, boolean exportPseudoKnots, boolean exportInterMolecularHelices) {
        char[] ret = new char[m.getLength()];
        for (int i = 0; i < m.getLength(); ++i) {
            ret[i] = 46;
        }
        for (Helix helix : this.getHelices()) {
            if (helix.isInterMolecular() && !exportInterMolecularHelices || helix.isPseudoKnot() && !exportPseudoKnots || !helix.annotates(m) || helix.getMolecules().size() != 1) continue;
            for (BaseBaseInteraction bb : helix.getBaseBaseInteractions()) {
                ret[bb.getFullLocation((Molecule)m).getStart() - 1] = 40;
                ret[bb.getFullLocation((Molecule)m).getEnd() - 1] = 41;
            }
        }
        return new String(ret);
    }
}

