/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.features;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.utils.Residue;

public class SingleStrand
extends StructuralDomain {
    public static final String APICAL_LOOP = "apical";
    public static final String TERMINAL_SSTRAND = "terminal";
    public static final String JUNCTION_LOOP = "junction";
    public static final String INTERNAL_LOOP = "internal";

    protected SingleStrand(StructuralFeatureFactory factory, String name) {
        super(factory, name);
    }

    public int getLength() {
        return this.getFullLocation(this.getMolecules().iterator().next()).getLength();
    }

    public int get5PrimeEnd() {
        return this.getFullLocation(this.getMolecules().iterator().next()).getStart();
    }

    public int get3PrimeEnd() {
        return this.getFullLocation(this.getMolecules().iterator().next()).getEnd();
    }

    public boolean isApicalLoop() {
        int _5End = this.get5PrimeEnd();
        int _3End = this.get3PrimeEnd();
        if (_5End == 1) {
            return false;
        }
        Molecule m = this.getMolecules().iterator().next();
        if (_3End == m.getLength()) {
            return false;
        }
        SecondaryStructure ss = this.getParentFeatures(SecondaryStructure.class).get(0);
        return ss.getEnclosingStructuralDomain(new Residue(_5End - 1, m)).equals(ss.getEnclosingStructuralDomain(new Residue(_3End + 1, m)));
    }

    public boolean isAtFivePrimeEnd() {
        return this.get5PrimeEnd() == 1;
    }

    public boolean isAtThreePrimeEnd() {
        Molecule m = this.getMolecules().iterator().next();
        return m.getLength() == this.getFullLocation(m).getEnd();
    }

    public Helix getPreviousHelix() {
        SecondaryStructure ss = this.getParentFeatures(SecondaryStructure.class).get(0);
        Molecule m = this.getMolecules().iterator().next();
        return (Helix)ss.getEnclosingStructuralDomain(new Residue(this.getFullLocation(m).getStart() - 1, m));
    }

    public Helix getNextHelix() {
        SecondaryStructure ss = this.getParentFeatures(SecondaryStructure.class).get(0);
        Molecule m = this.getMolecules().iterator().next();
        return (Helix)ss.getEnclosingStructuralDomain(new Residue(this.getFullLocation(m).getEnd() + 1, m));
    }

    public boolean isInternalLoop() {
        SecondaryStructure ss = this.getParentFeatures(SecondaryStructure.class).get(0);
        Helix helix1 = this.getPreviousHelix();
        Helix helix2 = this.getNextHelix();
        if (helix1 == null || helix2 == null) {
            return false;
        }
        if (helix1 == helix2) {
            return false;
        }
        for (Residue r : helix1.get5PrimeEnds()) {
            for (Residue _r : helix2.get3PrimeEnds()) {
                if (r.getAbsolutePosition() - 1 != _r.getAbsolutePosition()) continue;
                return true;
            }
        }
        for (SingleStrand singleStrand : ss.getSingleStrands()) {
            if (singleStrand == this) continue;
            Helix _helix1 = singleStrand.getNextHelix();
            Helix _helix2 = singleStrand.getPreviousHelix();
            if (helix1 != _helix1 || helix2 != _helix2) continue;
            return true;
        }
        return false;
    }
}

