/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.features;

import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.Identity;
import fr.unistra.ibmc.paradise.core.features.IdentityFeatureFactory;
import java.util.HashMap;
import java.util.Map;

public class StructuralIdentity
extends Identity {
    private String name;
    private int length;
    private Map<Molecule, Location> gapsLocations;

    protected StructuralIdentity(IdentityFeatureFactory factory, String name) {
        super(factory);
        this.name = name;
        this.gapsLocations = new HashMap<Molecule, Location>();
    }

    public void addAnnotation(Molecule.Annotation a) {
        super.addAnnotation(a);
        if (this.length < a.getLocation().getLength()) {
            this.length = a.getLocation().getLength();
        }
    }

    public void removeAnnotation(Molecule.Annotation a) {
        Location l = a.getLocation();
        super.removeAnnotation(a);
        if (l.getLength() == this.length) {
            int newLength = 0;
            for (Molecule.Annotation _a : this.getAnnotations()) {
                if (_a.getLocation().getLength() == this.length) {
                    return;
                }
                if (newLength >= _a.getLocation().getLength()) continue;
                newLength = _a.getLocation().getLength();
            }
            this.length = newLength;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected boolean isBefore(StructuralIdentity identity) {
        for (Molecule.Annotation an : this.getAnnotations()) {
            Location lri = identity.getFullLocation(an.getMolecule());
            if (lri == null) continue;
            Location lth = an.getLocation();
            return lth.getStart() < lri.getStart();
        }
        return false;
    }

    public int getLength() {
        Molecule m = this.getMolecules().iterator().next();
        Location gapsLocation = this.getGapsLocation(m);
        return gapsLocation != null ? this.getFullLocation(m).getLength() + gapsLocation.getLength() : this.getFullLocation(m).getLength();
    }

    public Location getGapsLocation(Molecule m) {
        return this.gapsLocations.get(m);
    }

    public void addGapsLocation(Molecule m, Location l) {
        this.gapsLocations.put(m, l);
    }
}

