/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.io;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.IdentityFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.AbstractParadiseFileIO;
import fr.unistra.ibmc.paradise.core.io.CTFileIO;
import fr.unistra.ibmc.paradise.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.core.io.StockholmFileIO;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastaFileIO
extends AbstractParadiseFileIO {
    public static final String[] suffixes = new String[]{"fasta", "fna", "fa", "fas", "txt"};
    public static final String SECONDARY_STRUCTURE_HEADER = ">Secondary Structure";
    private List<StructuralAlignment> structuralAlignments;
    protected List<SecondaryStructure> secondaryStructures;
    protected List<Molecule> molecules;
    private IdentityFeatureFactory identityFeatureFactory;
    protected StructuralFeatureFactory structuralFeatureFactory = this.createStructuralFeatureFactory();

    public FastaFileIO(MoleculeFactory moleculeFactory) {
        super("FASTA File parser", moleculeFactory);
        this.identityFeatureFactory = this.createIdentityFeatureFactory();
    }

    @Override
    public List<StructuralAlignment> getStructuralAlignments() {
        return this.structuralAlignments;
    }

    @Override
    public List<SecondaryStructure> getSecondaryStructures() {
        return this.secondaryStructures;
    }

    @Override
    public List<TertiaryStructure> getTertiaryStructures() {
        return new ArrayList<TertiaryStructure>();
    }

    @Override
    public List<Molecule> getMolecules() {
        return this.molecules;
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                for (String suffix : suffixes) {
                    if (!file.getName().endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return "Fasta files";
            }
        };
    }

    @Override
    public void parseFile(File f, ProgressMonitor monitor) throws FileParsingException {
        block14: {
            this.molecules = new ArrayList<Molecule>();
            this.secondaryStructures = new ArrayList<SecondaryStructure>();
            this.structuralAlignments = new ArrayList<StructuralAlignment>();
            StringBuffer seq = new StringBuffer();
            StringBuffer brackets = new StringBuffer();
            HashMap<String, String> sequences = new HashMap<String, String>();
            String name = null;
            boolean isAlignment = false;
            try {
                String sequence;
                String line;
                BufferedReader in = new BufferedReader(new FileReader(f));
                while ((line = in.readLine()) != null) {
                    if (line.startsWith(SECONDARY_STRUCTURE_HEADER)) {
                        while ((line = in.readLine()) != null && !line.startsWith(">")) {
                            brackets.append(line.replace('<', '.').replace('>', '.').replace('{', '.').replace('}', '.').replace('[', '.').replace(']', '.'));
                        }
                    }
                    if (line.startsWith(">")) {
                        if (seq.length() != 0 && name != null) {
                            sequence = seq.toString();
                            sequences.put(name, sequence);
                            isAlignment = sequence.indexOf(45) != -1;
                        }
                        name = line.substring(1);
                        seq = new StringBuffer();
                        continue;
                    }
                    seq.append(line.replace('.', '-').replace('_', '-'));
                }
                in.close();
                if (seq.length() != 0 && name != null) {
                    sequence = seq.toString();
                    sequences.put(name, sequence);
                    boolean bl = isAlignment = sequence.indexOf(45) != -1;
                }
                if (!isAlignment && brackets.length() == 0) {
                    for (Map.Entry e : sequences.entrySet()) {
                        this.molecules.add(this.moleculeFactory.createRNA(new ParadiseID(), (String)e.getKey(), Source.getFileAsSource(f), (String)e.getValue()));
                    }
                    break block14;
                }
                if (!isAlignment && brackets.length() != 0) {
                    for (Map.Entry e : sequences.entrySet()) {
                        File ctFile = File.createTempFile((String)e.getKey(), "ct");
                        CTFileIO.writeCTFile(ctFile, (String)e.getValue(), brackets.toString());
                        CTFileIO parser = new CTFileIO(this.moleculeFactory);
                        parser.parseFile(ctFile, monitor);
                        this.secondaryStructures.addAll(parser.getSecondaryStructures());
                        this.molecules.addAll(parser.getMolecules());
                    }
                    break block14;
                }
                if (isAlignment && brackets.length() != 0) {
                    File stockholmFile = File.createTempFile("alignment", "stockholm");
                    PrintWriter pw = new PrintWriter(stockholmFile);
                    pw.println("# STOCKHOLM 1.0");
                    for (Map.Entry e : sequences.entrySet()) {
                        pw.println(((String)e.getKey()).replaceAll("\\s+", "_") + "                     " + (String)e.getValue());
                    }
                    pw.println("#=GC SS_cons                     " + brackets.toString());
                    pw.close();
                    StockholmFileIO parser = new StockholmFileIO(this.moleculeFactory);
                    parser.parseFile(stockholmFile, monitor);
                    this.secondaryStructures.addAll(parser.getSecondaryStructures());
                    this.structuralAlignments.addAll(parser.getStructuralAlignments());
                    this.molecules.addAll(parser.getMolecules());
                    break block14;
                }
                throw new FileParsingException("Cannot deal with a FASTA alignment without any structural information");
            }
            catch (Exception e) {
                throw new FileParsingException(e);
            }
        }
    }

    public static void exportMoleculesAsFastaFile(File f, List<String> names, List<String> sequences) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(f);
        for (String sequence : sequences) {
            pw.println(">" + names.get(sequences.indexOf(sequence)));
            for (int c = 0; c < sequence.length(); c += 80) {
                int d = Math.min(sequence.length(), c + 80);
                pw.print(sequence.substring(c, d) + "\n");
            }
        }
        pw.close();
    }
}

