/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.apache.commons.io.FileUtils;

public class Client {
    private static final String urlBase = "http://paradise-ibmc.u-strasbg.fr/webservices/";

    public static void main(String[] args) throws IOException {
        new Client(args);
    }

    private Client(String[] args) throws IOException {
        StringBuffer parameters = new StringBuffer();
        String ws = null;
        String inputData = null;
        String server = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.split("=").length != 2) {
                System.err.println("\nWARNING: unknown option: " + arg);
                System.exit(-1);
            }
            if (arg.startsWith("ws=")) {
                ws = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith("data=")) {
                String rightPart = arg.split("=")[1];
                if ("-".equals(rightPart)) {
                    inputData = "-";
                    continue;
                }
                String[] file_names = rightPart.split(",");
                StringBuffer buff = new StringBuffer();
                for (int j = 0; j < file_names.length; ++j) {
                    String file_name = file_names[j];
                    File input = new File(file_name);
                    if (!input.exists()) {
                        System.err.println("\nWARNING: cannot find the input file " + file_name);
                        System.exit(-1);
                    }
                    buff.append(FileUtils.readFileToString((File)input));
                }
                inputData = buff.toString();
                continue;
            }
            if (arg.startsWith("server=")) {
                server = arg.split("=")[1];
                continue;
            }
            if (parameters.length() != 0) {
                parameters.append("&");
            }
            parameters.append(URLEncoder.encode(arg.split("=")[0], "UTF-8") + "=" + URLEncoder.encode(arg.split("=")[1], "UTF-8"));
        }
        if (ws == null) {
            this.printUsage();
            System.exit(-1);
        }
        if (inputData == null) {
            StringBuffer buff = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String str = in.readLine();
            while (str != null) {
                buff.append(str + "\n");
                str = in.readLine();
            }
            in.close();
            inputData = buff.toString();
        }
        if (parameters.length() != 0) {
            parameters.append("&");
        }
        if (!"-".equals(inputData)) {
            parameters.append(URLEncoder.encode("data", "UTF-8") + "=" + URLEncoder.encode(inputData, "UTF-8"));
        }
        URL url = null;
        try {
            url = new URL((server == null ? urlBase : server) + ws);
        }
        catch (MalformedURLException e) {
            System.err.println("WARNING: this address is not valid " + (server == null ? urlBase : server) + ws);
            System.exit(-1);
        }
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(parameters.toString());
        wr.flush();
        BufferedReader rd = null;
        try {
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        }
        catch (FileNotFoundException e) {
            System.err.println("\nWARNING: problem to connect " + (server == null ? urlBase : server) + ws);
            System.exit(-1);
        }
        String line = null;
        while ((line = rd.readLine()) != null) {
            System.out.println(line);
        }
        wr.close();
        rd.close();
    }

    private void printUsage() {
        System.out.println("\"Simple Java Client to consume RNA WebServices\"\n");
        System.out.println("Usage: java -jar client.jar ws=webservice_name data=input_data algorithm_parameter1=value1 algorithm_parameter2=value2 ....\n");
        System.out.println("Online Documentation: http://paradise-ibmc.u-strasbg.fr/");
        System.out.println("Contact: f.jossinet@ibmc.u-strasbg.fr");
    }
}

