/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.utils;

import fr.unistra.ibmc.paradise.core.utils.FileFormattingException;
import fr.unistra.ibmc.paradise.core.utils.PDB;
import fr.unistra.ibmc.paradise.core.utils.Parser;
import fr.unistra.ibmc.paradise.core.utils.ParsingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class HD {
    public int atomNumber;
    public char residueName;
    public int residueNumber;
    public String atomName;
    public int atomCode;
    public float x;
    public float y;
    public float z;
    public float b;
    public float q = 0.0f;

    public HD(int atomNum, char residueType, int residueNum, String atomType, float mx, float my, float mz, float mb) {
        this.atomNumber = atomNum;
        this.residueName = residueType;
        this.residueNumber = residueNum;
        this.atomName = atomType;
        this.x = mx;
        this.y = my;
        this.z = mz;
        this.b = mb;
    }

    public HD(int atomNum, char residueType, int residueNum, String atomType, double mx, double my, double mz, double mb) {
        this.atomNumber = atomNum;
        this.residueName = residueType;
        this.residueNumber = residueNum;
        this.atomName = atomType;
        this.x = (float)mx;
        this.y = (float)my;
        this.z = (float)mz;
        this.b = (float)mb;
    }

    public HD(String line) throws ParsingException {
        this.atomNumber = Parser.parseInt(line.substring(0, 6).replaceAll(" ", ""));
        this.residueName = line.charAt(7);
        this.residueNumber = Parser.parseInt(line.substring(8, 11).replaceAll(" ", ""));
        this.atomName = line.substring(11, 15).replaceAll(" ", "");
        this.atomCode = HD.atomCode(this.atomName);
        this.x = Parser.parseFloat(line.substring(18, 28).replaceAll(" ", ""));
        this.y = Parser.parseFloat(line.substring(28, 38).replaceAll(" ", ""));
        this.z = Parser.parseFloat(line.substring(38, 48).replaceAll(" ", ""));
        this.b = Parser.parseFloat(line.substring(48, 58).replaceAll(" ", ""));
        this.q = line.length() < 68 ? 0.0f : Parser.parseFloat(line.substring(58, 68).replaceAll(" ", ""));
    }

    private static String atomSerialNumber(int nb) throws FileFormattingException {
        String ret = nb + "";
        while (ret.length() < 5) {
            ret = " " + ret;
        }
        if (ret.length() != 5) {
            throw new FileFormattingException("inapropriate string length while formatting the text");
        }
        return ret;
    }

    private static String atomName(String name) throws FileFormattingException {
        String ret = name;
        while (ret.length() < 5) {
            ret = ret + " ";
        }
        if (ret.length() != 5) {
            throw new FileFormattingException("inapropriate string length while formatting the text");
        }
        return ret;
    }

    private static String residueSequenceNumber(int num) throws FileFormattingException {
        String ret = num + "";
        while (ret.length() < 3) {
            ret = " " + ret;
        }
        if (ret.length() != 3) {
            throw new FileFormattingException("inapropriate string length while formatting the text");
        }
        return ret;
    }

    private static String coord(float f) throws ParsingException {
        String ret = "";
        try {
            String fl = f + "";
            if (fl.indexOf("E") != -1) {
                String nb = fl.substring(0, fl.indexOf("E"));
                int mult = Parser.parseInt(fl.substring(fl.indexOf("E") + 1));
                if (mult < -3) {
                    ret = "    0.0000";
                } else if (mult > 4) {
                    ret = "99999.9999";
                    throw new FileFormattingException("in HD.coord(" + f + ") the number exceeds 99999.9999");
                }
            } else {
                int p = fl.indexOf(".");
                if (p == -1) {
                    throw new FileFormattingException("in HD.coord() no '.' in : " + fl);
                }
                String head = fl.substring(0, p);
                String queue = fl.substring(p);
                if (queue.length() > 5 && Parser.parseInt(queue.charAt(5) + "") > 4) {
                    fl = f > 0.0f ? f + 1.0E-4f + "" : f - 1.0E-4f + "";
                    head = fl.substring(0, p);
                    queue = fl.substring(p);
                }
                while (queue.length() < 5) {
                    queue = queue + "0";
                }
                while (head.length() < 5) {
                    head = " " + head;
                }
                ret = head + queue.substring(0, 5);
            }
            if (ret.length() != 10) {
                throw new FileFormattingException("in HD.coord(" + f + ") : inapropriate string length while formatting the text");
            }
        }
        catch (FileFormattingException e) {
            throw new ParsingException(e);
        }
        return ret;
    }

    private static int atomCode(String s) {
        for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case 'C': 
                case 'M': {
                    return 1;
                }
                case 'N': {
                    return 2;
                }
                case 'O': {
                    return 3;
                }
                case 'P': {
                    return 4;
                }
            }
        }
        return 0;
    }

    public static String getAtomString(int atomNumber, char residueType, int residueNumber, String atomType, float x, float y, float z, float b, float q) throws ParsingException {
        try {
            String anum = HD.atomSerialNumber(atomNumber);
            String rnum = HD.residueSequenceNumber(residueNumber);
            String atyp = HD.atomName(atomType);
            int acod = HD.atomCode(atomType);
            String mx = HD.coord(x);
            String my = HD.coord(y);
            String mz = HD.coord(z);
            String mb = HD.coord(b);
            String mq = HD.coord(q);
            return "" + anum + "  " + residueType + rnum + atyp + " " + acod + mx + my + mz + mb + mq;
        }
        catch (Exception e) {
            throw new ParsingException("Cannot parse atom-string", e);
        }
    }

    public static String getAtomString(int atomNumber, char residueType, int residueNumber, String atomType, double x, double y, double z, double b, double q) throws ParsingException {
        return HD.getAtomString(atomNumber, residueType, residueNumber, atomType, (float)x, (float)y, (float)z, (float)b, (float)q);
    }

    public static String getAtomString(int atomNumber, char residueType, int residueNumber, String atomType, int atomCode, double x, double y, double z, double b, double q) throws ParsingException {
        try {
            String anum = HD.atomSerialNumber(atomNumber);
            String rnum = HD.residueSequenceNumber(residueNumber);
            String atyp = HD.atomName(atomType);
            String mx = HD.coord((float)x);
            String my = HD.coord((float)y);
            String mz = HD.coord((float)z);
            String mb = HD.coord((float)b);
            String mq = HD.coord((float)q);
            return "" + anum + "  " + residueType + rnum + atyp + " " + atomCode + mx + my + mz + mb + mq;
        }
        catch (Exception e) {
            throw new ParsingException("Cannot parse atom-string", e);
        }
    }

    public String getAtomString() throws ParsingException {
        try {
            String anum = HD.atomSerialNumber(this.atomNumber);
            String rnum = HD.residueSequenceNumber(this.residueNumber);
            String atyp = HD.atomName(this.atomName);
            int acod = HD.atomCode(this.atomName);
            String mx = HD.coord(this.x);
            String my = HD.coord(this.y);
            String mz = HD.coord(this.z);
            String mb = HD.coord(this.b);
            String mq = HD.coord(this.q);
            return "" + anum + "  " + this.residueName + rnum + atyp + " " + acod + mx + my + mz + mb + mq;
        }
        catch (Exception e) {
            throw new ParsingException("Cannot parse atom-string", e);
        }
    }

    public static void convertPDBasHD(File HDFile, File PDBFile) throws ParsingException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(PDBFile));
            PrintWriter out = new PrintWriter(new FileWriter(HDFile));
            while ((line = in.readLine()) != null) {
                if (!line.startsWith("ATOM")) continue;
                PDB pdb = new PDB(line);
                out.println(HD.getAtomString(pdb.atomNumber, pdb.residueName.charAt(0), pdb.residueNumber, pdb.atomName.replace('*', '\''), pdb.x, pdb.y, pdb.z, pdb.b, pdb.q));
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new ParsingException("IO problem while converting PDB to HD", e);
        }
    }
}

