/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.utils;

import fr.unistra.ibmc.paradise.core.utils.Printing;
import fr.unistra.ibmc.paradise.core.utils.matrix.Matrix;

public class TBMath {
    public static double DegreeToRadian = Math.PI / 180;
    public static double RadianToDegree = 57.29577951308232;

    public static float norm(float[] v) {
        float s = 0.0f;
        for (int i = 0; i < v.length; ++i) {
            s += v[i] * v[i];
        }
        return (float)Math.sqrt(s);
    }

    public static boolean isNumber(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == '-' || c == '.') continue;
            return false;
        }
        return true;
    }

    public static float[] middle(float[] a, float[] b) {
        if (a.length == b.length) {
            float[] ret = new float[a.length];
            for (int i = 0; i < a.length; ++i) {
                ret[i] = (a[i] + b[i]) / 2.0f;
            }
            return ret;
        }
        Printing.warning("length of vector mismatch");
        return null;
    }

    public static double norm(double[] v) {
        double s = 0.0;
        for (int i = 0; i < v.length; ++i) {
            s += v[i] * v[i];
        }
        return Math.sqrt(s);
    }

    public static float distance(float[] a, float[] b) {
        if (a.length != b.length) {
            Printing.warning("TBMath.distance(a,b) size of vectors mismatch");
            return Float.MAX_VALUE;
        }
        float s = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            s += (a[i] - b[i]) * (a[i] - b[i]);
        }
        float ret = (float)Math.sqrt(s);
        return ret;
    }

    public static double distance(double[] a, double[] b) {
        if (a.length != b.length) {
            Printing.warning("TBMath.distance(a,b) size of vectors mismatch");
            return Double.MAX_VALUE;
        }
        double s = 0.0;
        for (int i = 0; i < a.length; ++i) {
            s += (a[i] - b[i]) * (a[i] - b[i]);
        }
        double ret = Math.sqrt(s);
        return ret;
    }

    public static void normalize(float[] v) {
        float n = TBMath.norm(v);
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] / n;
        }
    }

    public static void normalize(double[] v) {
        double n = TBMath.norm(v);
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] / n;
        }
    }

    public static float[] normalized(float[] v) {
        float[] ret = new float[v.length];
        float n = TBMath.norm(v);
        for (int i = 0; i < v.length; ++i) {
            ret[i] = v[i] / n;
        }
        return ret;
    }

    public static double[] normalized(double[] v) {
        double[] ret = new double[v.length];
        double n = TBMath.norm(v);
        for (int i = 0; i < v.length; ++i) {
            ret[i] = v[i] / n;
        }
        return ret;
    }

    public static float[] multiMatrixVector(float[] m, float[] v) {
        if (v.length == 3) {
            if (m.length == 9) {
                return TBMath.m9m3v(m, v);
            }
            Printing.warning("Matrix and vetor size mismatch");
            return null;
        }
        if (v.length == 4) {
            if (m.length == 16) {
                return TBMath.m16m4v(m, v);
            }
            Printing.warning("Matrix and vetor size mismatch");
            return null;
        }
        Printing.warning("Excpeting vector of 3 or 4 elements");
        return null;
    }

    public static float[] multiMatrixVector(float[][] m, float[] v) {
        if (v.length == 3) {
            if (m.length == 3 && m[0].length == 3) {
                return TBMath.m33m3v(m, v);
            }
            Printing.warning("Matrix and vetor size mismatch");
            return null;
        }
        if (v.length == 4) {
            if (m.length == 4 && m[0].length == 4) {
                return TBMath.m44m4v(m, v);
            }
            Printing.warning("Matrix and vetor size mismatch");
            return null;
        }
        Printing.warning("Excpeting vector of 3 or 4 elements");
        return null;
    }

    private static float[] m9m3v(float[] m, float[] v) {
        float[] ret = new float[]{m[0] * v[0] + m[1] * v[1] + m[2] * v[2], m[3] * v[0] + m[4] * v[1] + m[5] * v[2], m[6] * v[0] + m[7] * v[1] + m[8] * v[2]};
        return ret;
    }

    private static float[] m16m4v(float[] m, float[] v) {
        float[] ret = new float[]{m[0] * v[0] + m[1] * v[1] + m[2] * v[2] + m[3] * v[3], m[4] * v[0] + m[5] * v[1] + m[6] * v[2] + m[7] * v[3], m[8] * v[0] + m[9] * v[1] + m[10] * v[2] + m[11] * v[3], m[12] * v[0] + m[13] * v[1] + m[14] * v[2] + m[15] * v[3]};
        return ret;
    }

    private static float[] m33m3v(float[][] m, float[] v) {
        float[] ret = new float[]{m[0][0] * v[0] + m[0][1] * v[1] + m[0][2] * v[2], m[1][0] * v[0] + m[1][1] * v[1] + m[1][2] * v[2], m[2][0] * v[0] + m[2][1] * v[1] + m[2][2] * v[2]};
        return ret;
    }

    private static float[] m44m4v(float[][] m, float[] v) {
        float[] ret = new float[]{m[0][0] * v[0] + m[0][1] * v[1] + m[0][2] * v[2] + m[0][3] * v[3], m[1][0] * v[0] + m[1][1] * v[1] + m[1][2] * v[2] + m[1][3] * v[3], m[2][0] * v[0] + m[2][1] * v[1] + m[2][2] * v[2] + m[2][3] * v[3], m[3][0] * v[0] + m[3][1] * v[1] + m[3][2] * v[2] + m[3][3] * v[3]};
        return ret;
    }

    public static void crossProduct(double[] b, double[] c, double[] a) {
        a[0] = b[1] * c[2] - b[2] * c[1];
        a[1] = b[2] * c[0] - b[0] * c[2];
        a[2] = b[0] * c[1] - b[1] * c[0];
    }

    public static double[] crossProduct(double[] b, double[] c) {
        double[] a = new double[b.length];
        TBMath.crossProduct(b, c, a);
        return a;
    }

    public static void crossProduct(float[] b, float[] c, float[] a) {
        a[0] = b[1] * c[2] - b[2] * c[1];
        a[1] = b[2] * c[0] - b[0] * c[2];
        a[2] = b[0] * c[1] - b[1] * c[0];
    }

    public static float[] crossProduct(float[] b, float[] c) {
        float[] a = new float[b.length];
        TBMath.crossProduct(b, c, a);
        return a;
    }

    public static double torsx(double[] x1, double[] x2, double[] x3, double[] x4) {
        double[] u1 = new double[3];
        double[] u2 = new double[3];
        double[] u3 = new double[3];
        double[] uu = new double[3];
        double[] vv = new double[3];
        for (int i = 0; i < 3; ++i) {
            u1[i] = x3[i] - x2[i];
            u2[i] = x1[i] - x2[i];
            u3[i] = x4[i] - x3[i];
        }
        TBMath.crossProduct(u1, u2, uu);
        TBMath.crossProduct(u1, u3, vv);
        TBMath.normalize(uu);
        TBMath.normalize(vv);
        double ecos = 0.0;
        for (int i = 0; i < 3; ++i) {
            ecos += uu[i] * vv[i];
        }
        TBMath.crossProduct(uu, vv, u2);
        double esin = 0.0;
        for (int i = 0; i < 3; ++i) {
            esin += u2[i] * u2[i];
        }
        esin = Math.sqrt(esin);
        double sum = 0.0;
        for (int i = 0; i < 3; ++i) {
            sum += u1[i] * u2[i];
        }
        esin = sum >= 0.0 ? Math.abs(esin) : -Math.abs(esin);
        double the = Math.atan2(esin, ecos) * 180.0 / Math.PI;
        if (the > 180.0) {
            the -= 360.0;
        }
        return the;
    }

    public static void singleToDouble(double[] in, double[][] ret) {
        int t = ret.length;
        for (int i = 0; i < in.length; ++i) {
            int x = i / t;
            int y = i % t;
            ret[x][y] = in[i];
        }
    }

    public static void DoubleToSingle(double[][] in, double[] ret) {
        int n = in.length;
        int a = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                ret[a] = in[i][j];
                ++a;
            }
        }
    }

    public static int endOfInt(String s) {
        char c;
        int ret = -1;
        for (int i = 0; i < s.length() && ((c = s.charAt(i)) == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9'); ++i) {
            ++ret;
        }
        return ret;
    }

    public static double sign(double valueOf, double signOf) {
        if (signOf > 0.0) {
            return Math.abs(valueOf);
        }
        return -Math.abs(valueOf);
    }

    public static float angle(float[] v1, float[] v2) {
        float ret = TBMath.dotProduct(v1, v2) / TBMath.norm(v1) / TBMath.norm(v2);
        if (ret < -1.0f) {
            ret = -1.0f;
        }
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return (float)Math.acos(ret);
    }

    public static float dihedral(float[] a, float[] b, float[] c, float[] d) {
        float[] v1 = TBMath.vector(a, b);
        float[] v2 = TBMath.vector(b, c);
        float[] v3 = TBMath.vector(c, d);
        float[] w1 = TBMath.crossProduct(v1, v2);
        float[] w2 = TBMath.crossProduct(v2, v3);
        float[] w = TBMath.crossProduct(w1, w2);
        float arg = TBMath.dotProduct(w1, w2) / TBMath.norm(w1) / TBMath.norm(w2);
        if (arg > 1.0f) {
            arg = 1.0f;
        }
        if (arg < -1.0f) {
            arg = -1.0f;
        }
        float ret = (float)Math.acos(arg);
        if (TBMath.dotProduct(v2, w) > 0.0f) {
            return ret;
        }
        return -ret;
    }

    public static float[] vector(float[] a, float[] b) {
        float[] ret = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = b[i] - a[i];
        }
        return ret;
    }

    public static double[] vector(double[] a, double[] b) {
        double[] ret = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = b[i] - a[i];
        }
        return ret;
    }

    public static float dotProduct(float[] v1, float[] v2) {
        float ret = 0.0f;
        for (int i = 0; i < v1.length; ++i) {
            ret += v1[i] * v2[i];
        }
        return ret;
    }

    public static double dotProduct(double[] v1, double[] v2) {
        double ret = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            ret += v1[i] * v2[i];
        }
        return ret;
    }

    public static float[] rotateVector(float[] coord, float[] rotation, float angle) {
        float[] ret = new float[3];
        float ang = angle * (float)Math.PI / 180.0f;
        float x = rotation[0];
        float y = rotation[1];
        float z = rotation[2];
        float c = 1.0f - (float)Math.cos(ang);
        float s = (float)Math.sin(ang);
        float[][] matrix = new float[][]{{1.0f + c * (x * x - 1.0f), -z * s + c * x * y, y * s + c * x * z}, {z * s + c * x * y, 1.0f + c * (y * y - 1.0f), -x * s + c * y * z}, {-y * s + c * x * z, x * s + c * y * z, 1.0f + c * (z * z - 1.0f)}};
        ret[0] = matrix[0][0] * coord[0] + matrix[1][0] * coord[1] + matrix[2][0] * coord[2];
        ret[1] = matrix[0][1] * coord[0] + matrix[1][1] * coord[1] + matrix[2][1] * coord[2];
        ret[2] = matrix[0][2] * coord[0] + matrix[1][2] * coord[1] + matrix[2][2] * coord[2];
        return ret;
    }

    public static float[] multMatrices44(float[] a, float[] b) {
        float[] c = new float[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                c[TBMath.pos((int)i, (int)j)] = a[TBMath.pos(i, 0)] * b[TBMath.pos(0, j)] + a[TBMath.pos(i, 1)] * b[TBMath.pos(1, j)] + a[TBMath.pos(i, 2)] * b[TBMath.pos(2, j)] + a[TBMath.pos(i, 3)] * b[TBMath.pos(3, j)];
            }
        }
        return c;
    }

    public static float[][] times(float[][] a, float[][] b) {
        int m = a.length;
        float[][] c = new float[m][m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                c[i][j] = 0.0f;
                for (int k = 0; k < m; ++k) {
                    float[] fArray = c[i];
                    int n = j;
                    fArray[n] = fArray[n] + a[i][k] * b[k][j];
                }
            }
        }
        return c;
    }

    public static double[][] doubleFromFloat(float[][] f) {
        double[][] d = new double[f.length][f[0].length];
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[i].length; ++j) {
                d[i][j] = f[i][j];
            }
        }
        return d;
    }

    public static float[][] floatFromDouble(double[][] d) {
        float[][] f = new float[d.length][d[0].length];
        for (int i = 0; i < f.length; ++i) {
            for (int j = 0; j < f[i].length; ++j) {
                f[i][j] = (float)d[i][j];
            }
        }
        return f;
    }

    public static float[][] negate(float[][] m) {
        float[][] f = new float[m.length][m[0].length];
        for (int i = 0; i < f.length; ++i) {
            for (int j = 0; j < f[i].length; ++j) {
                f[i][j] = -m[i][j];
            }
        }
        return f;
    }

    public static float[][] inverse(float[][] m) {
        Matrix mat = new Matrix(TBMath.doubleFromFloat(m));
        return TBMath.floatFromDouble(mat.inverse().getArray());
    }

    public static int pos(int i, int j) {
        return i * 4 + j;
    }

    public static float[][] multiMatrices33(float[][] a, float[][] b) {
        float[][] c = new float[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                c[i][j] = a[i][0] * b[0][j] + a[i][1] * b[1][j] + a[i][2] * b[2][j];
            }
        }
        return c;
    }

    public static float[][] inverseMatrix33(float[][] a) {
        float[][] c = new float[3][3];
        float d = TBMath.detMatrix33(a);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                c[i][j] = TBMath.detMatrix33(a, j, i) / d;
            }
        }
        return c;
    }

    public static float detMatrix33(float[][] a) {
        return a[0][0] * a[1][1] * a[2][2] - a[0][0] * a[1][2] * a[2][1] + a[0][1] * a[1][2] * a[2][0] - a[0][1] * a[1][0] * a[2][2] + a[0][2] * a[1][0] * a[2][1] - a[0][2] * a[1][1] * a[2][0];
    }

    public static float detMatrix33(float[][] m, int i, int j) {
        int l1 = (i + 1) % 3;
        int l2 = (i + 2) % 3;
        int c1 = (j + 1) % 3;
        int c2 = (j + 2) % 3;
        return m[l1][c1] * m[l2][c2] - m[l1][c2] * m[l2][c1];
    }

    public static float[] getRotationMatrix(float[] vect, float angle) {
        float[] v = TBMath.normalized(vect);
        float[] ret = new float[9];
        float x = v[0];
        float y = v[1];
        float z = v[2];
        float ca = (float)Math.cos(angle);
        float sa = (float)Math.sin(angle);
        float mca = 1.0f - ca;
        ret[0] = 1.0f + mca * (x * x - 1.0f);
        ret[1] = -z * sa + mca * x * y;
        ret[2] = y * sa + mca * x * z;
        ret[3] = z * sa + mca * x * y;
        ret[4] = 1.0f + mca * (y * y - 1.0f);
        ret[5] = -x * sa + mca * y * z;
        ret[6] = -y * sa + mca * x * z;
        ret[7] = x * sa + mca * y * z;
        ret[8] = 1.0f + mca * (z * z - 1.0f);
        System.out.println("somme " + (ret[0] + ret[4] + ret[8]));
        System.out.println("out " + (1.0 + 2.0 * Math.cos(angle)));
        return ret;
    }

    public static float[] multVectorScalar(float[] vector, float scalar) {
        float[] ret = new float[vector.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = scalar * vector[i];
        }
        return ret;
    }

    public static float[] sumVectors(float[] vector1, float[] vector2) {
        if (vector1.length != vector2.length) {
            return null;
        }
        float[] ret = new float[vector1.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = vector1[i] + vector2[i];
        }
        return ret;
    }

    public static int lineIntersectsCircle(float[] x, float[] y, float[] c, float r) {
        float D;
        float[] a = new float[]{x[0] - c[0], x[1] - c[1]};
        float[] fArray = new float[]{y[0] - c[0], y[1] - c[1]};
        float[] b = fArray;
        float d = (float)Math.sqrt((b[0] - a[0]) * (b[0] - a[0]) + (b[1] - a[1]) * (b[1] - a[1]));
        float delta = r * r + d * d - (D = a[0] * b[1] - b[0] * a[1]) * D;
        if (delta < 0.0f) {
            return 0;
        }
        if (delta == 0.0f) {
            return 1;
        }
        return 2;
    }

    public static boolean planeIntersectsSphere(float[] o, float[] a, float[] b, float[] c, float r) {
        float d;
        float[] ob;
        float[] oa = TBMath.vector(o, a);
        float[] n = TBMath.normalized(TBMath.crossProduct(oa, ob = TBMath.vector(o, b)));
        float dist = n[0] * c[0] + n[1] * c[1] + n[2] * c[2] + (d = -TBMath.dotProduct(n, o));
        return dist < r;
    }

    public static boolean lineIntersectsSphere(float[] a, float[] b, float[] c, float r) {
        float[] ab = TBMath.vector(a, b);
        float dist = TBMath.norm(TBMath.crossProduct(ab, TBMath.vector(c, a))) / TBMath.norm(ab);
        return dist < r;
    }

    public static Matrix getTransformationMatrix(float[] s1, float[] d1, float[] s2, float[] d2, float[] s3, float[] d3, float[] s4, float[] d4) {
        double[][] mr = new double[][]{{s1[0], s2[0], s3[0], s4[0]}, {s1[1], s2[1], s3[1], s4[1]}, {s1[2], s2[2], s3[2], s4[2]}, {1.0, 1.0, 1.0, 1.0}};
        double[][] mo = new double[][]{{d1[0], d2[0], d3[0], d4[0]}, {d1[1], d2[1], d3[1], d4[1]}, {d1[2], d2[2], d3[2], d4[2]}, {1.0, 1.0, 1.0, 1.0}};
        Matrix r = new Matrix(mr);
        Matrix o = new Matrix(mo);
        return o.times(r.inverse());
    }
}

