/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis;

import fr.unistra.ibmc.paradise.core.analysis.Analysis;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.services.ParadisePlatform;
import fr.unistra.ibmc.paradise.services.ParadisePlatformAgent;
import fr.unistra.ibmc.paradise.services.analysis.CancelBehaviour;
import fr.unistra.ibmc.paradise.services.analysis.RequestBehaviour;
import fr.unistra.ibmc.paradise.services.analysis.SubscribeBehaviour;
import jade.core.behaviours.Behaviour;
import jade.wrapper.StaleProxyException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Priority;

public abstract class ParadiseAnalysisAgent
extends ParadisePlatformAgent {
    protected Map<String, Analysis> currentAnalysis = new HashMap<String, Analysis>();
    protected Parameters parameters = new Parameters();

    protected ParadiseAnalysisAgent(ParadisePlatform platform, Analysis analysis) throws StaleProxyException {
        super(platform, analysis.getDescription(), analysis.getCategories());
    }

    public Analysis getAnalysis(String conversationId) {
        return this.currentAnalysis.get(conversationId);
    }

    public void closeConversation(String conversationId) {
        this.writeLogMessage("Job finished", Priority.INFO, conversationId, this.getName(), null);
        this.currentAnalysis.remove(conversationId);
        this.getParadisePlatform().unregisterConversation(this.getLocalName(), conversationId);
    }

    public abstract Analysis addAnalysis(String var1);

    protected void setup() {
        super.setup();
        this.addBehaviour((Behaviour)new SubscribeBehaviour());
        this.addBehaviour((Behaviour)new CancelBehaviour());
        this.addBehaviour((Behaviour)new RequestBehaviour());
    }
}

