/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis;

import fr.unistra.ibmc.paradise.core.analysis.Analysis;
import fr.unistra.ibmc.paradise.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.services.analysis.ParadiseAnalysisAgent;
import jade.core.behaviours.CyclicBehaviour;
import jade.domain.FIPAAgentManagement.Property;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import jade.util.leap.Iterator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.Timer;
import org.apache.log4j.Priority;
import org.jdesktop.swingworker.SwingWorker;

public class RequestBehaviour
extends CyclicBehaviour {
    public void action() {
        block13: {
            final ACLMessage message = this.myAgent.receive(MessageTemplate.MatchPerformative((int)16));
            if (message != null) {
                final Analysis analysis = ((ParadiseAnalysisAgent)this.myAgent).getAnalysis(message.getConversationId());
                try {
                    if (analysis != null) {
                        ACLMessage reply;
                        Exception e;
                        ArrayList molecules;
                        ((ParadiseAnalysisAgent)this.myAgent).writeLogMessage("Received request from " + message.getSender(), Priority.INFO, message.getConversationId(), this.myAgent.getName(), null);
                        try {
                            molecules = (ArrayList)message.getContentObject();
                        }
                        catch (UnreadableException e2) {
                            e2.printStackTrace();
                            return;
                        }
                        final Parameters parameters = new Parameters();
                        Iterator properties = message.getEnvelope().getAllProperties();
                        while (properties.hasNext()) {
                            Property prop = (Property)properties.next();
                            if (!prop.getName().equals("parameters")) continue;
                            for (Parameter p : ((Parameters)prop.getValue()).getParameters()) {
                                parameters.addParameter(p);
                            }
                        }
                        if (molecules == null) {
                            e = new Exception("The server needs a list of molecules (even if empty)");
                            ((ParadiseAnalysisAgent)this.myAgent).writeLogMessage(e.getMessage(), Priority.ERROR, message.getConversationId(), this.myAgent.getName(), e);
                            reply = message.createReply();
                            reply.setContentObject((Serializable)e);
                            reply.setPerformative(6);
                            ((ParadiseAnalysisAgent)this.myAgent).closeConversation(message.getConversationId());
                            this.myAgent.send(reply);
                        } else if (parameters == null) {
                            e = new Exception("The server needs a list of parameters (even if empty)");
                            ((ParadiseAnalysisAgent)this.myAgent).writeLogMessage(e.getMessage(), Priority.ERROR, message.getConversationId(), this.myAgent.getName(), e);
                            reply = message.createReply();
                            reply.setContentObject((Serializable)e);
                            reply.setPerformative(6);
                            ((ParadiseAnalysisAgent)this.myAgent).closeConversation(message.getConversationId());
                            this.myAgent.send(reply);
                        } else {
                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            class AnalysisWorker
                            extends SwingWorker
                            implements ActionListener {
                                private String currentStatus = "";
                                private Timer timer;

                                AnalysisWorker() {
                                }

                                protected Object doInBackground() throws Exception {
                                    this.timer = new Timer(1, this);
                                    this.timer.start();
                                    try {
                                        analysis.run(molecules, parameters);
                                        if (!analysis.isCancelled()) {
                                            ACLMessage reply = message.createReply();
                                            reply.setPerformative(11);
                                            reply.setContentObject((Serializable)molecules);
                                            ((ParadiseAnalysisAgent)RequestBehaviour.this.myAgent).closeConversation(message.getConversationId());
                                            RequestBehaviour.this.myAgent.send(reply);
                                            this.timer.stop();
                                        }
                                    }
                                    catch (Exception e) {
                                        ((ParadiseAnalysisAgent)RequestBehaviour.this.myAgent).writeLogMessage(e.getMessage(), Priority.ERROR, message.getConversationId(), RequestBehaviour.this.myAgent.getName(), e);
                                        ACLMessage reply = message.createReply();
                                        reply.setContentObject((Serializable)e);
                                        reply.setPerformative(6);
                                        ((ParadiseAnalysisAgent)RequestBehaviour.this.myAgent).closeConversation(message.getConversationId());
                                        RequestBehaviour.this.myAgent.send(reply);
                                    }
                                    return null;
                                }

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (!analysis.isCancelled() && !this.currentStatus.equals(analysis.getStatus())) {
                                        this.currentStatus = analysis.getStatus();
                                        ACLMessage reply = message.createReply();
                                        reply.setPerformative(7);
                                        reply.setContent(this.currentStatus);
                                        RequestBehaviour.this.myAgent.send(reply);
                                    }
                                }
                            }
                            new AnalysisWorker().execute();
                        }
                        break block13;
                    }
                    ACLMessage reply = message.createReply();
                    Exception e = new Exception("Received request from " + message.getSender() + " but no registered Analysis found");
                    ((ParadiseAnalysisAgent)this.myAgent).writeLogMessage("Received request from " + message.getSender() + " but no registered Analysis found", Priority.ERROR, message.getConversationId(), this.myAgent.getName(), e);
                    reply.setContentObject((Serializable)e);
                    reply.setPerformative(6);
                    ((ParadiseAnalysisAgent)this.myAgent).closeConversation(message.getConversationId());
                    this.myAgent.send(reply);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            } else {
                this.block();
            }
        }
    }
}

