/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.AtomAtomInteraction;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.RiboNucleotide3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.core.utils.HD;
import fr.unistra.ibmc.paradise.core.utils.NumberFormat;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.NucMult;
import fr.unistra.ibmc.paradise.tools.Paradise;
import fr.unistra.ibmc.paradise.tools.component.DefaultProgressMonitor;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBMCRnartAnalysis
extends AbstractAnalysis {
    public static final String MODE_PARAMETER_NAME = "mode";
    public static final String THRESHOLD_PARAMETER_NAME = "threshold";
    private List<Molecule> molecules;
    private Map<Integer, RiboNucleotide3D> all3DNucleotides;
    private SecondaryStructure ss = null;
    private TertiaryStructure ts = null;

    protected IBMCRnartAnalysis(MoleculeFactory factory) {
        super("Rnart (PARADISE Server)", factory);
        this.addCategory("3D refinement");
        this.addParadiseFeatureFactory(this.createStructuralFeatureFactory());
    }

    @Override
    public void run(List<Molecule> molecules, Parameters parameters) throws AnalysisException, NoSolutionException {
        this.molecules = molecules;
        try {
            File rnartDir = new File(Paradise.getTmpDirectory(), "rnart" + System.nanoTime());
            rnartDir.mkdir();
            File globalPDB = new File(rnartDir, "GLOBAL.PDB");
            File atomFile = new File(rnartDir, "ATOMS.DAT");
            File nuclinFile = new File(rnartDir, "NUCLIN.DAT");
            File hbndFile = new File(rnartDir, "HBND.DAT");
            String mode = null;
            String threshold = null;
            if (parameters != null) {
                for (Parameter param : parameters.getParameters()) {
                    if (param.getName().equals(MODE_PARAMETER_NAME)) {
                        mode = param.getValue();
                    }
                    if (!param.getName().equals(THRESHOLD_PARAMETER_NAME)) continue;
                    threshold = param.getValue();
                }
            }
            if (mode == null) {
                throw new AnalysisException("The mode parameter is null");
            }
            if (threshold == null) {
                throw new AnalysisException("The threshold parameter is null");
            }
            if (molecules.size() > 0) {
                this.ts = molecules.get(0).getSelectedFeatures(TertiaryStructure.class).get(0);
                this.ss = molecules.get(0).getSelectedFeatures(SecondaryStructure.class).get(0);
                this.all3DNucleotides = this.sortNucleotides();
                ArrayList<String> _3dMolecules = new ArrayList<String>();
                this.status = "Writing GLOBAL.PDB";
                ArrayList<Residue3D> residues = new ArrayList<Residue3D>(this.all3DNucleotides.size());
                Molecule currentMolecule = null;
                int currentPosition = -1;
                StringBuffer currentSequence = null;
                for (int i = 1; i <= this.all3DNucleotides.size(); ++i) {
                    Residue3D r = this.all3DNucleotides.get(i);
                    residues.add(r);
                    Molecule _m = r.getMolecules().iterator().next();
                    int position = r.getAnnotations().iterator().next().getLocation().getStart();
                    if (!((Object)_m).equals(currentMolecule) || currentPosition != position - 1) {
                        if (currentSequence != null) {
                            _3dMolecules.add(currentSequence.toString());
                        }
                        currentSequence = new StringBuffer();
                    }
                    currentMolecule = _m;
                    currentPosition = position;
                    currentSequence.append(r.getName().charAt(0));
                }
                if (currentSequence != null) {
                    _3dMolecules.add(currentSequence.toString());
                }
                PDBFileIO.writePDBFile(residues, true, globalPDB);
                this.status = "Writing NUCLIN.DAT";
                String nuclindat = "";
                nuclindat = nuclindat + "Rnart Service\n\n";
                nuclindat = nuclindat + this.mergeMolecules(_3dMolecules) + "\n";
                nuclindat = nuclindat + "    3\n";
                String tmp = "";
                nuclindat = nuclindat + "\nMODEL\n    0    2    0    0    0\n    4   " + this.all3DNucleotides.size() + "\n";
                List<Integer> sugars = this.getSugars();
                for (int i = 0; i < sugars.size(); ++i) {
                    tmp = tmp + " " + sugars.get(i);
                    if (i % 35 != 34) continue;
                    nuclindat = nuclindat + tmp + "\n";
                    tmp = "";
                }
                if (!tmp.equals("")) {
                    nuclindat = nuclindat + tmp + "\n";
                }
                PrintWriter out = new PrintWriter(new FileWriter(nuclinFile));
                out.print(nuclindat);
                out.flush();
                out.close();
                this.status = "Writing HBND.DAT";
                String hbnddat = "";
                List<String> hbndLines = this.getHbndLines();
                for (String hbndline : hbndLines) {
                    hbnddat = hbnddat + hbndline + "\n";
                }
                out = new PrintWriter(new FileWriter(hbndFile));
                out.print(hbnddat);
                out.flush();
                out.close();
                this.status = "Writing ATOMS.DAT";
                HD.convertPDBasHD(atomFile, globalPDB);
                this.status = "Calling NUCMULT";
                NucMult nm = new NucMult(this, mode, threshold, rnartDir.getAbsolutePath() + System.getProperty("file.separator"));
                int pass = nm.getNumberOfPass();
                String p = pass + "";
                if (pass < 10) {
                    p = "0" + p;
                }
                File f = new File(rnartDir, "ATOMS_" + p + ".hd.pdb");
                PDBFileIO reader = new PDBFileIO(this.getMoleculeFactory());
                reader.parseFile(f, new DefaultProgressMonitor());
                Molecule resultMolecule = reader.getMolecules().get(0);
                for (Molecule molecule : molecules) {
                    molecule.removeAllSelectedFeatures();
                }
                for (Molecule.Annotation annotation : resultMolecule.getAnnotations(Residue3D.class)) {
                    Residue3D rnartR = (Residue3D)annotation.getFeature();
                    Residue3D localR = this.all3DNucleotides.get(Integer.parseInt(rnartR.getLabel()));
                    if (localR != null) {
                        for (Residue3D.Atom rnartA : rnartR.getAtoms()) {
                            if (!rnartA.hasCoordinatesFilled()) continue;
                            Residue3D.Atom localA = localR.getAtom(rnartA.getName());
                            localA.setCoordinates(rnartA.getX(), rnartA.getY(), rnartA.getZ());
                        }
                        localR.getAnnotations().get(0).getMolecule().addSelectedFeature(localR);
                        continue;
                    }
                    System.err.println("Warning : No residue find with label " + rnartR.getLabel());
                }
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }

    private String mergeMolecules(List<String> molecules) {
        StringBuffer out = new StringBuffer();
        for (String m : molecules) {
            if (m.length() <= 0) continue;
            out.append(m.charAt(0));
            int line = 1;
            for (int i = 1; i < m.length(); ++i) {
                out.append(m.charAt(i));
                if (++line != 70 || i >= m.length() - 1) continue;
                line = 0;
                out.append("-\n");
            }
            out.append("\n");
        }
        return out.toString();
    }

    List<Integer> order(Set<Integer> set) {
        ArrayList<Integer> list = new ArrayList<Integer>(set.size());
        for (int v : set) {
            boolean last = true;
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if (v >= i) continue;
                last = false;
                list.add(list.indexOf(i), v);
                break;
            }
            if (!last) continue;
            list.add(v);
        }
        return list;
    }

    List<Integer> getSugars() throws AnalysisException {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Integer key : this.order(this.all3DNucleotides.keySet())) {
            ret.add(this.all3DNucleotides.get(key).getSugarPucker());
        }
        return ret;
    }

    List<String> getHbndLines() throws AnalysisException {
        ArrayList<String> ret = new ArrayList<String>();
        for (AtomAtomInteraction iaai : this.ss.getSubFeaturesRecursively(AtomAtomInteraction.class)) {
            double maxDist = 0.0;
            double minDist = 0.0;
            switch (iaai.getInteractionType()) {
                case 'H': {
                    minDist = 2.7f;
                    maxDist = 3.1f;
                    break;
                }
                case 'C': {
                    minDist = 2.8f;
                    maxDist = 4.0;
                    break;
                }
                case 'W': {
                    minDist = 3.3f;
                    maxDist = 5.0;
                    break;
                }
                case 'M': {
                    minDist = 1.8f;
                    maxDist = 2.2f;
                    break;
                }
                case 'N': {
                    minDist = 3.0;
                    maxDist = 3.5;
                }
            }
            Iterator<Residue> it = iaai.getResidues().iterator();
            Residue _r1 = it.next();
            Residue _r2 = it.next();
            Residue3D r1 = this.ts.getResidue3DAt(_r1.getAbsolutePosition(), _r1.getMolecule());
            Residue3D r2 = this.ts.getResidue3DAt(_r2.getAbsolutePosition(), _r2.getMolecule());
            if (r1 == null || r2 == null) continue;
            String fNName = "   " + r1.getName().charAt(0);
            String fNNum = NumberFormat.intFormat(Integer.parseInt(r1.getLabel()), 3);
            String fAName = null;
            fAName = iaai.getResidue1().getSymbol() == r1.getName().charAt(0) ? iaai.getAtom1() : iaai.getAtom2();
            while (fAName.length() < 4) {
                fAName = fAName + " ";
            }
            String sNName = " " + r2.getName().charAt(0);
            String sNNum = NumberFormat.intFormat(Integer.parseInt(r2.getLabel()), 3);
            String sAName = null;
            sAName = iaai.getResidue1().getSymbol() == r2.getName().charAt(0) ? iaai.getAtom1() : iaai.getAtom2();
            while (sAName.length() < 4) {
                sAName = sAName + " ";
            }
            String min = NumberFormat.doubleFormat(minDist, 6, 1);
            String max = "   " + NumberFormat.doubleFormat(maxDist, 6, 1);
            ret.add(fNName + fNNum + fAName + sNName + sNNum + sAName + min + max);
        }
        return ret;
    }

    private Map<Integer, RiboNucleotide3D> sortNucleotides() throws AnalysisException {
        HashMap<Integer, RiboNucleotide3D> ret = new HashMap<Integer, RiboNucleotide3D>();
        HashMap lists = new HashMap();
        for (Molecule molecule : this.molecules) {
            lists.put(molecule, new ArrayList());
        }
        for (Residue3D res : this.ts.getResidues3D()) {
            if (!(res instanceof RiboNucleotide3D)) continue;
            Molecule.Annotation a = res.getAnnotations().get(0);
            this.addSorted((RiboNucleotide3D)res, (List)lists.get(a.getMolecule()));
        }
        int id = 1;
        for (Molecule molecule : this.molecules) {
            for (RiboNucleotide3D res : (List)lists.get(molecule)) {
                Molecule.Annotation a = res.getAnnotations().get(0);
                this.ts.addResidueLabel("" + id, a.getLocation().getStart(), a.getMolecule());
                ret.put(id, res);
                ++id;
            }
        }
        return ret;
    }

    private void addSorted(RiboNucleotide3D res, List<RiboNucleotide3D> list) throws AnalysisException {
        for (RiboNucleotide3D lr : list) {
            if (this.getNumerotationFor(res) >= this.getNumerotationFor(lr)) continue;
            list.add(list.indexOf(lr), res);
            return;
        }
        list.add(res);
    }

    private int getNumerotationFor(Residue3D residue) throws AnalysisException {
        int numVal = residue.getAnnotations().get(0).getLocation().getStart();
        if (numVal > 999 || numVal < 1) {
            throw new AnalysisException("Sorry, due to limitation of the external algorithm used to perform this services, all residues numbers must be between 1 and 999");
        }
        return numVal;
    }
}

